/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.internal.UICUtils;

public final class ButtonMenu {
    private ButtonMenu() {
    }

    public static JToggleButton createButtonMenu(String string, Icon icon, List<JMenuItem> list) {
        return ButtonMenu.createButtonMenu(string, icon, list, null);
    }

    public static JToggleButton createButtonMenu(String string, Icon icon, List<JMenuItem> list, PopupMenuListener popupMenuListener) {
        return new ButtonMenuImpl(string, icon, list, popupMenuListener);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        ButtonMenu buttonMenu = new ButtonMenu();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        arrayList.add(new JMenuItem("Item 1"));
        arrayList.add(new JMenuItem("Item 2"));
        arrayList.add(new JMenuItem("Item 3"));
        JPanel jPanel = new JPanel();
        jPanel.add(new JTextField(12));
        jPanel.add(ButtonMenu.createButtonMenu("Text", OracleIcons.getIcon((String)"action.png"), arrayList));
        ArrayList<JMenuItem> arrayList2 = new ArrayList<JMenuItem>();
        arrayList2.add(new JMenuItem("Item 1"));
        arrayList2.add(new JMenuItem("Item 2"));
        arrayList2.add(new JMenuItem("Item 3"));
        jPanel.add(ButtonMenu.createButtonMenu("Text", null, arrayList2));
        ArrayList<JMenuItem> arrayList3 = new ArrayList<JMenuItem>();
        arrayList3.add(new JMenuItem("Item 1"));
        arrayList3.add(new JMenuItem("Item 2"));
        arrayList3.add(new JMenuItem("Item 3"));
        jPanel.add(ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"action.png"), arrayList3));
        UICUtils.runComponent((JComponent)jPanel);
        ArrayList<JMenuItem> arrayList4 = new ArrayList<JMenuItem>();
        arrayList4.add(new JMenuItem("Item 1"));
        arrayList4.add(new JMenuItem("Item 2"));
        arrayList4.add(new JMenuItem("Item 3"));
        jPanel.add(ButtonMenu.createButtonMenu(null, null, arrayList4));
        UICUtils.runComponent((JComponent)jPanel);
    }

    private static class ButtonMenuImpl
    extends JToggleButton {
        private static final Insets ICON_INSETS = new Insets(0, 0, 0, 4);
        private static final Insets TEXT_INSETS = new Insets(0, 2, 0, 2);
        private final PopupMenuListener listener;
        private final JPopupMenu popup = new JPopupMenu();
        private final Icon dropIcon;
        private static final int dropIconGap = 2;
        private static final int dropTextGap = 4;
        private final List<JMenuItem> items;

        ButtonMenuImpl(String string, Icon icon, List<JMenuItem> list, PopupMenuListener popupMenuListener) {
            super(string, icon);
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (listener != null) {
                        listener.popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    if (listener != null) {
                        listener.popupMenuCanceled(new PopupMenuEvent(this));
                    }
                }
            });
            this.dropIcon = OracleIcons.getIcon((String)"extras/dropdown.png");
            this.items = list;
            this.listener = popupMenuListener;
            this.setMargin(string == null ? ICON_INSETS : TEXT_INSETS);
            this.setHorizontalAlignment(2);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.toggle();
                }
            });
        }

        private void toggle() {
            if (this.isSelected()) {
                this.popup.removeAll();
                if (this.listener != null) {
                    this.listener.popupMenuWillBecomeVisible(new PopupMenuEvent(this));
                }
                this.createPopup(this.items);
                Point point = this.getLocationOnScreen();
                this.popup.pack();
                point.y += this.getHeight();
                SwingUtilities.convertPointFromScreen(point, this);
                this.popup.show(this, point.x, point.y);
            } else if (this.popup.isVisible()) {
                this.popup.setVisible(false);
                this.popup.removeAll();
            }
        }

        private void createPopup(List<JMenuItem> list) {
            for (JMenuItem jMenuItem : list) {
                if (jMenuItem == null) {
                    this.popup.addSeparator();
                    continue;
                }
                this.popup.add(jMenuItem);
            }
            this.popup.addPropertyChangeListener("visible", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!popup.isVisible() && this.isSelected()) {
                        this.setSelected(false);
                    }
                }
            });
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.dropIcon.paintIcon(this, graphics, this.getWidth() - this.getInsets().right - this.dropIcon.getIconWidth(), this.getHeight() / 2 - this.dropIcon.getIconHeight() / 2);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = dimension.width + (this.dropIcon.getIconWidth() + (this.getText() == null ? 2 : 4));
            dimension.height = Math.max(dimension.height, 20);
            return dimension;
        }
    }
}

