/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.olap.OLAPArb;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Format;
import oracle.olap.timegen.ui.wizard.TimeGenAttrLevelModel;
import oracle.olap.timegen.ui.wizard.TimeGenTableCheckBoxCellRenderer;
import oracle.olap.timegen.ui.wizard.TimeGenWizardPanel;

public class TimeGenAttrsPanel
extends TimeGenWizardPanel
implements ListSelectionListener {
    private List<TimeGenLevel> levels;
    private TimeGenAttrLevelModel timeGenAttrLevelModel = new TimeGenAttrLevelModel();
    private JTable attrsTable;
    private DefaultListModel levelListModel;
    private JList levelList;
    private JPanel attrTablePanel;
    private boolean isCreateTimeDimAndHierarchy;

    public TimeGenAttrsPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setName("multiLineTopLabel");
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("TIME_GEN_WIZARD_ATTRIBUTE_STEP_INSTRUCTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.getAttrPanel();
        this.add(jPanel, gridBagConstraints);
    }

    private JPanel getAttrPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("attrPanel ");
        this.attrTablePanel = this.getAttrTablePanel();
        JPanel jPanel2 = this.getLevelsPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, this.attrTablePanel);
        jSplitPane.setName("splitPane");
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.1);
        jPanel.add((Component)jSplitPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel getLevelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("levelsPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_ATTRIBUTE_STEP_LEVEL_TYPE"));
        jLabel.setName("levelLbl");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.levelListModel = new DefaultListModel();
        this.levelList = new JList(this.levelListModel);
        this.levelList.setSelectionMode(0);
        this.levelList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.levelList);
        jScrollPane.setName("scrollPane");
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel getAttrTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("attrTablePanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(OLAPArb.get("TIME_GEN_WIZARD_ATTRIBUTE_STEP_APPLIES_TO"));
        jLabel.setName("applyTo");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.attrsTable = new JTable((TableModel)((Object)this.timeGenAttrLevelModel));
        TableColumn tableColumn = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.SELECTED_COLUMN);
        tableColumn.setCellRenderer(new TimeGenTableCheckBoxCellRenderer());
        TableColumn tableColumn2 = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.FORMAT_COLUMN);
        tableColumn2.setCellEditor(new myAttrFormatCellEditor());
        this.timeGenAttrLevelModel.setTable(this.attrsTable);
        this.timeGenAttrLevelModel.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane(this.attrsTable);
        jScrollPane.setName("tablePane");
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void initializeData(TraversableContext traversableContext) {
        this.isCreateTimeDimAndHierarchy = (Boolean)traversableContext.get("SHOW_CREATE_DIMENSION_UI");
        this.levels = (List)traversableContext.get("LEVELS");
        this.levelList.removeListSelectionListener(this);
        this.levelListModel.clear();
        for (TimeGenLevel timeGenLevel : this.levels) {
            if (!timeGenLevel.isSelected().booleanValue()) continue;
            String string = timeGenLevel.getName();
            this.levelListModel.addElement(string);
        }
        this.levelList.addListSelectionListener(this);
        this.levelList.setSelectedIndex(0);
        TableColumn tableColumn = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.ATTRIBUTE_TYPE_COLUMN);
        if (!this.isCreateTimeDimAndHierarchy) {
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
    }

    @Override
    public void setContext(TraversableContext traversableContext) {
        traversableContext.put("LEVELS", this.levels);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        this.attrsTable.editingStopped(new ChangeEvent(this));
        String string = (String)this.levelList.getSelectedValue();
        for (TimeGenLevel object22 : this.levels) {
            if (!string.equalsIgnoreCase(object22.getName())) continue;
            this.timeGenAttrLevelModel = new TimeGenAttrLevelModel();
            object = object22.getAttributes();
            this.timeGenAttrLevelModel.setRowList((List)object);
            this.timeGenAttrLevelModel.setLevelType(object22.getType());
            this.timeGenAttrLevelModel.setFormats(object22.getFormats());
            break;
        }
        this.attrsTable.setModel((TableModel)((Object)this.timeGenAttrLevelModel));
        TableColumn tableColumn = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.SELECTED_COLUMN);
        tableColumn.setCellRenderer(new TimeGenTableCheckBoxCellRenderer());
        TableColumn tableColumn2 = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.FORMAT_COLUMN);
        tableColumn2.setCellEditor(new myAttrFormatCellEditor());
        object = this.attrsTable.getColumnModel().getColumn(this.timeGenAttrLevelModel.ATTRIBUTE_TYPE_COLUMN);
        if (!this.isCreateTimeDimAndHierarchy) {
            ((TableColumn)object).setMinWidth(0);
            ((TableColumn)object).setMaxWidth(0);
        }
        this.timeGenAttrLevelModel.setTable(this.attrsTable);
        this.timeGenAttrLevelModel.setEditable(true);
        this.attrsTable.repaint();
        this.attrTablePanel.repaint();
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initializeData(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateFields(traversableContext);
        this.setContext(traversableContext);
    }

    public Object getExitTransition() {
        return "SUMMARY";
    }

    @Override
    public void validateFields(TraversableContext traversableContext) {
    }

    class myAttrFormatCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboFormats;
        private String strFormat = "";

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = TimeGenAttrsPanel.this.timeGenAttrLevelModel.getLevelType();
            String string2 = (String)TimeGenAttrsPanel.this.timeGenAttrLevelModel.getValueAt(n, TimeGenAttrsPanel.this.timeGenAttrLevelModel.ATTRIBUTE_TYPE_COLUMN);
            if ((string2.equalsIgnoreCase("LONG_DESCRIPTION") || string2.equalsIgnoreCase("SHORT_DESCRIPTION") || string2.equalsIgnoreCase("DESCRIPTION")) && (string.equalsIgnoreCase("DAY") || string.equalsIgnoreCase("MONTH") || string.equalsIgnoreCase("QUARTER") || string.equalsIgnoreCase("HALF_YEAR") || string.equalsIgnoreCase("YEAR") || string.equalsIgnoreCase("TOP"))) {
                this.cboFormats = new JComboBox();
                this.cboFormats.setName("cboFormats");
                this.cboFormats.removeAllItems();
                this.cboFormats.setEditable(true);
                List<Format> list = TimeGenAttrsPanel.this.timeGenAttrLevelModel.getFormats();
                for (Format format : list) {
                    this.cboFormats.addItem(format.getFormat());
                }
                String string3 = (String)TimeGenAttrsPanel.this.timeGenAttrLevelModel.getValueAt(n, n2);
                this.cboFormats.setSelectedItem(string3);
                return this.cboFormats;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.cboFormats != null) {
                String string = (String)this.cboFormats.getEditor().getItem();
                String string2 = (String)this.cboFormats.getSelectedItem();
                this.strFormat = string != null && string.length() > 0 && !string.equals(string2) ? string : (String)this.cboFormats.getSelectedItem();
            }
            return this.strFormat;
        }
    }
}

