/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.Namespace;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.Database;
import oracle.olap.timegen.BaseTimeTableGenerator;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeLevel;

public class TimeTableGeneratorXML
extends BaseTimeTableGenerator {
    private Time time;

    public TimeTableGeneratorXML(Database database) {
        super(database);
    }

    public TimeTableGeneratorXML(Time time, Namespace namespace) {
        super(namespace);
        this.time = time;
    }

    public void addTime(Time time) {
        this.time = time;
    }

    @Override
    public String getTimeTableSQL() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.time == null) {
            try {
                object2 = "time.xml";
                object = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, (String)object2);
                JavaXMLBind.BindToJavaStr((String)object, "oracle.olap.timegen.timexml", this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = this.time.getTimeLevels();
        stringBuffer.append(this.getCreateTableSQL((List<TimeLevel>)object2));
        stringBuffer.append(";\n");
        object = this.getInsertIntoTableSQL((List<TimeLevel>)object2);
        object = (String)object + ";";
        Object object3 = new SimpleDateFormat("yyyy-MM-dd").format(this.startDate);
        object3 = "'" + (String)object3 + "'";
        String string = Integer.toString(this.numOfYears);
        object = ((String)object).replaceAll(":13", (String)object3);
        object = ((String)object).replaceAll(":12", string);
        object = ((String)object).replaceAll(":11", (String)object3);
        object = ((String)object).replaceAll(":10", (String)object3);
        object = ((String)object).replaceAll(":9", string);
        object = ((String)object).replaceAll(":8", (String)object3);
        object = ((String)object).replaceAll(":7", (String)object3);
        object = ((String)object).replaceAll(":6", (String)object3);
        object = ((String)object).replaceAll(":5", (String)object3);
        object = ((String)object).replaceAll(":4", (String)object3);
        object = ((String)object).replaceAll(":3", (String)object3);
        object = ((String)object).replaceAll(":2", (String)object3);
        object = ((String)object).replaceAll(":1", (String)object3);
        stringBuffer.append((String)object);
        String string2 = stringBuffer.toString();
        return string2;
    }

    @Override
    public void generateTimeTable() throws Exception {
        Object object;
        Object object2;
        if (this.time == null) {
            object2 = "time.xml";
            object = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, (String)object2);
            JavaXMLBind.BindToJavaStr((String)object, "oracle.olap.timegen.timexml", this);
        }
        object2 = "drop table " + this.getTableName();
        System.out.println((String)object2);
        try {
            this.database.executeSQL((String)object2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        object = this.time.getTimeLevels();
        String string = this.getCreateTableSQL((List<TimeLevel>)object);
        String string2 = this.getInsertIntoTableSQL((List<TimeLevel>)object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string3 = new SimpleDateFormat("yyyy-MM-dd").format(this.startDate);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(new Integer(this.numOfYears));
        arrayList.add(string3);
        arrayList.add(string3);
        arrayList.add(new Integer(this.numOfYears));
        arrayList.add(string3);
        Object[] objectArray = arrayList.toArray();
        this.database.executeSQL(string);
        System.out.println(string2);
        this.database.executeSQL(string2, objectArray);
    }

    private String getCreateTableSQL(List<TimeLevel> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table " + this.getTableName() + " (\n");
        block0: for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : this.levels) {
                String string2 = timeGenLevel.getType();
                boolean bl = timeGenLevel.isSelected();
                if (!string2.equalsIgnoreCase(string) || !bl) continue;
                block2: for (TimeColumn timeColumn : timeLevel.getTimeColumns()) {
                    String string3 = timeColumn.getColumn();
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list2 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list2) {
                        String string5 = timeGenAttribute.getName();
                        boolean bl2 = timeGenAttribute.isSelected();
                        if ((!string5.equalsIgnoreCase(string3) || !bl2) && !string4.equalsIgnoreCase("ID")) continue;
                        String string6 = string3.replace(string + "_", timeGenLevel.getName().toUpperCase() + "_");
                        stringBuffer.append("    " + string6);
                        stringBuffer.append(" " + timeColumn.getDataType() + ",\n");
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        return string;
    }

    private String getInsertIntoTableSQL(List<TimeLevel> list) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into " + this.getTableName() + "\n");
        stringBuffer.append("  select distinct\n");
        block0: for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            for (TimeGenLevel timeGenLevel : this.levels) {
                String string2 = timeGenLevel.getType();
                boolean bl2 = timeGenLevel.isSelected();
                if (!string2.equalsIgnoreCase(string) || !bl2) continue;
                if (string2.equalsIgnoreCase("DAY")) {
                    bl = true;
                }
                block2: for (TimeColumn timeColumn : timeLevel.getTimeColumns()) {
                    String string3 = timeColumn.getColumn();
                    String string4 = timeColumn.getAttribute();
                    List<TimeGenAttribute> list2 = timeGenLevel.getAttributes();
                    for (TimeGenAttribute timeGenAttribute : list2) {
                        String string5 = timeGenAttribute.getName();
                        boolean bl3 = timeGenAttribute.isSelected();
                        if ((!string5.equalsIgnoreCase(string3) || !bl3) && !string4.equalsIgnoreCase("ID")) continue;
                        String string6 = timeGenAttribute.getFormat();
                        String string7 = timeColumn.getSelectColumn();
                        if (string6 != null && string6.length() > 0) {
                            string7 = string7.replaceAll("\\$\\{FORMAT\\}", string6);
                        }
                        String string8 = string3.replace(string + "_", timeGenLevel.getName().toUpperCase() + "_");
                        stringBuffer.append("    " + string7 + " " + string8 + ",\n");
                        continue block2;
                    }
                }
                continue block0;
            }
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        stringBuffer.append("  from \n    ");
        stringBuffer.append(this.time.getTimeSQL().getSQL());
        stringBuffer.append("\n  ");
        if (bl) {
            stringBuffer.append(this.time.getOrderBy().getSQL());
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("hierarchy_prefix", "CAL");
        return string;
    }
}

