/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen;

import java.awt.Component;
import java.sql.Connection;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.timegen.ui.wizard.TimeGenWizMain;

public class TimeGenController
implements Controller {
    private Connection connection;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Element element = context.getElement();
        DBObjectProvider dBObjectProvider = DBObjectNodeUtil.findProvider((Object)element);
        String string = Connections.getActiveConnectionName();
        if (string != null && dBObjectProvider != null) {
            try {
                OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObjectProvider;
                String string2 = oracleDatabaseImpl.getUserName();
                this.connection = Connections.getInstance().getConnection(string, false);
                TimeGenWizMain timeGenWizMain = TimeGenWizMain.getInstance();
                timeGenWizMain.launchWizard(this.connection, string2, dBObjectProvider);
            }
            catch (DBException dBException) {
                Logger.severe(this.getClass(), (Throwable)dBException);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.get("CONNECTION_ERROR_MSG"), OLAPArb.get("CONNECTION_ERROR_TITLE"), 0);
                ideAction.setEnabled(false);
                return true;
            }
        } else {
            ideAction.setEnabled(false);
            return true;
        }
        ideAction.setEnabled(true);
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        Element element = context.getElement();
        DBObjectProvider dBObjectProvider = DBObjectNodeUtil.findProvider((Object)element);
        String string = Connections.getActiveConnectionName();
        if (string != null && dBObjectProvider != null && Connections.getInstance().isConnectionOpenFast(string)) {
            ideAction.setEnabled(true);
            return true;
        }
        ideAction.setEnabled(false);
        return true;
    }
}

