/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers.language;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.SqlTokens;
import oracle.javatools.parser.plsql.syntax.ParserException;
import oracle.javatools.parser.util.KeywordTable;

abstract class BaseOLAPILexer
extends AbstractLexer
implements SqlTokens {
    protected static final int CONTEXT_SIZE = 5;
    private static final int FL_WHITESPACE = 0x1000000;
    private static final int FL_SIMPLE_OP = 0x2000000;
    private static final int FL_ID_START = 0x4000000;
    private static final int FL_ID_PART = 0x8000000;
    private static final int FL_DIGIT = 0x10000000;
    private static final int MASK_TK = 255;
    protected static final int TK_NOT_FOUND = -1;
    private static int[] lookupTable;
    protected int lastToken;
    protected int startOffset;
    protected int endOffset;
    protected int hash;
    private boolean skipComments;
    private KeywordTable keywordTable;

    protected BaseOLAPILexer(KeywordTable keywordTable) {
        this.keywordTable = keywordTable;
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
        this.skipComments = false;
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    public int lex(LexerToken lexerToken) {
        block59: {
            this.lastToken = 0;
            try {
                block28: while (true) {
                    char c;
                    this.startOffset = this.currentPos;
                    if ((c = this.textBuffer.getChar(this.currentPos++)) < '\u0100') {
                        int n = lookupTable[c];
                        if ((n & 0x1000000) != 0) continue;
                        if ((n & 0x4000000) != 0) {
                            this.handleIdentifier(c);
                            break;
                        }
                        if ((n & 0x2000000) != 0) {
                            this.lastToken = n & 0xFF;
                            break;
                        }
                        if ((n & 0x10000000) != 0) {
                            this.lastToken = 32;
                            this.skipNumericLiteral(c);
                            break;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '(': {
                            this.lastToken = 80;
                            if (this.textBuffer.getChar(this.currentPos) == '+' && this.textBuffer.getChar(this.currentPos + 1) == ')') {
                                this.lastToken = 98;
                                this.currentPos += 2;
                                break block28;
                            }
                            break block59;
                        }
                        case '!': {
                            this.lastToken = 95;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 85;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case '~': {
                            this.lastToken = 8;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 87;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case '^': {
                            this.lastToken = 8;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 86;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case '|': {
                            this.lastToken = 88;
                            if (this.textBuffer.getChar(this.currentPos) == '|') {
                                this.lastToken = 68;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case '.': {
                            this.lastToken = 72;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '.') {
                                this.lastToken = 71;
                                ++this.currentPos;
                                if (this.textBuffer.getChar(this.currentPos) == '.') {
                                    this.lastToken = 73;
                                    ++this.currentPos;
                                    break block28;
                                }
                            } else if (BaseOLAPILexer.isDecimalDigit(c)) {
                                this.lastToken = 32;
                                this.skipFloatLiteral();
                                break block28;
                            }
                            break block59;
                        }
                        case '*': {
                            this.lastToken = 97;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 75;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case ':': {
                            this.lastToken = 69;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '=') {
                                this.lastToken = 66;
                                ++this.currentPos;
                                break block28;
                            }
                            if (c < '\u0100') {
                                if ((lookupTable[c] & 0x14000000) != 0) {
                                    this.lastToken = 18;
                                }
                            } else if (Character.isJavaIdentifierStart(c)) {
                                this.lastToken = 18;
                            }
                            if (this.lastToken == 18) {
                                ++this.currentPos;
                                while (!((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' ? (lookupTable[c] & 0x8000000) == 0 : !Character.isJavaIdentifierPart(c))) {
                                    ++this.currentPos;
                                }
                                break block28;
                            }
                            break block59;
                        }
                        case '=': {
                            this.lastToken = 74;
                            if (this.textBuffer.getChar(this.currentPos) == '>') {
                                this.lastToken = 65;
                                ++this.currentPos;
                                break block28;
                            }
                            break block59;
                        }
                        case '/': {
                            this.lastToken = 96;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 49;
                                ++this.currentPos;
                                this.skipMultiLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block28;
                                }
                            }
                            break block59;
                        }
                        case '-': {
                            this.lastToken = 83;
                            if (this.textBuffer.getChar(this.currentPos) == '-') {
                                this.lastToken = 48;
                                ++this.currentPos;
                                this.skipLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block28;
                                }
                            }
                            break block59;
                        }
                        case '>': {
                            this.lastToken = 76;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '>': {
                                    this.lastToken = 93;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '=': {
                                    this.lastToken = 77;
                                    ++this.currentPos;
                                }
                            }
                            break block28;
                        }
                        case '<': {
                            this.lastToken = 79;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '<': {
                                    this.lastToken = 82;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '>': {
                                    this.lastToken = 84;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '=': {
                                    this.lastToken = 81;
                                    ++this.currentPos;
                                }
                            }
                            break block28;
                        }
                        case '\'': {
                            this.lastToken = 33;
                            this.skipStringLiteral();
                            break block28;
                        }
                        case '\"': {
                            this.lastToken = 16;
                            this.skipQuotedIdentifier();
                            break block28;
                        }
                        default: {
                            if (Character.isJavaIdentifierStart(c)) {
                                this.handleIdentifier(c);
                                break block28;
                            }
                            this.lastToken = 0;
                            continue block28;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                int n;
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                } else if (this.lastToken == 16 && (n = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, this.hash)) != -1) {
                    this.lastToken = n;
                }
                if (!this.skipComments || this.lastToken != 48 && this.lastToken != 49) break block59;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        throw new ParserException("Unsupported operation");
    }

    protected final void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '\'') {
                        return;
                    }
                    ++this.currentPos;
                }
            }
        }
    }

    protected final void skipQuotedStringLiteral() {
        char c;
        this.lastToken = 33;
        ++this.currentPos;
        char c2 = this.textBuffer.getChar(this.currentPos++);
        switch (c2) {
            case '{': {
                c = '}';
                break;
            }
            case '(': {
                c = ')';
                break;
            }
            case '<': {
                c = '>';
                break;
            }
            case '[': {
                c = ']';
                break;
            }
            default: {
                if (Character.isWhitespace(c2)) {
                    return;
                }
                c = c2;
            }
        }
        char c3 = this.textBuffer.getChar(this.currentPos++);
        while (true) {
            if (c3 != c) {
                c3 = this.textBuffer.getChar(this.currentPos++);
                continue;
            }
            if ((c3 = this.textBuffer.getChar(this.currentPos++)) == '\'') break;
        }
    }

    private void skipQuotedIdentifier() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipNumericLiteral(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.skipDecimalDigits();
                n = this.textBuffer.getChar(this.currentPos);
                switch (n) {
                    case 46: {
                        this.lastToken = 32;
                        n = this.textBuffer.getChar(this.currentPos + 1);
                        this.lastToken = 32;
                        if (n == 46) break;
                        ++this.currentPos;
                        this.lastToken = 32;
                        this.skipFloatLiteral();
                        break;
                    }
                    case 69: 
                    case 101: {
                        this.lastToken = 32;
                        this.skipFloatLiteral();
                    }
                }
                break;
            }
            case 46: {
                ++this.currentPos;
                this.lastToken = 32;
                this.skipFloatLiteral();
            }
        }
    }

    private void skipFloatLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        while (BaseOLAPILexer.isDecimalDigit(c)) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (BaseOLAPILexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (BaseOLAPILexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void handleIdentifier(char c) {
        int n;
        char c2 = c;
        this.lastToken = 16;
        this.hash = KeywordTable.computeInsensitivePartialHash((char)c, (int)0);
        while (!((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' ? ((n = lookupTable[c]) & 0x8000000) == 0 : !Character.isJavaIdentifierPart(c))) {
            this.hash = KeywordTable.computeInsensitivePartialHash((char)c, (int)this.hash);
            ++this.currentPos;
        }
        String string = this.textBuffer.getString(this.startOffset, this.currentPos - this.startOffset);
        if ("rem".equalsIgnoreCase(string)) {
            this.skipLineComment();
            return;
        }
        int n2 = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, this.hash);
        if (n2 != -1) {
            this.lastToken = n2;
        }
        if (c != '\'') {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n3 = this.currentPos - this.startOffset;
        switch (n3) {
            case 1: {
                switch (c2) {
                    case 'Q': 
                    case 'q': {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 'N': 
                    case 'U': 
                    case 'n': 
                    case 'u': {
                        bl = true;
                    }
                }
                break;
            }
            case 2: {
                char c3;
                if (c2 != 'n' && c2 != 'N' && c2 != 'u' && c2 != 'U' || (c3 = this.textBuffer.getChar(this.startOffset + 1)) != 'q' && c3 != 'Q') break;
                bl = true;
                bl2 = true;
            }
        }
        if (bl) {
            if (bl2) {
                this.skipQuotedStringLiteral();
            } else {
                this.skipStringLiteral();
            }
        }
    }

    private int fillLexerToken(LexerToken lexerToken) {
        if (lexerToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    protected void save_context(Context context) {
        context.currentPos = this.currentPos;
        context.lastToken = this.lastToken;
        context.startOffset = this.startOffset;
        context.endOffset = this.endOffset;
        context.hash = this.hash;
    }

    protected void restore_context(Context context) {
        this.currentPos = context.currentPos;
        this.lastToken = context.lastToken;
        this.startOffset = context.startOffset;
        this.endOffset = context.endOffset;
        this.hash = context.hash;
    }

    private static void initLookup() {
        lookupTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = 0;
            if (Character.isWhitespace((char)i)) {
                n |= 0x1000000;
            }
            if (Character.isJavaIdentifierStart((char)i)) {
                n |= 0x4000000;
            }
            if (Character.isJavaIdentifierPart((char)i) || i == 35) {
                n |= 0x8000000;
            }
            if (Character.isDigit((char)i)) {
                n |= 0x10000000;
            }
            BaseOLAPILexer.lookupTable[i] = n;
        }
        BaseOLAPILexer.setSimpleOp(38, 64);
        BaseOLAPILexer.setSimpleOp(43, 90);
        BaseOLAPILexer.setSimpleOp(37, 89);
        BaseOLAPILexer.setSimpleOp(41, 92);
        BaseOLAPILexer.setSimpleOp(44, 70);
        BaseOLAPILexer.setSimpleOp(64, 67);
        BaseOLAPILexer.setSimpleOp(59, 94);
        BaseOLAPILexer.setSimpleOp(91, 78);
        BaseOLAPILexer.setSimpleOp(93, 91);
    }

    private static void setSimpleOp(int n, int n2) {
        int n3 = n;
        lookupTable[n3] = lookupTable[n3] | (0x2000000 | n2 & 0xFF);
    }

    static {
        BaseOLAPILexer.initLookup();
    }

    protected static class Context {
        protected int currentPos;
        protected int lastToken;
        protected int startOffset;
        protected int endOffset;
        protected int hash;

        protected Context() {
        }
    }
}

