/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers;

import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseException;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.olapihelpers.WrappedSyntaxVisitor;
import oracle.olapi.syntax.SyntaxObject;

public class WrappedSyntaxParser
extends OLAPISyntaxParser {
    private final int DUMMY_OFFSET;
    private final String wrapper;
    private String unwrappedSyntax;

    public WrappedSyntaxParser(Schema schema, Properties properties, String string) {
        super(schema, properties, new WrappedSyntaxVisitor(string.indexOf("%s")));
        this.wrapper = string;
        this.DUMMY_OFFSET = string.indexOf("%s");
    }

    @Override
    public String formatSyntax(String string) {
        String string2 = null;
        string2 = string == null ? this.syntax : String.format(this.wrapper, string);
        try {
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string2, null);
            string2 = syntaxObject.toSyntax();
            int n = string2.indexOf(40) + 2;
            int n2 = string2.lastIndexOf(41) - 1;
            string2 = string2.substring(n, n2);
            Pattern pattern = Pattern.compile("^  ", 10);
            Matcher matcher = pattern.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    @Override
    public void setSyntax(String string) {
        if (string == null) {
            super.setSyntax("");
        } else {
            String string2 = string.toUpperCase();
            String string3 = String.format(this.wrapper, string2);
            super.setSyntax(string3);
            this.unwrappedSyntax = string;
        }
    }

    @Override
    public int[] getTokenBoundaries(int n) {
        int[] nArray = super.getTokenBoundaries(n + this.DUMMY_OFFSET);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] - this.DUMMY_OFFSET;
        }
        return nArray2;
    }

    @Override
    public ParseNode getParseNode(int n, int n2) {
        return super.getParseNode(n, n2, this.unwrappedSyntax);
    }

    @Override
    protected void notifyTokenCallback(SyntaxTokenListener syntaxTokenListener, String string, Type type, int n) {
        super.notifyTokenCallback(syntaxTokenListener, string, type, n - this.DUMMY_OFFSET);
    }

    @Override
    public boolean parseSyntax(ParseNode parseNode) {
        boolean bl;
        if (parseNode == null) {
            parseNode = new ParseNode();
        }
        if (bl = super.parseSyntax(parseNode)) {
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                ParseNode serializable = (ParseNode)enumeration.nextElement();
                serializable.setOffset(serializable.getOffset() - this.DUMMY_OFFSET);
                serializable.setEnd(serializable.getEnd() - this.DUMMY_OFFSET);
                serializable.setReplaceBounds(serializable.getReplaceOffset() - this.DUMMY_OFFSET, serializable.getReplaceEnd() - this.DUMMY_OFFSET, this.unwrappedSyntax);
            }
        }
        for (Throwable throwable : this.getExceptions()) {
            if (!(throwable instanceof ParseException)) continue;
            ParseException parseException = (ParseException)throwable;
            parseException.setOffset(parseException.getOffset() - this.DUMMY_OFFSET);
        }
        return bl;
    }

    @Override
    public boolean parseSyntax(String string, ParseNode parseNode) {
        String string2 = this.unwrappedSyntax;
        this.unwrappedSyntax = string;
        boolean bl = super.parseSyntax(String.format(this.wrapper, string), parseNode);
        this.unwrappedSyntax = string2;
        return bl;
    }

    @Override
    public String getSyntax() {
        return this.unwrappedSyntax;
    }

    public String getWrapper() {
        return this.wrapper;
    }
}

