/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.SyntaxTokenListener;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class CalculatedMeasureFoldingModel
extends DefaultCodeFoldingModel<DefaultFoldingBlock<DefaultFoldingBlock, String>>
implements CodeEditorTextListener,
SyntaxTokenListener {
    private BasicDocument document;
    private SyntaxParser parser;
    private InsertionHandlerEditorPlugin ihandler;
    private DefaultFoldingBlock<DefaultFoldingBlock, String> currentBlock;
    private DefaultFoldingBlock<DefaultFoldingBlock, String> newRoot;
    private static final Logger LOG = Logger.getLogger(CalculatedMeasureFoldingModel.class.getName());

    CalculatedMeasureFoldingModel(BasicDocument basicDocument, SyntaxParser syntaxParser, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin) {
        super(basicDocument);
        this.document = basicDocument;
        this.parser = syntaxParser;
        this.ihandler = insertionHandlerEditorPlugin;
        insertionHandlerEditorPlugin.addCodeEditorTextListener(this);
        this.reload();
    }

    public Iterator<DefaultFoldingBlock<DefaultFoldingBlock, String>> getChildren(DefaultFoldingBlock defaultFoldingBlock) {
        return defaultFoldingBlock.getChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        try {
            DefaultFoldingBlock defaultFoldingBlock;
            DefaultFoldingBlock defaultFoldingBlock2;
            Object object;
            DefaultFoldingBlock defaultFoldingBlock3;
            this.newRoot = new DefaultFoldingBlock(0, 0, "", true);
            this.currentBlock = this.newRoot;
            this.parser.tokenize(this);
            this.newRoot.setEndOffset(this.document.getLength());
            while (this.currentBlock != this.newRoot && this.currentBlock != null) {
                if (this.currentBlock.getStartOffset() != this.currentBlock.getEndOffset()) continue;
                defaultFoldingBlock3 = (DefaultFoldingBlock)this.currentBlock.getParent();
                defaultFoldingBlock3.remove(this.currentBlock);
                object = this.currentBlock.getChildren();
                defaultFoldingBlock2 = new LinkedList();
                this.currentBlock = defaultFoldingBlock3;
                if (object.hasNext()) {
                    defaultFoldingBlock = (DefaultFoldingBlock)object.next();
                    while (object.hasNext()) {
                        defaultFoldingBlock2.add(defaultFoldingBlock);
                        defaultFoldingBlock = (DefaultFoldingBlock)object.next();
                    }
                }
                while (!defaultFoldingBlock2.isEmpty()) {
                    defaultFoldingBlock3.add((FoldingBlock)((DefaultFoldingBlock)defaultFoldingBlock2.poll()));
                }
            }
            try {
                this.readLock();
                defaultFoldingBlock3 = new LinkedList();
                object = new LinkedList<DefaultFoldingBlock<DefaultFoldingBlock, String>>();
                defaultFoldingBlock3.add(this.root);
                ((LinkedList)object).add(this.newRoot);
                while (!((AbstractCollection)object).isEmpty() && !defaultFoldingBlock3.isEmpty()) {
                    defaultFoldingBlock2 = (DefaultFoldingBlock)defaultFoldingBlock3.pop();
                    defaultFoldingBlock = (DefaultFoldingBlock)((LinkedList)object).pop();
                    if (defaultFoldingBlock2.getStartOffset() == defaultFoldingBlock.getStartOffset() && defaultFoldingBlock2.getEndOffset() == defaultFoldingBlock.getEndOffset()) {
                        defaultFoldingBlock.setExpanded(defaultFoldingBlock2.isExpanded());
                    }
                    this.addAll((LinkedList<DefaultFoldingBlock>)defaultFoldingBlock3, defaultFoldingBlock2.getChildren());
                    this.addAll((LinkedList<DefaultFoldingBlock>)object, defaultFoldingBlock.getChildren());
                }
            }
            finally {
                this.readUnlock();
            }
            this.setRoot(this.newRoot);
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, "Error Creating folding model", throwable);
        }
    }

    @Override
    public void textChanged(String string) {
    }

    @Override
    public void syntaxChecked(String string, boolean bl) {
        this.reload();
    }

    @Override
    public void processToken(String string, String string2, int n) {
        Type type = Type.valueFrom(string2);
        if (type == Type.PAREN) {
            if (string.equals("(")) {
                DefaultFoldingBlock defaultFoldingBlock = new DefaultFoldingBlock(n, n, "(...)", true);
                if (this.currentBlock.getEndOffset() == this.currentBlock.getStartOffset()) {
                    this.currentBlock.add((FoldingBlock)defaultFoldingBlock);
                } else {
                    ((DefaultFoldingBlock)this.currentBlock.getParent()).add((FoldingBlock)defaultFoldingBlock);
                }
                this.currentBlock = defaultFoldingBlock;
            } else if (string.equals(")") && this.currentBlock.getEndOffset() == this.currentBlock.getStartOffset() && this.currentBlock != this.newRoot) {
                this.currentBlock.setEndOffset(n + 1);
                this.currentBlock = (DefaultFoldingBlock)this.currentBlock.getParent();
            }
        }
    }

    private void addAll(LinkedList<DefaultFoldingBlock> linkedList, Iterator<DefaultFoldingBlock> iterator) {
        while (iterator.hasNext()) {
            linkedList.push(iterator.next());
        }
    }
}

