/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.editor.plugins.DropTargetPlugin;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.shuttle.DropHandler;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;

public class CalculatedMeasureDropPlugin
extends DropTargetPlugin {
    private static final Logger LOG = Logger.getLogger(CalculatedMeasureDropPlugin.class.getName());
    private DropHandler dropHandler;

    public CalculatedMeasureDropPlugin(TemplateHandler templateHandler, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin) {
        this.dropHandler = new DropHandler<DropTargetDropEvent>(templateHandler, insertionHandlerEditorPlugin){

            @Override
            protected Object getData(DataFlavor dataFlavor, DropTargetDropEvent dropTargetDropEvent) {
                try {
                    return dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Unable to get Data for Transfer", exception);
                    return null;
                }
            }

            @Override
            protected boolean isFlavorAvailable(DataFlavor dataFlavor, DropTargetDropEvent dropTargetDropEvent) {
                return dropTargetDropEvent.isDataFlavorSupported(dataFlavor);
            }
        };
    }

    protected boolean isDataFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        return this.dropHandler.canHandleDrop(dropTargetDragEvent.getCurrentDataFlavors());
    }

    protected boolean isDataFlavorSupported(DropTargetDropEvent dropTargetDropEvent) {
        return this.dropHandler.canHandleDrop(dropTargetDropEvent.getCurrentDataFlavors());
    }

    protected void handleDropEvent(DropTargetDropEvent dropTargetDropEvent) {
        this.dropHandler.handleDrop(dropTargetDropEvent);
    }

    protected boolean isDropActionSupported(int n) {
        return (n & 3) != 0;
    }
}

