/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.editor.plugins;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.templates.templatedialog.TemplateGUI;
import oracle.olap.syntaxbuilder.DelayedTask;
import oracle.olap.syntaxbuilder.DelayedTimer;
import oracle.olap.syntaxbuilder.editor.CodeSelectionListener;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.specification.Spec;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class CalcSelectionEditorPlugin
implements EditorPlugin {
    private static final Logger LOG = Logger.getLogger(CalcSelectionEditorPlugin.class.getName());
    private BasicEditorPane text;
    private EventListenerList listenerList = new EventListenerList();
    private SyntaxParser parser;
    private Spec spec;
    private DelayedTimer caretTimer;
    private HighlightLayer innerSel;
    private HighlightStyle style;
    private ParseNode innerExpression;
    private Properties props;
    private final String CONSISTENT_SOLVE_KEYWORD = "SOLVE";
    private final String BUILD_SPEC_DUMMY_NAME = "DUMMYNAME";

    public CalcSelectionEditorPlugin(Spec spec, SyntaxParser syntaxParser) {
        this(spec, syntaxParser, null);
    }

    public CalcSelectionEditorPlugin(Spec spec, SyntaxParser syntaxParser, Properties properties) {
        this.spec = spec;
        this.parser = syntaxParser;
        this.props = properties;
    }

    private String getText(int n, int n2) throws BadLocationException {
        if (n > 0 && n + n2 < this.text.getDocument().getLength()) {
            return this.text.getDocument().getText(n, n2);
        }
        return "";
    }

    public ParseNode getInnerExpression() {
        return this.innerExpression;
    }

    public void install(BasicEditorPane basicEditorPane) {
        long l = System.currentTimeMillis();
        this.caretTimer = new DelayedTimer(new DelayedTask(){

            @Override
            public void doTask() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalcSelectionEditorPlugin.this.checkCaret();
                    }
                });
            }
        }, 800L);
        this.caretTimer.start();
        this.text = basicEditorPane;
        this.innerSel = this.text.createHighlightLayer();
        this.style = this.text.getHighlightRegistry().lookupStyle("syntaxbuilder.inner_selection");
        CustomCaret customCaret = new CustomCaret();
        int n = this.text.getCaret().getBlinkRate();
        customCaret.setBlinkRate(n);
        customCaret.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }
        });
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CalcSelectionEditorPlugin.this.selectionChanged();
            }
        });
        this.text.setCaret((Caret)((Object)customCaret));
        LOG.finest(String.format("installed calc selection: %s%n", System.currentTimeMillis() - l));
    }

    private void selectionChanged() {
        if (!this.text.isEditable()) {
            return;
        }
        this.innerExpression = null;
        this.caretTimer.requestTask(false);
        this.innerSel.removeAllHighlights();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.caretTimer.cancelTask();
        this.listenerList = new EventListenerList();
        this.text.destroyHighlightLayer(this.innerSel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void checkCaret() {
        try {
            Object object;
            Object object2;
            boolean bl;
            int n = this.text.getSelectionStart();
            int n2 = this.text.getSelectionEnd();
            if (n2 == n && this.props != null && (bl = Boolean.parseBoolean(this.props.getProperty("ONECLICK_TEMPLATE_DISPLAY", Boolean.toString(false)))) && (object2 = this.parser.getParseNode(n2, n2)) != null) {
                object = null;
                while (object2 != null && (object = this.spec.findMatchingNode((ParseNode)object2)) == null) {
                    object2 = (ParseNode)((DefaultMutableTreeNode)object2).getParent();
                }
                if (object != null) {
                    n = ((ParseNode)object2).getOffset();
                    n2 = ((ParseNode)object2).getReplaceEnd();
                }
            }
            if (n2 != n) {
                Object object3;
                if (this.parser.isValid()) {
                    object3 = this.parser.getParseNode(n, n2);
                } else {
                    object3 = new ParseNode();
                    object3 = this.parser.parseSyntax(this.text.getSelectedText(), (ParseNode)object3) && ((DefaultMutableTreeNode)object3).getChildCount() > 0 ? (((String)(object = ((ParseNode)(object2 = (ParseNode)((ParseNode)object3).getChildren().get(0))).getFullValue())).equalsIgnoreCase("SOLVE") || ((String)object).equalsIgnoreCase("DUMMYNAME") ? (ParseNode)((ParseNode)object2).getChildren().get(0) : object2) : null;
                }
                if (object3 != null) {
                    LOG.finest(String.format("ParseNode selected %s,%s, [%s,%s]", ((DefaultMutableTreeNode)object3).getUserObject(), ((ParseNode)object3).getType(), ((ParseNode)object3).getOffset(), ((ParseNode)object3).getReplaceEnd()));
                    object2 = this.spec.findMatchingNode((ParseNode)object3);
                    object = this.parser.getSyntax();
                    if (object2 != null) {
                        TemplateGUI templateGUI = ((SpecTreeNode)object2).getTemplateHelper().getGUI(true);
                        templateGUI.loadParseNode((ParseNode)object3, (String)object);
                        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object3).breadthFirstEnumeration();
                        if (enumeration.hasMoreElements()) {
                            enumeration.nextElement();
                        }
                        while (enumeration.hasMoreElements()) {
                            ParseNode parseNode = (ParseNode)enumeration.nextElement();
                            String string = parseNode.getType();
                            if (!Type.FUNCTION.toString().equals(string)) continue;
                            this.innerSel.removeAllHighlights();
                            this.innerSel.addHighlight(this.style, parseNode.getReplaceOffset(), parseNode.getReplaceEnd());
                            this.innerExpression = parseNode;
                            break;
                        }
                    }
                    this.fireTokenSelected((String)object, n, (ParseNode)object3, (SpecTreeNode)object2);
                    return;
                }
            }
            int[] nArray = this.parser.getTokenBoundaries(n);
            object2 = "";
            if (nArray.length == 3) {
                object2 = this.getText(nArray[0], nArray[2] - nArray[0]);
                n = nArray[0];
            }
            this.fireTokenSelected((String)object2, n, null, null);
        }
        catch (Exception exception) {
            LOG.log(Level.FINEST, "Issues handling caret changes", exception);
        }
    }

    public void addCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.listenerList.add(CodeSelectionListener.class, codeSelectionListener);
    }

    public void removeCodeSelectionListener(CodeSelectionListener codeSelectionListener) {
        this.listenerList.remove(CodeSelectionListener.class, codeSelectionListener);
    }

    private void fireTokenSelected(String string, int n, ParseNode parseNode, SpecTreeNode specTreeNode) throws SQLException, IOException {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeSelectionListener.class) continue;
            ((CodeSelectionListener)objectArray[i + 1]).tokenSelected(string, n, parseNode, specTreeNode);
        }
    }

    private void fireSyntaxClicked(MouseEvent mouseEvent, ParseNode parseNode) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CodeSelectionListener.class) continue;
            ((CodeSelectionListener)objectArray[i + 1]).syntaxClicked(mouseEvent, parseNode);
        }
    }

    private class CustomCaret
    extends BasicCaret {
        int oldPosition = -1;
        boolean unblinking = false;

        private CustomCaret() {
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.unblinking = false;
        }

        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.unblinking = true;
        }

        public boolean isVisible() {
            return this.unblinking || super.isVisible();
        }

        public void mouseClicked(final MouseEvent mouseEvent) {
            ParseNode parseNode;
            boolean bl = true;
            int n = mouseEvent.getClickCount();
            if ((n == 2 || n == 3) && (parseNode = CalcSelectionEditorPlugin.this.parser.getParseNode(this.oldPosition, this.oldPosition)) != null) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    int n2;
                    int n3;
                    if (n == 2) {
                        if (this.oldPosition < parseNode.getOffset() || this.oldPosition > parseNode.getEnd()) {
                            return;
                        }
                        n3 = parseNode.getOffset();
                        n2 = parseNode.getEnd();
                    } else {
                        defaultMutableTreeNode = null;
                        while (parseNode != null && (defaultMutableTreeNode = CalcSelectionEditorPlugin.this.spec.findMatchingNode(parseNode)) == null) {
                            parseNode = (ParseNode)parseNode.getParent();
                        }
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        n3 = parseNode.getOffset();
                        n2 = parseNode.getReplaceEnd();
                    }
                    bl = false;
                    CalcSelectionEditorPlugin.this.text.setCaretPosition(n3);
                    CalcSelectionEditorPlugin.this.text.moveCaretPosition(n2);
                    defaultMutableTreeNode = parseNode;
                    SwingUtilities.invokeLater(new Runnable((ParseNode)defaultMutableTreeNode){
                        final /* synthetic */ ParseNode val$finalNode;
                        {
                            this.val$finalNode = parseNode;
                        }

                        @Override
                        public void run() {
                            CalcSelectionEditorPlugin.this.fireSyntaxClicked(mouseEvent, this.val$finalNode);
                        }
                    });
                    LOG.finest(String.format("Selected parse node %d, [%d,%d,%d]", mouseEvent.getClickCount(), parseNode.getOffset(), parseNode.getEnd(), parseNode.getReplaceEnd()));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
            if (bl && n <= 2) {
                super.mouseClicked(mouseEvent);
            }
            if (n == 1) {
                this.oldPosition = CalcSelectionEditorPlugin.this.text.getCaretPosition();
            }
        }
    }
}

