/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class TableCellButtonWrapper
implements TableCellEditor,
TableCellRenderer {
    private TableCellEditor editor;
    private TableCellRenderer renderer;
    private JPanel wrap;
    private int row;
    private int column;

    public TableCellButtonWrapper(TableCellRenderer tableCellRenderer, Icon icon) {
        this.renderer = tableCellRenderer;
        this.buildWrapper(icon);
    }

    public TableCellButtonWrapper(TableCellEditor tableCellEditor, Icon icon) {
        this.editor = tableCellEditor;
        this.buildWrapper(icon);
    }

    private void buildWrapper(Icon icon) {
        this.wrap = new JPanel(new BorderLayout());
        JButton jButton = new JButton(icon);
        Dimension dimension = new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 6);
        jButton.setSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableCellButtonWrapper.this.cancelCellEditing();
                TableCellButtonWrapper.this.buttonPress();
            }
        });
        this.wrap.add((Component)jButton, "East");
    }

    public abstract void buttonPress();

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.wrap.add(this.editor.getTableCellEditorComponent(jTable, object, bl, n, n2), "Center");
        this.row = n;
        this.column = n2;
        return this.wrap;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.wrap.add(this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2), "Center");
        return this.wrap;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.editor.isCellEditable(eventObject);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.editor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.removeCellEditorListener(cellEditorListener);
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }
}

