/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.db.view.GeneralBaseEditorPanel;
import oracle.olap.security.ACEAccessSettingPanel;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.AccessControlList;
import oracle.olap.security.AccessControlListInitializer;
import oracle.olap.security.UserSelectionDialog;

public class AccessControlListGeneralPanel
extends GeneralBaseEditorPanel<AccessControlList> {
    private JTextField descTxtFld;
    private ACEAccessSettingPanel m_aceAccessPanel;
    private Connection connection;
    private Window parent;
    private Resources resources = new OLAPResources();

    public AccessControlListGeneralPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new AccessControlListInitializer());
    }

    private void layoutComponents() {
        this.registerDescriptionFields();
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("AccessControlListGeneralPanel.topPanel");
        int n = this.layoutDescriptionFields(jPanel);
        this.add(jPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_aceAccessPanel = new ACEAccessSettingPanel((JPanel)((Object)this));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.add(jPanel2, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JButton jButton = new JButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_ADD_USER_BUTTON"));
        JButton jButton2 = new JButton(this.resources.getString("GENERAL_DATA_SECURITY_PANEL_REMOVE_USER_BUTTON"));
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)jButton);
        buttonBar.add((Component)jButton2);
        jPanel2.add((Component)this.m_aceAccessPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 3, 0), 0, 0));
        jPanel2.add((Component)buttonBar, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 15, 2, new Insets(5, 0, 3, 0), 0, 0));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccessControlListGeneralPanel.this.m_aceAccessPanel.removeRowFromTable();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<String> list = AccessControlListGeneralPanel.this.m_aceAccessPanel.getCurrentUsersInTable();
                List<String> list2 = AccessControlListGeneralPanel.this.m_aceAccessPanel.getCurrentRolesInTable();
                List<String> list3 = null;
                UserSelectionDialog userSelectionDialog = new UserSelectionDialog(AccessControlListGeneralPanel.this.connection, AccessControlListGeneralPanel.this.parent, list, list2, list3, false);
                userSelectionDialog.setVisible(true);
                List<UserSelectionDialog.UserNode> list4 = userSelectionDialog.getSelection();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (UserSelectionDialog.UserNode userNode : list4) {
                    int n = userNode.getType();
                    String string = userNode.getName();
                    if (userNode.isUserType()) {
                        arrayList.add(string);
                        continue;
                    }
                    if (n == 2) {
                        arrayList2.add(string);
                        continue;
                    }
                    if (n != 3) continue;
                    arrayList3.add(string);
                }
                AccessControlListGeneralPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList, "Users");
                AccessControlListGeneralPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList2, "Roles");
                AccessControlListGeneralPanel.this.m_aceAccessPanel.updateTableWithSelectedUsers(arrayList3, "DSACL");
            }
        });
    }

    @Override
    protected int layoutDescriptionFields(JPanel jPanel) {
        int n = 0;
        JLabel jLabel = this.getDescriptionLabel();
        this.descTxtFld = this.getDescriptionFld();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 12), 0, 0));
        jPanel.add((Component)this.descTxtFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        return ++n;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        this.connection = oracleDatabaseImpl.getConnection();
        this.parent = window;
        AccessControlList accessControlList = (AccessControlList)this.getUpdatedObject();
        String string = accessControlList.getDescription();
        this.descTxtFld.setText(string);
        this.updateACLDetails(accessControlList);
    }

    private void updateACLDetails(AccessControlList accessControlList) {
        AccessControlEntry[] accessControlEntryArray = accessControlList.getAces();
        this.m_aceAccessPanel.initialiseFieldsFast(this.connection);
        this.m_aceAccessPanel.fillGridWithPrivilegeInfo(accessControlEntryArray, 1);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        AccessControlList accessControlList = (AccessControlList)this.getUpdatedObject();
        this.setData(accessControlList);
    }

    public void setData(AccessControlList accessControlList) {
        String string = accessControlList.getName();
        List<AccessControlEntry> list = this.m_aceAccessPanel.getACEList();
        accessControlList.clearAces();
        for (AccessControlEntry accessControlEntry : list) {
            accessControlEntry.setACL(string);
            accessControlList.addAce(accessControlEntry);
        }
    }

    @Override
    public boolean isAnalyticWorkspaceRequired() {
        return false;
    }
}

