/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olap.security.AccessControlEntry;
import oracle.olap.security.AccessControlList;

public class AccessControlListBuilder
extends AbstractOLAPDBObjectBuilder<AccessControlList> {
    public AccessControlListBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "OLAPACL");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public AccessControlList createObject(String string, Schema schema, DBObjectID dBObjectID) {
        AccessControlList accessControlList = new AccessControlList();
        accessControlList.setName(string);
        accessControlList.setSchema(schema);
        accessControlList.setID(dBObjectID);
        return accessControlList;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "aces"})
    public void build(final AccessControlList accessControlList) throws DBException {
        accessControlList.clearAces();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "SELECT NAME,SECURITY_CLASS,SECURITY_CLASS_OWNER,PARENT_ACL,PARENT_ACL_OWNER,INHERITANCE_TYPE,DESCRIPTION FROM USER_XS_ACLS WHERE SECURITY_CLASS = 'OlapPrivileges' AND SECURITY_CLASS_OWNER = 'SYS' and name=? ORDER BY NAME", new Object[]{accessControlList.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("NAME");
                        String string2 = resultSet.getString("SECURITY_CLASS");
                        String string3 = resultSet.getString("SECURITY_CLASS_OWNER");
                        String string4 = resultSet.getString("PARENT_ACL");
                        String string5 = resultSet.getString("PARENT_ACL_OWNER");
                        String string6 = resultSet.getString("INHERITANCE_TYPE");
                        String string7 = resultSet.getString("DESCRIPTION");
                        accessControlList.setName(string);
                        accessControlList.setSecurityClass(string2);
                        accessControlList.setSecurityClassOwner(string3);
                        accessControlList.setParentACL(string4);
                        accessControlList.setParentACLOwner(string5);
                        accessControlList.setInheritanceType(string6);
                        accessControlList.setDescription(string7);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)accessControlList, sQLException);
                }
            }
        });
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select ACL,ACE_ORDER,START_DATE,END_DATE,GRANT_TYPE,INVERTED_PRINCIPAL,PRINCIPAL,PRINCIPAL_TYPE,PRIVILEGE,SECURITY_CLASS,SECURITY_CLASS_OWNER FROM USER_XS_ACES  WHERE ACL=? ORDER BY ACL, PRINCIPAL", new Object[]{accessControlList.getName()});
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString("ACL");
                        Timestamp timestamp = resultSet.getTimestamp("START_DATE");
                        Timestamp timestamp2 = resultSet.getTimestamp("END_DATE");
                        String string2 = resultSet.getString("GRANT_TYPE");
                        String string3 = resultSet.getString("INVERTED_PRINCIPAL");
                        String string4 = resultSet.getString("PRINCIPAL");
                        String string5 = resultSet.getString("PRINCIPAL_TYPE");
                        String string6 = resultSet.getString("PRIVILEGE");
                        String string7 = resultSet.getString("SECURITY_CLASS");
                        String string8 = resultSet.getString("SECURITY_CLASS_OWNER");
                        BigDecimal bigDecimal = resultSet.getBigDecimal("ACE_ORDER");
                        int n = bigDecimal.intValue();
                        AccessControlEntry accessControlEntry = new AccessControlEntry(string, n, timestamp, timestamp2, string2, string3, string4, string5, string6, string7, string8);
                        accessControlList.addAce(accessControlEntry);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)accessControlList, sQLException);
                }
            }
        });
    }
}

