/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.navigator.calculatedmeasure;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeListener;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.editor.BasicEditorPane;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.diagram.measure.MeasureDependenciesEditor;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureBufferPinning;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasurePinningTracker;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureShowCompilePage;
import oracle.olap.navigator.calculatedmeasure.DockableSpecTree;
import oracle.olap.syntaxbuilder.details.CalculatedMeasureDependencies;
import oracle.olap.syntaxbuilder.details.CalculatedMeasureReferences;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.language.OLAPILanguageModule;
import oracle.olapi.syntax.SyntaxObject;

public class CalculatedMeasureAddin
implements Addin {
    public static final String VIEW_TYPE = "CALC_MEASURE_VIEW_TYPE";
    private static Logger LOG = Logger.getLogger(CalculatedMeasureAddin.class.getName());
    private EditorListener refreshOnActivate = new EditorListener(){

        private void checkSchema(Editor editor, String string) {
            if (editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode() instanceof CalculatedMeasureNode) {
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)editor.getContext().getNode();
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)calculatedMeasureNode.isBreadcrumbsOn());
                PlSqlFeatures.setSupportedGutterNavigation((boolean)calculatedMeasureNode.isGutterNavOn());
                if (!OLAPMetadataCache.hasForConnection(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName())) {
                    LOG.finest(String.format("editor for calc %s %s withOUT a valid cache", string, calculatedMeasureNode.getMeasureName()));
                    CalculatedMeasureAddin.this.doUpdate(calculatedMeasureNode, null);
                } else {
                    LOG.finest(String.format("editor for calc %s %s WITH a valid cache", string, calculatedMeasureNode.getMeasureName()));
                }
            }
        }

        public void editorOpened(Editor editor) {
            this.checkSchema(editor, "opened");
        }

        public void editorActivated(Editor editor) {
            this.checkSchema(editor, "activated");
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    };
    private Controller refreshController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getNode() instanceof CalculatedMeasureNode && context.getView() instanceof CodeEditor) {
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)context.getNode();
                OLAPMetadataCache.removeSchema(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                CalculatedMeasureAddin.this.doUpdate(calculatedMeasureNode, (CodeEditor)context.getView());
                return true;
            }
            if (CalculatedMeasureAddin.this.isOlap(context.getElement())) {
                String string = "";
                String string2 = "";
                try {
                    URL uRL = ((DatabaseElement)context.getElement()).getURL();
                    string = DBURLFormatHelper.getCatalogSchema((URL)uRL);
                    string2 = DBURLFormatHelper.getConnectionName((URL)uRL);
                    OLAPMetadataCache.removeSchema(string2, string);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, String.format("Error removing schema %s for connection %s", string, string2), throwable);
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    };
    private ConnectionListener discardOnDisconnect = new ConnectionListener(){

        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            OLAPMetadataCache.removeSchemas(string);
            DockableSpecTree.getInstance().removeSpecs(string);
        }
    };
    private static final HashSet<String> NODE_TYPES = new HashSet();

    public void initialize() {
        new OLAPILanguageModule();
        CodeEditor.registerNodeType(CalculatedMeasureNode.class, (String)"olapexp");
        TemplateData.Mode.setTranslations(new OLAPResources());
        EditorManager.getEditorManager().addEditorListener((EditorListener)DockableSpecTree.getInstance());
        EditorManager.getEditorManager().addEditorListener((EditorListener)new CalculatedMeasureShowCompilePage());
        CodeEditor.createHighlightStyle((String)"syntaxbuilder.squiggly", (String)OLAPArb.getString("EXPRESSION_EDITOR_SQUIGLY_STYLE"), (int)2, null, null, (int)0, (int)4, (Color)Color.RED);
        Color color = new Color(111, 152, 203);
        CodeEditor.createHighlightStyle((String)"syntaxbuilder.inner_selection", (String)OLAPArb.getString("EXPRESSION_EDITOR_INNER_SELECTION_STYLE"), (int)101, null, (Color)color);
        CalculatedMeasureAddin.registerEditor(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.REFERENCES_TAB"), CalculatedMeasureReferences.class);
        CalculatedMeasureAddin.registerEditor(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB"), CalculatedMeasureDependencies.class);
        if (System.getProperty("sqldev.debug", "false").equalsIgnoreCase("true")) {
            CalculatedMeasureAddin.registerEditor(OLAPArb.getString("CALCULATED_MEASURES_DEPENDENCIES_MAP"), MeasureDependenciesEditor.class);
        }
        IdeActions.getViewRefreshAction().addController(this.refreshController);
        EditorManager.getEditorManager().addEditorListener(this.refreshOnActivate);
        Connections.getInstance().addConnectionListener(this.discardOnDisconnect);
        EditorManager.getEditorManager().addEditorListener((EditorListener)new CalculatedMeasurePinningTracker());
        Node.addNodeListenerForType(CalculatedMeasureNode.class, (NodeListener)new CalculatedMeasureBufferPinning());
    }

    private boolean isOlap(Element element) {
        String string = null;
        if (element instanceof ObjectFolder) {
            string = ((ObjectFolder)element).getObjectType();
        } else if (element instanceof ChildFolder) {
            string = ((ChildFolder)element).getObjectType();
        } else if (element instanceof ObjectNode) {
            string = ((ObjectNode)element).getObjectType();
        }
        return string != null && NODE_TYPES.contains(string);
    }

    private void doUpdate(final CalculatedMeasureNode calculatedMeasureNode, final CodeEditor codeEditor) {
        RaptorTask<Schema> raptorTask = new RaptorTask<Schema>(OLAPArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Schema doWork() {
                Schema schema = null;
                try {
                    schema = OLAPMetadataCache.getUpdatedSchema(calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName());
                    if (codeEditor != null) {
                        Measure measure;
                        final BasicEditorPane basicEditorPane = codeEditor.getFocusedEditorPane();
                        Cube cube = schema.findCube(calculatedMeasureNode.getCubeName());
                        if (cube != null && basicEditorPane != null && (measure = cube.findMeasure(calculatedMeasureNode.getMeasureName())) != null) {
                            Properties properties = new Properties();
                            final OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(null, properties);
                            SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)measure.getExpression(), null);
                            final String string = syntaxObject.toSyntax(schema.getName());
                            final String string2 = oLAPISyntaxParser.formatSyntax(string);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int n = 1;
                                    if (calculatedMeasureNode.isDirty()) {
                                        n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.getString("EXPRESSION_EDITOR_RELOAD_EXPRESSION"), OLAPArb.getString("EXPRESSION_EDITOR_RELOAD_EXPRESSION_TITLE"), 0);
                                    }
                                    if (n == 0 || !basicEditorPane.getText().equals(string2) && !calculatedMeasureNode.isDirty()) {
                                        if (oLAPISyntaxParser.parseSyntax(string2, null)) {
                                            basicEditorPane.setText(string2);
                                        } else {
                                            basicEditorPane.setText(string);
                                        }
                                        calculatedMeasureNode.markDirty(false);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, String.format("Error fetching metadata for Connection %s and schema %s", calculatedMeasureNode.getConnectionName(), calculatedMeasureNode.getSchemaName()), exception);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setMessage(OLAPArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public static void registerEditor(final String string, final Class<? extends Editor> clazz) {
        EditorAddin editorAddin = new EditorAddin(){

            public Class<? extends Editor> getEditorClass() {
                return clazz;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec(string, null);
            }

            public boolean isDefault() {
                return false;
            }

            public float getEditorWeight(Element element) {
                if (element instanceof CalculatedMeasureNode) {
                    return 0.0f;
                }
                return Float.NaN;
            }
        };
        EditorManager.getEditorManager().registerDynamic(editorAddin);
    }

    static {
        NODE_TYPES.add("OLAPAW");
        NODE_TYPES.add("CUBE DIMENSION");
        NODE_TYPES.add("DIMENSIONLEVEL");
        NODE_TYPES.add("CUBE");
        NODE_TYPES.add("CUBEMEASURE");
        NODE_TYPES.add("OLAPDMLPROGRAM");
        NODE_TYPES.add("MEASURE FOLDER");
        NODE_TYPES.add("CALCMEASURE");
    }
}

