/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.eif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ImportFromEIFRunnable;
import oracle.olap.eif.ImportFromEIFDialog;

public class ImportFromEIF {
    private static ImportFromEIF INSTANCE;
    private static final Logger LOGGER;

    private ImportFromEIF() {
    }

    public static ImportFromEIF getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImportFromEIF();
        }
        return INSTANCE;
    }

    public void launchDialog(DBObject dBObject) {
        Database database = dBObject.getDatabase();
        Connection connection = database.getConnection();
        String string = dBObject.getSchemaName();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        ImportFromEIFDialog importFromEIFDialog = new ImportFromEIFDialog((Frame)Ide.getMainWindow(), (DBObjectProvider)database, string);
        importFromEIFDialog.setMinimumSize(new Dimension(340, 265));
        importFromEIFDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        importFromEIFDialog.setVisible(true);
        if (importFromEIFDialog.isOKSelected()) {
            string2 = importFromEIFDialog.getAWName();
            string3 = importFromEIFDialog.getEIFFileName();
            string4 = importFromEIFDialog.getDirectoryName();
            string5 = importFromEIFDialog.getTableSpaceName();
        }
        if (string4 != null && string3 != null && string2 != null) {
            this.importFromEIFFile(connection, string, string5, string2, string4, string3);
        }
    }

    private void importFromEIFFile(Connection connection, String string, String string2, String string3, String string4, String string5) {
        try {
            ImportFromEIFRunnable importFromEIFRunnable = new ImportFromEIFRunnable(connection, string, string2, string3, string4, string5);
            String string6 = OLAPArb.get("EIF_IMPORT_PROGRESSBAR_TITLE");
            string6 = MessageFormat.format(string6, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string6, (Runnable)importFromEIFRunnable, true);
            progressBar.setCancelable(false);
            importFromEIFRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("EIF_IMPORT_PROGRESSBAR_WAIT_MSG"), null);
            if (importFromEIFRunnable.getException() != null) {
                throw importFromEIFRunnable.getException();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string7 = null;
            String string8 = exception.getLocalizedMessage();
            if (string8 == null || string8.length() == 0) {
                string8 = exception.getClass().toString();
            }
            String string9 = OLAPArb.get("EIF_IMPORT_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string8, (String)string9, string7);
        }
    }

    static {
        LOGGER = Logger.getLogger(ImportFromEIF.class.getName());
    }
}

