/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

public class OLAPDMLLazyNode
extends ParseNode {
    public String startToken;
    List<LexerToken> src;
    private ParseNode branch = null;

    public OLAPDMLLazyNode(int n, String string, List<LexerToken> list) {
        super(n, -1, -1, -1, null);
        this.startToken = string;
        this.src = list;
    }

    public ParseNode getBranch() {
        return this.branch;
    }

    public SortedSet<ParseNode> children() {
        if (this.branch == null) {
            return super.children();
        }
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        treeSet.addAll(super.children());
        treeSet.add(this.branch);
        return treeSet;
    }

    public List<OLAPDMLLazyNode> shallowChildren() {
        ArrayList<OLAPDMLLazyNode> arrayList = new ArrayList<OLAPDMLLazyNode>();
        for (ParseNode parseNode : super.children()) {
            if (!(parseNode instanceof OLAPDMLLazyNode)) continue;
            arrayList.add((OLAPDMLLazyNode)parseNode);
        }
        return arrayList;
    }

    public List<OLAPDMLLazyNode> shallowDescendants() {
        ArrayList<OLAPDMLLazyNode> arrayList = new ArrayList<OLAPDMLLazyNode>();
        arrayList.add(this);
        for (ParseNode parseNode : this.shallowChildren()) {
            arrayList.addAll(((OLAPDMLLazyNode)parseNode).shallowDescendants());
        }
        return arrayList;
    }

    public List<OLAPDMLLazyNode> shallowIntermediates(int n, int n2) {
        ArrayList<OLAPDMLLazyNode> arrayList = new ArrayList<OLAPDMLLazyNode>();
        if (this.from <= n && n2 <= this.to) {
            arrayList.add(this);
        }
        for (OLAPDMLLazyNode oLAPDMLLazyNode : this.shallowChildren()) {
            if (oLAPDMLLazyNode.from > n || n2 > oLAPDMLLazyNode.to) continue;
            arrayList.addAll(oLAPDMLLazyNode.shallowIntermediates(n, n2));
        }
        return arrayList;
    }

    public OLAPDMLLazyNode shallowParent(int n, int n2) {
        for (OLAPDMLLazyNode oLAPDMLLazyNode : this.shallowIntermediates(n, n2)) {
            for (OLAPDMLLazyNode oLAPDMLLazyNode2 : oLAPDMLLazyNode.shallowChildren()) {
                if (oLAPDMLLazyNode2.from != n || oLAPDMLLazyNode2.to != n2) continue;
                return oLAPDMLLazyNode;
            }
        }
        return null;
    }

    public OLAPDMLLazyNode shallowLeaf(int n, int n2) {
        for (OLAPDMLLazyNode oLAPDMLLazyNode : this.shallowIntermediates(n, n2)) {
            if (oLAPDMLLazyNode.shallowChildren().size() != 0 || oLAPDMLLazyNode.from > n || n2 > oLAPDMLLazyNode.to) continue;
            return oLAPDMLLazyNode;
        }
        return null;
    }

    public OLAPDMLLazyNode ancestor(int n, int n2) {
        List<OLAPDMLLazyNode> list = this.shallowChildren();
        if (list.size() == 0) {
            return this;
        }
        for (OLAPDMLLazyNode oLAPDMLLazyNode : list) {
            if (oLAPDMLLazyNode.from > n || n2 > oLAPDMLLazyNode.to) continue;
            return oLAPDMLLazyNode.ancestor(n, n2);
        }
        return this;
    }

    public boolean isAuxiliary() {
        return false;
    }

    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("[" + this.from + "," + this.to + ") ");
        stringBuffer.append("  " + this.startToken);
        return stringBuffer.toString();
    }

    public boolean isAs() {
        return false;
    }

    public boolean isCompilationUnit() {
        return "program".equalsIgnoreCase(this.startToken) || this.isProcedure();
    }

    public boolean isProcedure() {
        return "do".equalsIgnoreCase(this.startToken);
    }

    public boolean isDML() {
        return "maintain".equalsIgnoreCase(this.startToken) || "mnt".equalsIgnoreCase(this.startToken) || "update".equalsIgnoreCase(this.startToken) || "upd".equalsIgnoreCase(this.startToken) || "delete".equalsIgnoreCase(this.startToken) || "dlt".equalsIgnoreCase(this.startToken) || "limit".equalsIgnoreCase(this.startToken) || "lmt".equalsIgnoreCase(this.startToken) || "cursor".equalsIgnoreCase(this.startToken) || "sort".equalsIgnoreCase(this.startToken) || "fcset".equalsIgnoreCase(this.startToken) || "fcexec".equalsIgnoreCase(this.startToken) || "fcclose".equalsIgnoreCase(this.startToken) || "push".equalsIgnoreCase(this.startToken) || "pop".equalsIgnoreCase(this.startToken) || "pushlevel".equalsIgnoreCase(this.startToken) || "poplevel".equalsIgnoreCase(this.startToken) || "tempstat".equalsIgnoreCase(this.startToken) || "model".equalsIgnoreCase(this.startToken) || "fetch".equalsIgnoreCase(this.startToken);
    }

    public boolean isDDL() {
        return "define".equalsIgnoreCase(this.startToken) || "dfn".equalsIgnoreCase(this.startToken) || "chgdfn".equalsIgnoreCase(this.startToken);
    }

    boolean isControlStmt(OLAPDMLLazyNode oLAPDMLLazyNode) {
        OLAPDMLLazyNode oLAPDMLLazyNode2 = (OLAPDMLLazyNode)oLAPDMLLazyNode.parent(this.from, this.to);
        String string = oLAPDMLLazyNode2 == null ? "N/A" : oLAPDMLLazyNode2.startToken;
        return "if".equalsIgnoreCase(this.startToken) || "switch".equalsIgnoreCase(this.startToken) || "for".equalsIgnoreCase(this.startToken) || "while".equalsIgnoreCase(this.startToken) || "do".equalsIgnoreCase(this.startToken) && !"for".equalsIgnoreCase(string) && !"while".equalsIgnoreCase(string);
    }

    public boolean isStmt(OLAPDMLLazyNode oLAPDMLLazyNode) {
        if ("variable".equalsIgnoreCase(this.startToken) || "vrb".equalsIgnoreCase(this.startToken)) {
            return true;
        }
        if ("program".equalsIgnoreCase(this.startToken) || "prg".equalsIgnoreCase(this.startToken)) {
            ParseNode parseNode = oLAPDMLLazyNode.parent(this.from, this.to);
            OLAPDMLLazyNode oLAPDMLLazyNode2 = (OLAPDMLLazyNode)parseNode;
            if (oLAPDMLLazyNode2 == null) {
                return true;
            }
            if (!("variable".equalsIgnoreCase(oLAPDMLLazyNode2.startToken) || "vrb".equalsIgnoreCase(oLAPDMLLazyNode2.startToken) || oLAPDMLLazyNode2.isProcedure())) {
                return true;
            }
        }
        return this.isControlStmt(oLAPDMLLazyNode) || this.isDML() || this.isDDL();
    }
}

