/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.dml.editor.OLAPDMLErrorInfo;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLTranslator {
    private Translator.Log _log = null;

    public void setLog(Translator.Log log) {
        this._log = log;
    }

    public List<OLAPDMLErrorInfo> translate(OLAPDMLNode oLAPDMLNode) {
        ArrayList<OLAPDMLErrorInfo> arrayList = new ArrayList<OLAPDMLErrorInfo>();
        try {
            List<OLAPDMLErrorInfo> list = this.compile(oLAPDMLNode);
            arrayList.addAll(list);
            if (list != null) {
                this.writeCompileLog(oLAPDMLNode, list);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    public void writeCompileLog(OLAPDMLNode oLAPDMLNode, List<OLAPDMLErrorInfo> list) throws Exception {
        IdeLog ideLog;
        OLAPDMLErrorInfo oLAPDMLErrorInfo2;
        IdeStorage ideStorage = new IdeStorage((Node)oLAPDMLNode);
        boolean bl = false;
        boolean bl2 = false;
        ideStorage.setProperty("OLAPDMLCompilerPage.URL", (Object)oLAPDMLNode.getURL());
        for (OLAPDMLErrorInfo oLAPDMLErrorInfo2 : list) {
            if (oLAPDMLErrorInfo2.isWarning()) {
                this._log.warning((Storage)ideStorage, oLAPDMLErrorInfo2.getLineNumber(), oLAPDMLErrorInfo2.getColumn(), 0, oLAPDMLErrorInfo2.getErrorMessage());
                continue;
            }
            bl2 = true;
            if (oLAPDMLErrorInfo2.isFatal()) {
                bl = true;
            }
            this._log.error((Storage)ideStorage, oLAPDMLErrorInfo2.getLineNumber(), oLAPDMLErrorInfo2.getColumn(), 0, oLAPDMLErrorInfo2.getErrorMessage());
        }
        if (list.size() == 20) {
            this._log.warning((Storage)ideStorage, 1, 1, 0, DatabaseNavigatorResources.getString((String)"PLSQL_TRANSLATOR_MSGS_EXCEEDED"));
        }
        if (list.size() == 0 && this._log instanceof IdeLog) {
            ideLog = (IdeLog)this._log;
            oLAPDMLErrorInfo2 = new Diagnostic(Diagnostic.Kind.INFO);
            oLAPDMLErrorInfo2.setStorage((Storage)ideStorage);
            oLAPDMLErrorInfo2.setLine(1);
            oLAPDMLErrorInfo2.setColumn(1);
            oLAPDMLErrorInfo2.setNumber(0);
            oLAPDMLErrorInfo2.setMessage(OLAPArb.format("OLAPDML_COMPILED", oLAPDMLNode.getFullyQualifiedName()));
            ideLog.diagnostic((Diagnostic)oLAPDMLErrorInfo2);
        }
        if (!bl && bl2 && this._log instanceof IdeLog) {
            ideLog = (IdeLog)this._log;
            oLAPDMLErrorInfo2 = new Diagnostic(Diagnostic.Kind.INFO);
            oLAPDMLErrorInfo2.setStorage((Storage)ideStorage);
            oLAPDMLErrorInfo2.setLine(1);
            oLAPDMLErrorInfo2.setColumn(1);
            oLAPDMLErrorInfo2.setNumber(0);
            oLAPDMLErrorInfo2.setMessage(OLAPArb.format("OLAPDML_ERRORS", oLAPDMLNode.getFullyQualifiedName()));
            ideLog.diagnostic((Diagnostic)oLAPDMLErrorInfo2);
        }
    }

    public List<OLAPDMLErrorInfo> compile(OLAPDMLNode oLAPDMLNode) {
        ArrayList<OLAPDMLErrorInfo> arrayList = new ArrayList<OLAPDMLErrorInfo>();
        String string = oLAPDMLNode.getOwner();
        String string2 = oLAPDMLNode.getSource();
        String string3 = oLAPDMLNode.getConnectionName();
        String string4 = null;
        if (string3 == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString((String)"PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
            return arrayList;
        }
        String string5 = oLAPDMLNode.getFullyQualifiedName();
        Connection connection = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("compile %s;", string5));
        oLAPDMLNode.markDirty(false);
        try {
            connection = Connections.getInstance().getConnection(string3, true);
            string4 = DatabaseUtils.ExecuteSPL(connection, stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            String string6 = null;
            string6 = sQLException.getLocalizedMessage();
            arrayList.add(new OLAPDMLErrorInfo(1, 1, string6, "UNABLE_TO_COMPILE"));
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        if (string4 != null) {
            List<OLAPDMLErrorInfo> list = this.getDMLCompileErrors(string4, string2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<OLAPDMLErrorInfo> getDMLCompileErrors(String string, String string2) {
        ArrayList<OLAPDMLErrorInfo> arrayList = new ArrayList<OLAPDMLErrorInfo>();
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.startsWith("ERROR:")) continue;
            String string4 = string3.substring("ERROR:".length());
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            n3 = i + 2;
            if (n3 < stringArray.length) {
                i = n3;
                String string5 = stringArray[i].trim();
                n = this.getSourceLineNumber(string2, string5) + 1;
                String string6 = stringArray[++i];
                n2 = string6.indexOf("^") + 1;
                arrayList.add(new OLAPDMLErrorInfo(n, n2, string4));
                continue;
            }
            arrayList.add(new OLAPDMLErrorInfo(n, n2, string4, "UNABLE_TO_COMPILE"));
        }
        return arrayList;
    }

    private int getSourceLineNumber(String string, String string2) {
        int n = 0;
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i].trim();
            if (string4.equals(string2)) {
                n = i;
                break;
            }
            if (string4.indexOf(string2) <= -1 || string4.indexOf("-") <= -1 || !(string3 = string4.substring(0, string4.indexOf("-")).trim()).equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }
}

