/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.diagram.measure;

import java.util.HashMap;
import java.util.Map;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.diagram.AbstractOLAPDiagramNode;
import oracle.olap.diagram.measure.MeasureDependenciesDiagram;

public class MeasureNode
extends AbstractOLAPDiagramNode {
    public static final String MEASURE = "measure";
    public static final String DIAGRAM = "diagram";
    private static final int MAX_LENGTH = 20;
    private Map<String, Object> properties;
    private Measure measure;
    private String name;
    private boolean includeCubeName;
    private MeasureDependenciesDiagram diagram;

    public MeasureNode() {
        this(null, null);
    }

    public MeasureNode(MeasureDependenciesDiagram measureDependenciesDiagram, Measure measure) {
        this.diagram = measureDependenciesDiagram;
        this.measure = measure;
        this.properties = new HashMap<String, Object>();
    }

    public void setIncludeCubeName(boolean bl) {
        this.includeCubeName = bl;
    }

    public boolean isIncludeCubeName() {
        return this.includeCubeName;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public String getDisplayLabel() {
        if (this.measure.isDerived()) {
            if (this.measure.getExpression().length() > 20) {
                return String.format("%s\n%s...", this.measure.getName(), this.measure.getExpression().substring(0, 20));
            }
            return String.format("%s\n%s", this.measure.getName(), this.measure.getExpression());
        }
        if (this.includeCubeName) {
            return String.format("%s.%s", this.measure.getCube().getName(), this.measure.getName());
        }
        return this.measure.getName();
    }

    public String getFullDisplayLabel() {
        if (this.measure.isDerived()) {
            return String.format("%s\n%s", this.measure.getName(), this.measure.getExpression());
        }
        if (this.includeCubeName) {
            return String.format("%s.%s", this.measure.getCube().getName(), this.measure.getName());
        }
        return this.measure.getName();
    }

    public MeasureDependenciesDiagram getDiagram() {
        return this.diagram;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.properties.get(string);
    }
}

