/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.ChildNameObjectEditorContext;
import oracle.olap.db.view.DescriptionFields;
import oracle.olap.db.view.PanelUtil;
import oracle.olap.util.UIStringUtils;

public abstract class ChildObjectEditorPanel2<T extends AbstractChildObjectWithDesc, P extends DBObject>
extends ChildObjectEditorPanel<T, P>
implements DescriptionFields {
    private JTextField m_fldName = new JTextField();
    private JLabel shortDescLabel = new JLabel();
    private JLabel longDescLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private String m_propPath;
    private JTextField descriptionFld = new JTextField();
    private JTextField shortDescriptionFld = new JTextField();
    private JTextField longDescriptionFld = new JTextField();

    public ChildObjectEditorPanel2(String string, String string2) {
        super(string, string2);
        this.m_propPath = string2;
        this.initializeNameFieldListener();
    }

    public String getPropertyPath() {
        return this.m_propPath;
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public T getChildDBObject() {
        return (T)((AbstractChildObjectWithDesc)this.getChildObject());
    }

    protected void initialisePanel() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)this.getChildObject();
        if (abstractChildObjectWithDesc != null) {
            this.descriptionFld.setText(abstractChildObjectWithDesc.getDescription());
            this.shortDescriptionFld.setText(abstractChildObjectWithDesc.getShortDescription());
            this.longDescriptionFld.setText(abstractChildObjectWithDesc.getLongDescription());
        }
    }

    public void initializeNameFieldListener() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Object t = ChildObjectEditorPanel2.this.getChildDBObject();
                if (t == null) {
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getSource() == ChildObjectEditorPanel2.this.m_fldName) {
                    if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"') {
                        Toolkit.getDefaultToolkit().beep();
                        keyEvent.consume();
                        return;
                    }
                } else if (keyEvent.getSource() == ChildObjectEditorPanel2.this.longDescriptionFld) {
                    ((AbstractChildObjectWithDesc)t).markLongDescriptionDirty(true);
                } else if (keyEvent.getSource() == ChildObjectEditorPanel2.this.shortDescriptionFld) {
                    ((AbstractChildObjectWithDesc)t).markShortDescriptionDirty(true);
                } else if (keyEvent.getSource() == ChildObjectEditorPanel2.this.descriptionFld) {
                    ((AbstractChildObjectWithDesc)t).markDescriptionDirty(true);
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        this.m_fldName.addKeyListener(keyAdapter);
        this.longDescriptionFld.addKeyListener(keyAdapter);
        this.shortDescriptionFld.addKeyListener(keyAdapter);
        this.descriptionFld.addKeyListener(keyAdapter);
        this.m_fldName.getDocument().addDocumentListener(new DocumentListener(){

            public void common() {
                Object t = ChildObjectEditorPanel2.this.getChildDBObject();
                if (t == null) {
                    return;
                }
                if (!ChildObjectEditorPanel2.this.isEditing() || ((AbstractChildObjectWithDesc)t).getNewObject()) {
                    String string = ChildObjectEditorPanel2.this.m_fldName.getText();
                    ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
                    int n = childNameObjectEditorContext.getEditingState();
                    if (n == 1) {
                        return;
                    }
                    String string2 = ChildObjectEditorPanel2.this.descriptionFld.getText();
                    String string3 = ChildObjectEditorPanel2.this.longDescriptionFld.getText();
                    String string4 = ChildObjectEditorPanel2.this.shortDescriptionFld.getText();
                    boolean bl = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string2);
                    boolean bl2 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string3);
                    boolean bl3 = string4 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string4);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (((AbstractChildObjectWithDesc)t).getDescriptionDirty().booleanValue()) {
                        bl4 = true;
                    }
                    if (((AbstractChildObjectWithDesc)t).getShortDescriptionDirty().booleanValue()) {
                        bl5 = true;
                    }
                    if (((AbstractChildObjectWithDesc)t).getLongDescriptionDirty().booleanValue()) {
                        bl6 = true;
                    }
                    if (!bl3 && (!bl5 || ChildObjectEditorPanel2.this.shortDescriptionFld.getText().length() == 0 && string.length() < 2 && n == 0)) {
                        ChildObjectEditorPanel2.this.shortDescriptionFld.setText(UIStringUtils.convertDescription(string));
                        ((AbstractChildObjectWithDesc)t).markShortDescriptionDirty(false);
                    }
                    if (!bl2 && (!bl6 || ChildObjectEditorPanel2.this.longDescriptionFld.getText().length() == 0 && string.length() < 2 && n == 0)) {
                        ChildObjectEditorPanel2.this.longDescriptionFld.setText(UIStringUtils.convertDescription(string));
                        ((AbstractChildObjectWithDesc)t).markLongDescriptionDirty(false);
                    }
                    if (!bl && (!bl4 || ChildObjectEditorPanel2.this.descriptionFld.getText().length() == 0 && string.length() < 2 && n == 0)) {
                        ChildObjectEditorPanel2.this.descriptionFld.setText(UIStringUtils.convertDescription(string));
                        ((AbstractChildObjectWithDesc)t).markDescriptionDirty(false);
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        });
    }

    protected void commitPanel() throws TraversalException {
    }

    protected void registerDescriptionFields() {
        ComponentFactory componentFactory = this.getComponentFactory();
        PanelUtil.registerDescriptionFields(componentFactory, this);
    }

    protected int layoutDescriptionFields(int n) {
        return PanelUtil.layoutDescriptionFields((JPanel)((Object)this), this, n);
    }

    @Override
    public JLabel getDescriptionLabel() {
        return this.descLabel;
    }

    @Override
    public JLabel getShortDescriptionLabel() {
        return this.shortDescLabel;
    }

    @Override
    public JLabel getLongDescriptionLabel() {
        return this.longDescLabel;
    }

    @Override
    public JTextField getDescriptionFld() {
        return this.descriptionFld;
    }

    @Override
    public JTextField getShortDescriptionFld() {
        return this.shortDescriptionFld;
    }

    @Override
    public JTextField getLongDescriptionFld() {
        return this.longDescriptionFld;
    }

    public void enableDescriptions(boolean bl) {
        this.descLabel.setEnabled(bl);
        this.shortDescLabel.setEnabled(bl);
        this.longDescLabel.setEnabled(bl);
        this.descriptionFld.setEnabled(bl);
        this.shortDescriptionFld.setEnabled(bl);
        this.longDescriptionFld.setEnabled(bl);
        if (!bl) {
            this.descriptionFld.setText("");
            this.shortDescriptionFld.setText("");
            this.longDescriptionFld.setText("");
        }
    }

    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
    }
}

