/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.awt.Window;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;

public class OLAPExceptionHandler {
    public static final String OLAP_ERROR = "ORA-37162";

    private OLAPExceptionHandler() {
    }

    public static String getErrorMessage(Exception exception) {
        String string = exception.getMessage();
        Throwable throwable = exception.getCause();
        if (throwable.getCause() instanceof SQLException && string.indexOf(OLAP_ERROR) > 0) {
            return OLAPExceptionHandler.extractErrorMsg(string);
        }
        return exception.getMessage();
    }

    public static void handleException(Window window, Exception exception) {
        String string = exception.getMessage();
        Throwable throwable = exception.getCause();
        if (throwable.getCause() instanceof SQLException && string.indexOf(OLAP_ERROR) >= 0) {
            string = OLAPExceptionHandler.extractErrorMsg(string);
        }
        OLAPExceptionHandler.showError(window, string);
    }

    public static void showError(Window window, String string) {
        Window window2 = window != null ? window : Ide.getMainWindow();
        JOptionPane.showMessageDialog(window2, string, OLAPArb.getString("GENERIC_ERROR_TITLE"), 0);
    }

    public static void handleException(Window window, String string) {
        if (string.indexOf(OLAP_ERROR) >= 0) {
            string = OLAPExceptionHandler.extractErrorMsg(string);
        }
        OLAPExceptionHandler.showError(window, string);
    }

    private static String extractErrorMsg(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("\n", string.indexOf(OLAP_ERROR));
        String string2 = string.substring(string.indexOf(OLAP_ERROR), n);
        stringBuffer.append(string2 + "\n");
        int n2 = n + 1;
        n = string.indexOf("\n", n2);
        string2 = string.substring(n2, n);
        stringBuffer.append(string2 + "\n");
        n2 = n + 1;
        n = string.indexOf("\n", n2);
        string2 = string.substring(n2, n);
        stringBuffer.append(string2 + "\n");
        return stringBuffer.toString();
    }
}

