/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.SystemObject;
import oracle.olap.app.calcfactory.generator.CalculatedMeasuresSQLOperationsNotifier;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.CubeCalcPersist;

public class CubeCalcPersistSQL
implements CubeCalcPersist {
    private Database database;
    private StringBuffer alterCubeSQL;
    private Cube cube;
    private oracle.olap.cube.model.Cube scube;
    private List<String> measures;
    private HashMap<String, String> measureDescriptions;
    private HashMap<String, List<String>> measuresToRemove;
    private StringBuffer updateMeasuresSQL;
    private CalculatedMeasuresSQLOperationsNotifier progressNotifier;
    private HashSet<String> changedMeasures;

    public CubeCalcPersistSQL(Database database, Cube cube, oracle.olap.cube.model.Cube cube2) throws Exception {
        this.database = database;
        this.measureDescriptions = new HashMap();
        this.updateMeasuresSQL = new StringBuffer();
        this.measuresToRemove = new HashMap();
        this.cube = cube;
        this.scube = cube2;
        this.init();
    }

    private void init() throws SQLException, IOException {
        this.scube.setName(this.cube.getName());
        this.scube.setAnalyticWorkspace(this.cube.getAWName());
        this.alterCubeSQL = new StringBuffer();
        this.measures = new ArrayList<String>();
        String string = "select measure_name from all_cube_measures where owner = ? and cube_name = ?";
        List<List<String>> list = this.database.executeSQL(string, new Object[]{this.cube.getSchema().getName(), this.cube.getName()});
        for (List<String> list2 : list) {
            for (String string2 : list2) {
                this.measures.add(string2);
            }
        }
        this.changedMeasures = new HashSet();
    }

    @Override
    public void setProgressNotifier(CalculatedMeasuresSQLOperationsNotifier calculatedMeasuresSQLOperationsNotifier) {
        this.progressNotifier = calculatedMeasuresSQLOperationsNotifier;
    }

    @Override
    public void clear() {
        this.alterCubeSQL = new StringBuffer();
        this.measureDescriptions = new HashMap();
        this.updateMeasuresSQL = new StringBuffer();
        this.measuresToRemove = new HashMap();
        this.changedMeasures = new HashSet();
    }

    @Override
    public Object addDerivedMeasure(Cube cube, String string, String string2, String string3, Map<String, String> map) throws SQLException, IOException {
        if (this.cube == null) {
            this.cube = cube;
            this.init();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.measureDescriptions.size() > 0) {
            stringBuffer.append(" description (");
        }
        for (Map.Entry<String, String> entry : this.measureDescriptions.entrySet()) {
            stringBuffer.append(String.format("'%s'='%s',", entry.getKey(), entry.getValue()));
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuffer.append(String.format("'%s'='%s',", entry.getKey(), entry.getValue()));
            }
        }
        if (this.measureDescriptions.size() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(")");
        }
        this.alterCubeSQL.append(String.format("%s MEASURE AS '%s'  TYPE \"%s\" %s,\n", string, string3, string2, stringBuffer.toString()));
        this.changedMeasures.add(string);
        return string;
    }

    @Override
    public void setDescription(Cube cube, Object object, String string, String string2) throws SQLException, IOException {
        if (this.cube == null) {
            this.cube = cube;
            this.init();
        }
        CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure();
        String string3 = null;
        if (object instanceof String) {
            string3 = (String)object;
        }
        cubeCalculatedMeasure.setName(string3);
        this.scube.addCalculatedMeasure(cubeCalculatedMeasure);
        if (string.equalsIgnoreCase("description")) {
            cubeCalculatedMeasure.setDescription(string2);
            this.measureDescriptions.put("Description", string2);
        }
        if (string.equalsIgnoreCase("long_description")) {
            cubeCalculatedMeasure.setLongDescription(string2);
            this.measureDescriptions.put("LongDescription", string2);
        }
        if (string.equalsIgnoreCase("short_description")) {
            cubeCalculatedMeasure.setShortDescription(string2);
            this.measureDescriptions.put("ShortDescription", string2);
        }
    }

    @Override
    public void commit() throws Exception {
        oracle.olap.cube.model.Cube cube = this.scube;
        StringBuffer stringBuffer = new StringBuffer();
        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)cube, (SystemObject)cube, stringBuffer.toString());
        MetadataContext metadataContext = new MetadataContext(this.database, cubeDDLStatements);
        metadataContext.setSchema(this.cube.getSchema());
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        if (this.alterCubeSQL.length() > 0) {
            stringBuffer.append("ALTER CUBE ");
            stringBuffer.append(this.cube.getName());
            stringBuffer.append(" ADD (\n");
            if (this.alterCubeSQL.toString().endsWith(",\n")) {
                this.alterCubeSQL.delete(this.alterCubeSQL.length() - 2, this.alterCubeSQL.length());
            }
            stringBuffer.append(this.alterCubeSQL.toString());
            stringBuffer.append(")");
            metadataContext.setCubeDDL(stringBuffer.toString());
            metadataXML.parse();
            metadataXML.executeSQL();
        }
        if (this.updateMeasuresSQL.length() > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("ALTER CUBE ");
            stringBuffer.append(this.cube.getName());
            stringBuffer.append(" MODIFY (\n ");
            if (this.updateMeasuresSQL.toString().endsWith(",\n")) {
                this.updateMeasuresSQL.delete(this.updateMeasuresSQL.length() - 2, this.updateMeasuresSQL.length());
            }
            stringBuffer.append(this.updateMeasuresSQL.toString());
            stringBuffer.append(")");
            metadataContext.setCubeDDL(stringBuffer.toString());
            metadataXML.parse();
            metadataXML.executeSQL();
        }
        if (!this.measuresToRemove.isEmpty()) {
            for (String string : this.measuresToRemove.keySet()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("ALTER CUBE \n");
                stringBuffer.append(string);
                stringBuffer.append(" DROP( ");
                stringBuffer.append(this.removeMeasuresString(string) + " )");
                metadataContext.setCubeDDL(stringBuffer.toString());
                metadataXML.parse();
                metadataXML.executeSQL();
            }
        }
    }

    private String removeMeasuresString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        List<String> list = this.measuresToRemove.get(string);
        for (String string2 : list) {
            stringBuffer.append(string2 + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    @Override
    public boolean isMeasureCreated(Cube cube, String string) throws Exception {
        if (this.cube == null) {
            this.cube = cube;
            this.init();
        }
        return this.measures.contains(string);
    }

    @Override
    public void rollback() {
    }

    @Override
    public void addRemoveMeasure(String string, String string2) {
        if (this.measuresToRemove.get(string2) == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.measuresToRemove.put(string2, arrayList);
        } else {
            List<String> list = this.measuresToRemove.get(string2);
            list.add(string);
        }
        this.changedMeasures.add(string);
    }

    @Override
    public void addUpdateMeasure(String string, String string2, String string3, String string4, String string5, String string6) {
        this.updateMeasuresSQL.append(String.format("%s MEASURE as '%s' TYPE \"%s\"", string, string2, string3));
        boolean bl = false;
        if (string5 != null) {
            bl = true;
            this.updateMeasuresSQL.append(String.format(" description('ShortDescription'='%s'", string5));
        }
        if (string6 != null) {
            if (bl) {
                this.updateMeasuresSQL.append(String.format(",'LongDescription'='%s'", string6));
            } else {
                this.updateMeasuresSQL.append(String.format(" description('LongDescription'='%s'", string6));
            }
            bl = true;
        }
        if (string4 != null) {
            if (bl) {
                this.updateMeasuresSQL.append(String.format(",'Description'='%s'", string4));
            } else {
                this.updateMeasuresSQL.append(String.format(" description('Description'='%s'", string4));
            }
            bl = true;
        }
        if (bl) {
            this.updateMeasuresSQL.append(")");
        }
        this.updateMeasuresSQL.append("\n");
        this.changedMeasures.add(string);
    }

    @Override
    public String generateSQLXML() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        oracle.olap.cube.model.Cube cube = this.scube;
        StringBuffer stringBuffer2 = new StringBuffer();
        CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)cube, (SystemObject)cube, stringBuffer2.toString());
        MetadataContext metadataContext = new MetadataContext(this.database, cubeDDLStatements);
        metadataContext.setSchema(this.cube.getSchema());
        MetadataXML metadataXML = new MetadataXML(metadataContext);
        if (this.alterCubeSQL.length() > 0) {
            stringBuffer2.append("ALTER CUBE ");
            stringBuffer2.append(this.cube.getName());
            stringBuffer2.append(" ADD (\n");
            if (this.alterCubeSQL.toString().endsWith(",\n")) {
                this.alterCubeSQL.delete(this.alterCubeSQL.length() - 2, this.alterCubeSQL.length());
            }
            stringBuffer2.append(this.alterCubeSQL.toString());
            stringBuffer2.append(")");
            metadataContext.setCubeDDL(stringBuffer2.toString());
            metadataXML.parse();
            stringBuffer.append(metadataXML.getSQLXML());
            stringBuffer.append("\n");
        }
        if (this.updateMeasuresSQL.length() > 0) {
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append("ALTER CUBE ");
            stringBuffer2.append(this.cube.getName());
            stringBuffer2.append(" MODIFY (\n ");
            if (this.updateMeasuresSQL.toString().endsWith(",\n")) {
                this.updateMeasuresSQL.delete(this.updateMeasuresSQL.length() - 2, this.updateMeasuresSQL.length());
            }
            stringBuffer2.append(this.updateMeasuresSQL.toString());
            stringBuffer2.append(")");
            metadataContext.setCubeDDL(stringBuffer2.toString());
            metadataXML.parse();
            stringBuffer.append(metadataXML.getSQLXML());
            stringBuffer.append("\n");
        }
        if (!this.measuresToRemove.isEmpty()) {
            for (String string : this.measuresToRemove.keySet()) {
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append("ALTER CUBE \n");
                stringBuffer2.append(string);
                stringBuffer2.append(" DROP( ");
                stringBuffer2.append(this.removeMeasuresString(string) + " )");
                metadataContext.setCubeDDL(stringBuffer2.toString());
                metadataXML.parse();
                stringBuffer.append(metadataXML.getSQLXML());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

