/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDialog;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.CubeCatalogManager;
import oracle.olap.cubetemplate.CubeTemplate;
import oracle.olap.cubetemplate.CubeTemplateManager;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TemplatePreprocessor;

public class ExportImportHandler {
    private final Connection conn;
    private final JDialog parentDialog;
    private final String wkDO;
    private final String olapSchema;
    private final CubeCatalogManager ccm;
    private final CubeTemplateManager ctm;
    private final ErrorDisplay errorDisplay;
    private final Resources resources;
    private final List<Object> dataObj;
    private CubeTemplate currentTemplate;
    private String tableSchema;

    public ExportImportHandler(Connection connection, CubeTemplateManager cubeTemplateManager, JDialog jDialog, List<Object> list, String string, String string2, ErrorDisplay errorDisplay, Resources resources) {
        this.conn = connection;
        this.olapSchema = string2;
        this.parentDialog = jDialog;
        this.dataObj = list;
        this.wkDO = string;
        this.errorDisplay = errorDisplay;
        this.resources = resources;
        this.ccm = new CubeCatalogManager(connection);
        this.ctm = cubeTemplateManager;
    }

    private void writeXML(Writer writer, String string, String string2, boolean bl, CubeTemplateManager.OutputFormat outputFormat) throws IOException, SQLException, Exception {
        String string3 = string2;
        if (outputFormat == CubeTemplateManager.OutputFormat.PLSQL) {
            this.ctm.saveToPLSQL(this.dataObj, bl, string, true, string3, writer);
        } else {
            this.ctm.saveToXML(this.dataObj, bl, string, true, string3, writer);
        }
    }

    public void processTemplate(String string, TemplatePreprocessor templatePreprocessor, boolean bl, boolean bl2) {
        this.ctm.createFromXML(this.olapSchema, this.wkDO, templatePreprocessor, bl2, bl, string);
    }

    public void persistXML(File file, String string, String string2, boolean bl, CubeTemplateManager.OutputFormat outputFormat) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            this.writeXML(bufferedWriter, string, string2, bl, outputFormat);
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            file.delete();
            exception.printStackTrace();
            this.errorDisplay.show(exception, this.parentDialog);
        }
    }

    private void clearSelection() {
        this.currentTemplate = new CubeTemplate();
    }

    public boolean createTableifNotExists(String string) {
        boolean bl = false;
        try {
            if (string == null) {
                string = this.conn.getMetaData().getUserName();
            }
            this.clearSelection();
            bl = this.ccm.createTableifNotExists(string);
            this.tableSchema = string;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 1031) {
                this.errorDisplay.show(sQLException, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.PRIVILEGES"), this.parentDialog);
            }
            this.errorDisplay.show(sQLException, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.CREATE_TABLE"), this.parentDialog);
        }
        return bl;
    }

    public void persistXML(CubeTemplate cubeTemplate) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.writeXML(stringWriter, cubeTemplate.getInSchemaMapping(), cubeTemplate.getVersion(), cubeTemplate.isIncludeOlapObjectSchema(), CubeTemplateManager.OutputFormat.XML);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("AW_NAME", "__AW_NAME__");
            hashMap.put("CUBE_NAME", "__CUBE_NAME__");
            TemplatePreprocessor templatePreprocessor = new TemplatePreprocessor(hashMap, null);
            cubeTemplate.setXmlTemplate(templatePreprocessor.preprocessDocument(new StringReader(stringWriter.toString())));
            cubeTemplate.setTableSchema(this.tableSchema);
            if (cubeTemplate.getType() == null) {
                ObjectType objectType = templatePreprocessor.getTemplateType();
                if (objectType == ObjectType.ALL) {
                    cubeTemplate.setType(" ");
                } else {
                    cubeTemplate.setType(objectType.getFilterString());
                }
            }
            this.ccm.persist(cubeTemplate);
        }
        catch (Exception exception) {
            this.errorDisplay.show(exception, this.parentDialog);
        }
    }

    public boolean deleteSelected(CubeTemplate cubeTemplate) {
        boolean bl = false;
        try {
            cubeTemplate.setTableSchema(this.tableSchema);
            this.ccm.delete(cubeTemplate);
            bl = true;
        }
        catch (SQLException sQLException) {
            this.errorDisplay.show(sQLException, this.resources.getString("EXPORT_TO_TABLE.DIALOG.ERROR.UNABLE_TO_DELETE", cubeTemplate.getTemplateName()), this.parentDialog);
        }
        return bl;
    }

    private void fetchData(Timestamp timestamp, String string) {
        if (!string.equals(this.currentTemplate.getTemplateName()) || !timestamp.equals(this.currentTemplate.getModified())) {
            try {
                this.currentTemplate.setModified(timestamp);
                this.currentTemplate.setTemplateName(string);
                this.currentTemplate = this.ccm.read(this.currentTemplate, this.tableSchema);
            }
            catch (SQLException sQLException) {
                this.errorDisplay.show(sQLException, this.parentDialog);
            }
            catch (IOException iOException) {
                this.errorDisplay.show(iOException, this.parentDialog);
            }
        }
    }

    public String fetchXML(Timestamp timestamp, String string) {
        this.fetchData(timestamp, string);
        return this.currentTemplate.getXmlTemplate();
    }

    public String fetchComments(Timestamp timestamp, String string) {
        if (timestamp == null || string == null) {
            return "";
        }
        this.fetchData(timestamp, string);
        return this.currentTemplate.getComment();
    }
}

