/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.controls.Toolbar;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationException;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeSubDimension;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.ddl.Identifier;
import oracle.olap.map.panels.MapDefinition;
import oracle.olap.map.panels.MapPanel;
import oracle.olap.navigator.OLAPNavigatorResource;
import oracle.olap.util.LanguageSelector;
import oracle.olap.util.LanguageSelectorPanel;

public class CubeDimensionMapPanel
extends MapPanel<CubeDimension> {
    public static final String MEMBER = "MEMBER";
    public static final String PARENT = "PARENT";
    public static final String MEMBER_KEY = "$MEMBER_KEY";
    public static final String PARENT_KEY = "$PARENT_KEY";
    private JLabel mapTypeLabel;
    private DefaultComboBoxModel mapTypeModel;
    private LanguageSelectorPanel languageSelectorPanel;
    private String languageFilter = LanguageSelectorPanel.ALL_LANGUAGES;
    private LanguageDescription[] availableLanguages;

    @Override
    protected String getUnmappableMessage() {
        int n = ((CubeDimension)this.getUpdatedObject()).getNotMappableCause();
        String string = null;
        if (n == 1 || n == 2) {
            string = OLAPArb.format("MAP_DIM_SURROGATE_ERR_MSG", ((CubeDimension)this.getUpdatedObject()).getName());
        }
        if (n == 3) {
            string = OLAPArb.get("MAP_DIM_LEVELS_ONLY_ERR_MSG");
        }
        if (string != null) {
            String string2 = OLAPArb.format("MAP_DIM_ERR_MSG", ((CubeDimension)this.getUpdatedObject()).getName()) + "\n" + string;
            return string2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MapDefinition loadMappings(boolean bl) throws SQLException, DBException {
        Object object;
        Object object2;
        MapDefinition mapDefinition = new MapDefinition();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = null;
        if (((CubeDimension)this.getUpdatedObject()).isFlatDimension()) {
            this.setColumnWidth(2, 0);
        } else {
            this.setColumnWidth(2, 100);
        }
        TableColumnModel tableColumnModel = this.getMapTable().getColumnModel();
        tableColumnModel.getColumn(2).setHeaderValue(OLAPArb.get("MAP_PANEL_TABLE_HIERARCHY_COLUMN"));
        boolean bl2 = ((CubeDimension)this.getUpdatedObject()).isMapSnowFlake();
        for (CubeDimensionHierarchy object3 : ((CubeDimension)this.getUpdatedObject()).getHierarchies()) {
            Object object4;
            Object object5;
            if (!object3.getHierarchyLevelType()) {
                String bl4 = null;
                if (object3.getMap() != null) {
                    bl4 = object3.getMap().getKeyExpression();
                    stringBuffer2.append(bl4 + ",");
                }
                if (string == null && bl4 != null && ((Object[])(object2 = bl4.split("\\."))).length > 1) {
                    string = this.constructSources(string, (String)object2[0]);
                }
                object2 = String.format("%s.%s", object3.getName(), MEMBER_KEY);
                String n = MEMBER;
                String i = object3.getName();
                mapDefinition.put((String)object2, (DBObject)object3, n, bl4, i, true);
                object5 = null;
                if (object3.getMap() != null) {
                    object5 = object3.getMap().getParentKeyExpression();
                    stringBuffer2.append((String)object5 + ",");
                }
                object2 = String.format("%s.%s", object3.getName(), PARENT_KEY);
                n = PARENT;
                i = object3.getName();
                mapDefinition.put((String)object2, (DBObject)object3, n, (String)object5, i, true);
                boolean cubeDimensionLevel = true;
                n = "";
                object2 = object3.getName();
                i = object3.getName();
                object4 = new ArrayList();
                for (CubeDimensionAttribute cubeDimensionAttribute : object3.getVisibleAttributes()) {
                    object4.add(cubeDimensionAttribute);
                }
                this.loadAttributeMaps((List<CubeDimensionAttribute>)object4, (String)object2, n, i, mapDefinition, object3.getMap(), object3.getName(), stringBuffer2);
                continue;
            }
            boolean string9 = true;
            object2 = object3.getHierarchyLevelsReverse();
            int n = ((CubeDimensionHierarchyLevel[])object2).length;
            for (int i = 0; i < n; ++i) {
                void var22_42;
                Object object6;
                object5 = object2[i];
                CubeDimensionLevel cubeDimensionAttribute = ((CubeDimensionHierarchyLevel)object5).getLevel();
                object4 = ((CubeDimensionHierarchyLevel)object5).getLevel().getName();
                CubeDimensionAttribute[] cubeDimensionAttributeArray = null;
                String string2 = null;
                CubeDimensionMap cubeDimensionMap = ((CubeDimensionHierarchyLevel)object5).getMap();
                if (cubeDimensionMap == null) {
                    cubeDimensionMap = ((CubeDimensionHierarchyLevel)object5).getLevel().getMap();
                }
                if (cubeDimensionMap != null) {
                    cubeDimensionAttributeArray = cubeDimensionMap.getKeyExpression();
                    string2 = cubeDimensionMap.getMapWhereClause();
                    if (string2 != null) {
                        this.setFilter(string2);
                    }
                }
                if (cubeDimensionAttributeArray != null && cubeDimensionAttributeArray.length() > 0) {
                    String string3 = this.extractSourceFromExpression((String)cubeDimensionAttributeArray);
                    string = this.constructSources(string, string3);
                }
                stringBuffer.append((String)object4 + ",");
                stringBuffer2.append((String)cubeDimensionAttributeArray + ",");
                String string4 = object4;
                Object object7 = object4;
                String string5 = object3.getName();
                String string6 = String.format("%s.%s", object3.getName(), object4);
                mapDefinition.put(string6, (DBObject)cubeDimensionAttribute, (String)object7, (String)cubeDimensionAttributeArray, string5, true);
                if (bl2 && !string9) {
                    object6 = "";
                    if (cubeDimensionMap != null) {
                        object6 = cubeDimensionMap.getParentKeyExpression();
                    }
                    Object object8 = object4;
                    object7 = (String)object4 + " PARENT";
                    string5 = object3.getName();
                    string6 = String.format("%s.%s.%s", object3.getName(), object4, PARENT_KEY);
                    mapDefinition.put(string6, (DBObject)cubeDimensionAttribute, (String)object7, (String)object6, string5, true);
                }
                string9 = false;
                object6 = new ArrayList();
                for (CubeDimensionAttribute cubeDimensionAttribute2 : ((CubeSubDimension)object5).getVisibleAttributes()) {
                    object6.add(cubeDimensionAttribute2);
                }
                object7 = object4;
                string6 = String.format("%s.%s", object3.getName(), object4);
                this.loadAttributeMaps((List<CubeDimensionAttribute>)object6, string6, (String)object7, string5, mapDefinition, cubeDimensionMap, (String)var22_42, stringBuffer2);
            }
        }
        if (((CubeDimension)this.getUpdatedObject()).getLevels().length == 0 && ((CubeDimension)this.getUpdatedObject()).getHierarchies().length == 0) {
            String[] stringArray;
            object = null;
            if (((CubeDimension)this.getUpdatedObject()).getMap() != null) {
                object = ((CubeDimension)this.getUpdatedObject()).getMap().getKeyExpression();
            }
            if (string == null && object != null && (stringArray = ((String)object).split("\\.")).length > 1) {
                string = stringArray[0];
            }
            if (object != null && !((String)object).isEmpty()) {
                stringBuffer2.append((String)object + ",");
            }
            String string8 = "";
            mapDefinition.put(MEMBER_KEY, this.getUpdatedObject(), MEMBER, (String)object, string8, true);
            int n = 0;
            String string7 = "";
            String string9 = "";
            object2 = new ArrayList();
            for (CubeDimensionAttribute cubeDimensionAttribute : ((CubeDimension)this.getUpdatedObject()).getAttributes()) {
                if (cubeDimensionAttribute.isAttributeVisibleForAll()) continue;
                object2.add(cubeDimensionAttribute);
            }
            this.loadAttributeMaps((List<CubeDimensionAttribute>)object2, string7, string9, string8, mapDefinition, ((CubeDimension)this.getUpdatedObject()).getMap(), null, stringBuffer2);
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (stringBuffer2.toString().endsWith(",")) {
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        }
        object = "";
        if (string != null && !string.isEmpty()) {
            object = String.format("select %s\n from %s", stringBuffer2, string);
        }
        this.setQuery(((String)object).toString());
        if (bl) {
            this.setSource(string);
        }
        return mapDefinition;
    }

    private String constructSources(String object, String string) {
        if (object == null || ((String)object).length() == 0) {
            return string;
        }
        if (string != null && ((String)object).indexOf(string) == -1) {
            object = (String)object + "," + string;
        }
        return object;
    }

    @Override
    protected void initialisePanel() {
        this.languageFilter = LanguageSelectorPanel.ALL_LANGUAGES;
        super.initialisePanel();
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
        boolean bl = false;
        for (CubeDimensionAttribute cubeDimensionAttribute : cubeDimension.getAttributes()) {
            if (!cubeDimensionAttribute.isNls()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.addLanguagesToLanguagesSelectorPanel();
        } else {
            this.languageSelectorPanel.setVisible(false);
        }
    }

    private void addLanguagesToLanguagesSelectorPanel() {
        LanguageDescription[] languageDescriptionArray = this.getAvailableLanguages();
        if (languageDescriptionArray != null && languageDescriptionArray.length > 0) {
            this.languageSelectorPanel.setVisible(true);
            this.languageSelectorPanel.clearLanguages();
            this.languageSelectorPanel.addLanguage(LanguageSelectorPanel.ALL_LANGUAGES);
            for (LanguageDescription languageDescription : languageDescriptionArray) {
                this.languageSelectorPanel.addLanguage(languageDescription.getLanguage());
            }
        } else {
            this.languageSelectorPanel.setVisible(false);
        }
    }

    private LanguageDescription[] getAvailableLanguages() {
        if (this.availableLanguages == null) {
            CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
            this.availableLanguages = cubeDimension.getLanguageDescriptions();
            if (this.availableLanguages != null && this.availableLanguages.length > 0) {
                return this.availableLanguages;
            }
            for (CubeDimensionLevel abstractChildObjectWithDesc : cubeDimension.getLevels()) {
                this.availableLanguages = abstractChildObjectWithDesc.getLanguageDescriptions();
                if (this.availableLanguages == null || this.availableLanguages.length <= 0) continue;
                return this.availableLanguages;
            }
            for (CubeSubDimension cubeSubDimension : cubeDimension.getHierarchies()) {
                this.availableLanguages = cubeSubDimension.getLanguageDescriptions();
                if (this.availableLanguages == null || this.availableLanguages.length <= 0) continue;
                return this.availableLanguages;
            }
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : cubeDimension.getAttributes()) {
                this.availableLanguages = abstractChildObjectWithDesc.getLanguageDescriptions();
                if (this.availableLanguages == null || this.availableLanguages.length <= 0) continue;
                return this.availableLanguages;
            }
        }
        return this.availableLanguages;
    }

    @Override
    public void addToolbar(Toolbar toolbar) {
        if (this.languageSelectorPanel == null) {
            this.languageSelectorPanel = new LanguageSelectorPanel(new LanguageSelector(){

                @Override
                public void languageSelectionChanged(String string) {
                    CubeDimensionMapPanel.this.languageFilter = string;
                    try {
                        CubeDimensionMapPanel.this.loadAndDisplayMappings(true);
                        CubeDimensionMapPanel.this.autoMap();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
            });
            toolbar.add((Component)this.languageSelectorPanel);
        }
    }

    private void loadAttributeMaps(List<CubeDimensionAttribute> list, String string, String string2, String string3, MapDefinition mapDefinition, CubeDimensionMap cubeDimensionMap, String string4, StringBuffer stringBuffer) {
        for (CubeDimensionAttribute cubeDimensionAttribute : ((CubeDimension)this.getUpdatedObject()).getAttributes()) {
            if (!cubeDimensionAttribute.isAttributeVisibleForAll()) continue;
            this.loadAttributeMap(cubeDimensionAttribute, string, string2, string3, mapDefinition, cubeDimensionMap, string4, stringBuffer);
        }
        for (CubeDimensionAttribute cubeDimensionAttribute : list) {
            this.loadAttributeMap(cubeDimensionAttribute, string, string2, string3, mapDefinition, cubeDimensionMap, string4, stringBuffer);
        }
    }

    private void loadAttributeMap(CubeDimensionAttribute cubeDimensionAttribute, String string, String string2, String string3, MapDefinition mapDefinition, CubeDimensionMap cubeDimensionMap, String string4, StringBuffer stringBuffer) {
        Object object;
        String string5;
        String string6 = string5 = cubeDimensionAttribute.getName();
        String string7 = cubeDimensionAttribute.getRole();
        if (string7.equals("LONG_DESCRIPTION") || string7.equals("SHORT_DESCRIPTION")) {
            string6 = "DSC";
        }
        String string8 = "";
        if (cubeDimensionMap != null && (object = cubeDimensionMap.findAttributeMap(string5)) != null) {
            string8 = ((CubeDimensionAttributeMap)((Object)object)).getMapExpression();
        }
        object = string5;
        if (string4 != null) {
            object = String.format("%s.%s", string4, string5);
        }
        String string9 = string5;
        if (!string.isEmpty()) {
            string9 = String.format("%s.%s", string, string5);
        }
        if (string8 != null && !string8.isEmpty()) {
            stringBuffer.append(string8 + ",");
        }
        String string10 = string5;
        if (string2 != null && !string2.isEmpty()) {
            string10 = String.format("%s.%s", string2, string5);
        }
        mapDefinition.put(string9, (DBObject)cubeDimensionAttribute, string10, string8, string3, true);
        if (cubeDimensionAttribute.isNls()) {
            LanguageDescription[] languageDescriptionArray;
            for (LanguageDescription languageDescription : languageDescriptionArray = this.getAvailableLanguages()) {
                Object object2;
                String string11 = "";
                if (cubeDimensionMap != null) {
                    for (CubeDimensionAttributeMap cubeDimensionAttributeMap : object2 = cubeDimensionMap.getAttributeMaps()) {
                        if (cubeDimensionAttributeMap.getLanguage() == null || !cubeDimensionAttributeMap.getLanguage().equalsIgnoreCase(languageDescription.getLanguage())) continue;
                        string11 = cubeDimensionAttributeMap.getMapExpression();
                        break;
                    }
                }
                object2 = String.format("%s_%s", string9, languageDescription.getLanguage());
                String object3 = String.format("%s (%s)", string10, languageDescription.getLanguage());
                if (this.languageFilter.equalsIgnoreCase(LanguageSelectorPanel.ALL_LANGUAGES)) {
                    mapDefinition.put((String)object2, (DBObject)cubeDimensionAttribute, object3, string11, string3, true);
                    continue;
                }
                if (!this.languageFilter.equalsIgnoreCase(languageDescription.getLanguage())) continue;
                mapDefinition.put((String)object2, (DBObject)cubeDimensionAttribute, object3, string11, string3, true);
            }
        }
    }

    @Override
    public String getPseudoBuildQuery() {
        String string;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer("select \n");
        DefaultTableModel defaultTableModel = this.getMapTableModel();
        int n = defaultTableModel.getRowCount();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            string = (String)defaultTableModel.getValueAt(i, 3);
            String string5 = (String)defaultTableModel.getValueAt(i, 1);
            if (string5 == null || string5.isEmpty()) continue;
            String string6 = (String)defaultTableModel.getValueAt(i, 0);
            if (string.endsWith(".$PARENT_KEY")) {
                if (string4 == null) continue;
                stringBuffer2.append(String.format("%s=%s and\n ", string4, string6));
                continue;
            }
            if (string6 == null) continue;
            stringBuffer.append("  " + string6 + ",\n");
            if (string2 == null && ((String[])(object = string6.split("\\."))).length > 1) {
                string2 = object[0];
            }
            string4 = string3;
            object = this.getMapObject(i);
            if (!(object instanceof CubeDimensionHierarchyLevel)) continue;
            string3 = string6;
        }
        String string7 = this.getSource();
        if (string2 == null || string7.indexOf(",") != -1) {
            string2 = this.getSource();
        }
        if (string2 != null) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
            stringBuffer.append(String.format("from %s", string2));
            if (stringBuffer2.length() > 0) {
                stringBuffer2.delete(stringBuffer2.length() - 5, stringBuffer2.length() - 1);
                stringBuffer.append(String.format("\n where %s", stringBuffer2));
            }
            if ((string = this.getFilter()).trim().length() > 0) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append(String.format("\n and %s", string));
                } else {
                    stringBuffer.append(String.format("\n where %s", string));
                }
            }
            return stringBuffer.toString();
        }
        return "";
    }

    @Override
    public String findMatchingColumn(String string, List<DatabaseObject> list) {
        String string2 = super.findMatchingColumn(string, list);
        if (string2 == null || string2.isEmpty()) {
            String string3;
            String string4;
            String[] stringArray = string.split("\\.");
            if (stringArray.length == 2) {
                string4 = stringArray[1];
                string2 = super.findMatchingColumn(string4, list);
                string3 = stringArray[0];
                if (string2.isEmpty() && ((CubeDimension)this.getUpdatedObject()).findHierarchy(string3) != null) {
                    if (stringArray[1].equals(MEMBER_KEY)) {
                        string2 = super.findMatchingColumn("CHILD", list);
                    }
                    if (stringArray[1].equals(PARENT_KEY)) {
                        string2 = super.findMatchingColumn(PARENT, list);
                    }
                }
            }
            if (stringArray.length == 3) {
                string4 = stringArray[1];
                string3 = stringArray[2];
                CubeDimensionAttribute cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute(string3);
                if (cubeDimensionAttribute != null) {
                    String string5;
                    if (cubeDimensionAttribute.isDescriptionRole() && (string5 = this.findColumn(list, string4, new String[]{"_DESC", "_DSC", "_LABEL"})) != null) {
                        return string5;
                    }
                    string5 = cubeDimensionAttribute.getRole();
                    String string6 = this.findColumn(list, string4, string5, "END_DATE", new String[]{"_END_DATE", "_ENDDATE"});
                    if (string6 != null) {
                        return string6;
                    }
                    string6 = this.findColumn(list, string4, string5, "TIME_SPAN", new String[]{"_TIME_SPAN", "_TIMESPAN"});
                    if (string6 != null) {
                        return string6;
                    }
                } else {
                    int n = string3.lastIndexOf("_");
                    if (n == -1) {
                        return "";
                    }
                    String string7 = string3.substring(n + 1);
                    string3 = string3.substring(0, n);
                    cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute(string3);
                    if (cubeDimensionAttribute != null && cubeDimensionAttribute.isDescriptionRole() && cubeDimensionAttribute.isNls()) {
                        for (LanguageDescription languageDescription : this.getAvailableLanguages()) {
                            String string8;
                            if (!languageDescription.getLanguage().equalsIgnoreCase(string7) || (string8 = this.findColumn(list, string4, new String[]{"_DESC", "_DSC", "_LABEL"}, string7)) == null) continue;
                            return string8;
                        }
                    }
                }
            }
        }
        return string2;
    }

    private String findColumn(List<DatabaseObject> list, String string, String string2, String string3, String[] stringArray) {
        if (string2.equals(string3)) {
            return this.findColumn(list, string, stringArray);
        }
        return null;
    }

    private String findColumn(List<DatabaseObject> list, String string, String[] stringArray) {
        for (String string2 : stringArray) {
            for (DatabaseObject databaseObject : list) {
                for (Column column : databaseObject.getColumns()) {
                    if (!column.getName().equals(string + string2)) continue;
                    String string3 = new Identifier(databaseObject.getName(), column.getName()).toString();
                    return string3;
                }
            }
        }
        return null;
    }

    private String findColumn(List<DatabaseObject> list, String string, String[] stringArray, String string2) {
        for (String string3 : stringArray) {
            for (DatabaseObject databaseObject : list) {
                for (Column column : databaseObject.getColumns()) {
                    if (!column.getName().equals(string + string3 + "_" + string2)) continue;
                    String string4 = new Identifier(databaseObject.getName(), column.getName()).toString();
                    return string4;
                }
            }
        }
        return null;
    }

    @Override
    protected void clearMap() {
        for (CubeDimensionLevel cubeDimensionLevel : ((CubeDimension)this.getUpdatedObject()).getLevels()) {
            cubeDimensionLevel.setMap(null);
        }
    }

    private Object getMapObject(int n) {
        AbstractChildDBObject abstractChildDBObject;
        Object object;
        Object object2;
        String string;
        String string2 = (String)this.getMapTableModel().getValueAt(n, 3);
        String[] stringArray = string2.split("\\.");
        if (stringArray.length == 1 && ((CubeDimension)this.getUpdatedObject()).getLevels().length == 0 && ((CubeDimension)this.getUpdatedObject()).getHierarchies().length == 0) {
            if (string2.equals(MEMBER_KEY)) {
                return MEMBER_KEY;
            }
            String string3 = string2;
            CubeDimensionAttribute cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute(string3);
            return cubeDimensionAttribute;
        }
        if (stringArray.length == 2) {
            string = stringArray[0];
            object2 = ((CubeDimension)this.getUpdatedObject()).findHierarchy(string);
            boolean bl = ((CubeDimensionHierarchy)object2).getHierarchyLevelType();
            if (!bl) {
                object = stringArray[1];
                abstractChildDBObject = ((CubeDimensionHierarchy)object2).getMap();
                if (object2 != null) {
                    if (((String)object).equals(MEMBER_KEY)) {
                        return MEMBER_KEY;
                    }
                    if (((String)object).equals(PARENT_KEY)) {
                        return PARENT_KEY;
                    }
                    Object object3 = object;
                    CubeDimensionAttribute cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute((String)object3);
                    return cubeDimensionAttribute;
                }
            } else {
                String string4 = stringArray[1];
                CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = ((CubeDimensionHierarchy)object2).findHierarchyLevel(string4);
                return cubeDimensionHierarchyLevel;
            }
        }
        if (stringArray.length == 3) {
            string = stringArray[0];
            object2 = stringArray[1];
            String string5 = stringArray[2];
            object = ((CubeDimension)this.getUpdatedObject()).findHierarchy(string);
            abstractChildDBObject = ((CubeDimensionHierarchy)object).findHierarchyLevel((String)object2);
            if (abstractChildDBObject != null) {
                if (string5.equals(PARENT_KEY)) {
                    return PARENT_KEY;
                }
                CubeDimensionAttribute cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute(string5);
                return cubeDimensionAttribute;
            }
        }
        return null;
    }

    @Override
    protected void commitMap() throws SQLException, DBException {
        String string = this.getFilter();
        for (int i = 0; i < this.getMapTableModel().getRowCount(); ++i) {
            Object object;
            AbstractChildDBObject abstractChildDBObject;
            Object object2;
            Object object3;
            Object object4;
            String string2 = (String)this.getMapTableModel().getValueAt(i, 3);
            String string3 = (String)this.getMapTableModel().getValueAt(i, 0);
            if (string3 == null) continue;
            String[] stringArray = string2.split("\\.");
            if (stringArray.length == 1 && ((CubeDimension)this.getUpdatedObject()).getLevels().length == 0 && ((CubeDimension)this.getUpdatedObject()).getHierarchies().length == 0) {
                if (string2.equals(MEMBER_KEY)) {
                    object4 = ((CubeDimension)this.getUpdatedObject()).getMap();
                    if ((object4 = this.createMap((CubeDimensionMap)((Object)object4), string3, string)) != null) {
                        ((CubeDimension)this.getUpdatedObject()).setMap((CubeDimensionMap)((Object)object4));
                    }
                } else {
                    object4 = string2;
                    object3 = ((CubeDimension)this.getUpdatedObject()).getMap();
                    if (object3 == null) {
                        object3 = new CubeDimensionMap((CubeDimension)this.getUpdatedObject());
                        ((CubeDimension)this.getUpdatedObject()).setMap((CubeDimensionMap)((Object)object3));
                    }
                    this.saveAttributeMap((CubeDimensionMap)((Object)object3), string3, (String)object4);
                }
            }
            if (stringArray.length == 2) {
                object4 = stringArray[0];
                object3 = ((CubeDimension)this.getUpdatedObject()).findHierarchy((String)object4);
                boolean bl = ((CubeDimensionHierarchy)object3).getHierarchyLevelType();
                if (!bl) {
                    object2 = stringArray[1];
                    abstractChildDBObject = ((CubeDimensionHierarchy)object3).getMap();
                    if (object3 != null) {
                        if (((String)object2).equals(MEMBER_KEY)) {
                            if ((abstractChildDBObject = this.createMap((CubeDimensionMap)abstractChildDBObject, string3, string)) != null) {
                                ((CubeDimensionHierarchy)object3).setMap((CubeDimensionMap)abstractChildDBObject);
                            }
                        } else if (((String)object2).equals(PARENT_KEY)) {
                            if ((abstractChildDBObject = this.createMapParentExpr((CubeDimensionMap)abstractChildDBObject, string3)) != null) {
                                ((CubeDimensionHierarchy)object3).setMap((CubeDimensionMap)abstractChildDBObject);
                            }
                        } else {
                            object = object2;
                            if (abstractChildDBObject == null) {
                                abstractChildDBObject = new CubeDimensionMap((CubeDimension)this.getUpdatedObject());
                                ((CubeDimensionHierarchy)object3).setMap((CubeDimensionMap)abstractChildDBObject);
                            }
                            this.saveAttributeMap((CubeDimensionMap)abstractChildDBObject, string3, (String)object);
                        }
                    }
                } else {
                    object2 = stringArray[1];
                    abstractChildDBObject = ((CubeDimensionHierarchy)object3).findHierarchyLevel((String)object2);
                    if (abstractChildDBObject != null) {
                        object = abstractChildDBObject.getMap();
                        if ((object = this.createMap((CubeDimensionHierarchy)object3, (CubeDimensionMap)((Object)object), string3, string)) != null) {
                            abstractChildDBObject.setMap((CubeDimensionMap)((Object)object));
                        }
                    }
                }
            }
            if (stringArray.length != 3) continue;
            object4 = stringArray[0];
            object3 = stringArray[1];
            String string4 = stringArray[2];
            object2 = ((CubeDimension)this.getUpdatedObject()).findHierarchy((String)object4);
            abstractChildDBObject = ((CubeDimensionHierarchy)object2).findHierarchyLevel((String)object3);
            if (abstractChildDBObject == null) continue;
            object = abstractChildDBObject.getMap();
            if (string4.equals(PARENT_KEY)) {
                ((CubeDimensionMap)((Object)object)).setParentKeyExpression(string3);
                continue;
            }
            this.saveAttributeMap((CubeDimensionMap)((Object)object), string3, string4);
        }
    }

    private CubeDimensionMap createMap(CubeDimensionMap cubeDimensionMap, String string, String string2) throws SQLException, DBException {
        return this.createMap(null, cubeDimensionMap, string, string2);
    }

    private CubeDimensionMap createMap(CubeDimensionHierarchy cubeDimensionHierarchy, CubeDimensionMap cubeDimensionMap, String string, String string2) throws SQLException, DBException {
        String string3;
        if (cubeDimensionMap == null) {
            cubeDimensionMap = new CubeDimensionMap((CubeDimension)this.getUpdatedObject());
        }
        if ((string3 = this.getMapQueryExpression(string)) == null || string3.isEmpty()) {
            string3 = this.getSource().toUpperCase();
        }
        String string4 = Identifier.stripQuotes(string3);
        cubeDimensionMap.setMapQuery(string3);
        cubeDimensionMap.setKeyExpression(this.getExpression(string3, string));
        cubeDimensionMap.setParentKeyExpression(null);
        if (string2 != null && !string2.isEmpty()) {
            cubeDimensionMap.setMapWhereClause(string2);
        } else {
            cubeDimensionMap.setMapWhereClause(null);
        }
        return cubeDimensionMap;
    }

    private CubeDimensionMap createMapParentExpr(CubeDimensionMap cubeDimensionMap, String string) throws SQLException, DBException {
        String string2;
        String[] stringArray = string.split(" ");
        if (stringArray.length == 2) {
            return null;
        }
        if (cubeDimensionMap == null) {
            cubeDimensionMap = new CubeDimensionMap((CubeDimension)this.getUpdatedObject());
        }
        if ((string2 = this.getMapQueryExpression(string)) == null || string2.isEmpty()) {
            string2 = this.getSource().toUpperCase();
        }
        String string3 = Identifier.stripQuotes(string2);
        cubeDimensionMap.setMapQuery(string3);
        string = this.getExpression(string2, string);
        cubeDimensionMap.setParentKeyExpression(string);
        return cubeDimensionMap;
    }

    private void saveAttributeMap(CubeDimensionMap cubeDimensionMap, String string, String string2) throws SQLException, DBException {
        if (cubeDimensionMap == null) {
            return;
        }
        CubeDimensionAttribute cubeDimensionAttribute = ((CubeDimension)this.getUpdatedObject()).findAttribute(string2);
        CubeDimensionAttributeMap cubeDimensionAttributeMap = cubeDimensionMap.findAttributeMap(string2);
        String string3 = this.getMapQueryExpression(string);
        if (string3 == null || string3.isEmpty()) {
            string3 = this.getSource().toUpperCase();
        }
        string = this.getExpression(string3, string);
        if (cubeDimensionMap != null) {
            if (cubeDimensionAttributeMap == null && string != null) {
                if (cubeDimensionAttribute != null) {
                    cubeDimensionAttributeMap = new CubeDimensionAttributeMap(cubeDimensionAttribute, string);
                    cubeDimensionMap.addAttributeMap(cubeDimensionAttributeMap);
                } else {
                    int n = string2.lastIndexOf("_");
                    if (n >= 0) {
                        String string4 = string2.substring(0, n);
                        String string5 = string2.substring(n + 1);
                        CubeDimensionAttribute cubeDimensionAttribute2 = ((CubeDimension)this.getUpdatedObject()).findAttribute(string4);
                        if (cubeDimensionAttribute2 != null) {
                            for (CubeDimensionAttributeMap cubeDimensionAttributeMap2 : cubeDimensionMap.getAttributeMaps()) {
                                if (!cubeDimensionAttributeMap2.getAttribute().isNls() || cubeDimensionAttributeMap2.getLanguage() == null || !cubeDimensionAttributeMap2.getLanguage().equalsIgnoreCase(string5) || !cubeDimensionAttributeMap2.getAttribute().getName().equalsIgnoreCase(string4)) continue;
                                cubeDimensionAttributeMap = cubeDimensionAttributeMap2;
                                break;
                            }
                            if (cubeDimensionAttributeMap == null && string != null && !string.isEmpty()) {
                                cubeDimensionAttributeMap = new CubeDimensionAttributeMap(cubeDimensionAttribute2, string, string5);
                                cubeDimensionMap.addAttributeMap(cubeDimensionAttributeMap);
                            }
                        }
                    }
                }
            }
            if (cubeDimensionAttributeMap != null && string != null) {
                cubeDimensionAttributeMap.setMapExpression(string);
            }
            if (cubeDimensionAttributeMap != null && string == null) {
                cubeDimensionMap.removeAttributeMap(cubeDimensionAttributeMap);
            }
        }
    }

    private CubeDimension.MAP_TYPE getMapType() {
        if (this.getSources() != null && this.getSources().size() > 1) {
            return CubeDimension.MAP_TYPE.SNOW_FLAKE;
        }
        return CubeDimension.MAP_TYPE.STAR;
    }

    @Override
    public void sourceValueChanged() throws SQLException, DBException {
        this.loadAndDisplayMappings(false);
    }

    @Override
    protected void validateObject() throws TraversalException {
        super.validateObject();
        try {
            this.getProvider().validateObjectProperty(this.getOriginalObject(), this.getUpdatedObject(), "mapWhereClause");
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    @Override
    public Icon getMapObjectIcon(int n) {
        Object object = this.getMapObject(n);
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals(MEMBER_KEY)) {
                return OLAPImagesArb.getIcon("KEY");
            }
            if (string.equals(PARENT_KEY)) {
                return OLAPImagesArb.getIcon("KEY");
            }
        }
        if (object instanceof CubeDimension) {
            return OLAPImagesArb.getIcon("DIMENSION_ICON");
        }
        if (object instanceof CubeDimensionHierarchy) {
            return OLAPImagesArb.getIcon("HIERARCHY_ICON");
        }
        if (object instanceof CubeDimensionLevel) {
            return OLAPImagesArb.getIcon("LEVEL_ICON");
        }
        if (object instanceof CubeDimensionHierarchyLevel) {
            return OLAPImagesArb.getIcon("LEVEL_ICON");
        }
        if (object instanceof CubeDimensionAttribute) {
            return OLAPNavigatorResource.getIcon("OLAPATTRIBUTE_ICON");
        }
        return null;
    }
}

