/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.olap.OLAPResources;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.db.view.DBObjectInitializer;

public class CubeDimensionInitializer
implements DBObjectInitializer<CubeDimension> {
    @Override
    public void init(DBObjectProvider dBObjectProvider, CubeDimension cubeDimension, CubeDimension cubeDimension2) {
        CubeDimension cubeDimension3 = cubeDimension2;
        if (cubeDimension == null) {
            CubeAWUtil.setAWName(cubeDimension3);
        }
        cubeDimension3.generateDescriptions();
        cubeDimension3.setAddUniqueKeys(true);
        cubeDimension3.setDimensionSortAttributeName(null);
        cubeDimension3.setDimensionSortOrder("ASC");
        cubeDimension3.setDimensionNullSortOrder("FIRST");
        cubeDimension3.setHierarchyConsistencyRule("STAR_CONSISTENT");
        if (cubeDimension3.getLevels().length == 0) {
            this.addDescriptionAttributes(dBObjectProvider, cubeDimension3);
        }
    }

    private void addDescriptionAttributes(DBObjectProvider dBObjectProvider, CubeDimension cubeDimension) {
        OLAPResources oLAPResources = new OLAPResources();
        if (cubeDimension.getAttributes().length > 0) {
            return;
        }
        CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)dBObjectProvider.getObjectFactory().newObject(CubeDimensionAttribute.class, (DBObject)cubeDimension);
        cubeDimension.addAttribute(cubeDimensionAttribute);
        String string = oLAPResources.getString("CUBE_DIMENSION_ATTRIBUTE_DESCRIPTION_NAME");
        cubeDimensionAttribute.setName(string);
        cubeDimensionAttribute.setRole("LONG_DESCRIPTION");
        cubeDimensionAttribute.setPersistedOrSpecial(true);
        cubeDimensionAttribute.setAttributeVisibleForAll(true);
        cubeDimensionAttribute.setStar(true);
        cubeDimensionAttribute.setDescription(oLAPResources.getString("CUBE_DIMENSION_ATTRIBUTE_DESCRIPTION"));
        cubeDimensionAttribute.setShortDescription(oLAPResources.getString("CUBE_DIMENSION_ATTRIBUTE_DESCRIPTION"));
        cubeDimensionAttribute.setLongDescription(oLAPResources.getString("CUBE_DIMENSION_ATTRIBUTE_DESCRIPTION"));
    }
}

