/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.CubeDimensionBuilder;
import oracle.olap.cubedimension.CubeDimensionRemoveChildDispatcher;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.panels.CubeDimensionInitializer;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.GeneralBaseEditorPanel;

public class CubeDimensionGeneralPanel
extends GeneralBaseEditorPanel<CubeDimension> {
    private JLabel dimensionClassTypeLabel;
    private JComboBox dimensionClassTypeComboBox;
    private DefaultComboBoxModel dimensionClassTypeModel;
    private JLabel dimensionSortAttributeLabel;
    private JComboBox dimensionSortAttributeComboBox;
    private DefaultComboBoxModel dimensionSortAttributeModel;
    private JRadioButton ascendingRadioButton;
    private JRadioButton descendingRadioButton;
    private JCheckBox nullsFirstCheckBox;
    private ButtonGroup sortRadioButtonGroup;
    private ActionListener sortAttributeComboBoxActionListener;
    private boolean initializedListener = false;
    private boolean initializedDependentCubes = false;
    private boolean initializedSortAttribute = false;
    private DBObjectListener cascadeChildDeleteListener;
    private static final Object OBJ_LOCK = new Object();
    private String renamedEndDateAttr;
    private String renamedTimeSpanAttr;
    private JLabel mvLabel;
    private JLabel mvValue;
    private boolean checkMVsOn;

    public CubeDimensionGeneralPanel() {
        this.initializeDimensionClassTypeComponents();
        this.layoutComponents();
        this.setDbObjectInitializer(new CubeDimensionInitializer());
        this.cascadeChildDeleteListener = new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                CubeDimension cubeDimension = (CubeDimension)CubeDimensionGeneralPanel.this.getUpdatedObject();
                List list = dBObjectChange.getOwnedObjectsRemoved();
                if (list != null && list.size() > 0) {
                    CubeDimension cubeDimension2 = cubeDimension;
                    for (DBObject dBObject : list) {
                        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
                        if (dBObject instanceof CubeDimensionAttribute) {
                            abstractChildObjectWithDesc = (CubeDimensionAttribute)dBObject;
                            if (cubeDimension2.isFlatDimension()) continue;
                            cubeDimension2.removeAttributeCascade((CubeDimensionAttribute)abstractChildObjectWithDesc);
                            continue;
                        }
                        if (!(dBObject instanceof CubeDimensionLevel)) continue;
                        abstractChildObjectWithDesc = (CubeDimensionLevel)dBObject;
                        String string = abstractChildObjectWithDesc.getName();
                        cubeDimension2.removeLevelCascade(string);
                    }
                    CubeDimensionGeneralPanel.this.disableDescriptionFieldsWhenNoChildrenLeft(cubeDimension2);
                }
            }
        };
    }

    public void initializeDimensionClassTypeComponents() {
        this.dimensionClassTypeLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_LABEL"));
        this.dimensionClassTypeLabel.setName("dimensionClassTypeLabel");
        this.dimensionClassTypeModel = new DefaultComboBoxModel();
        this.dimensionClassTypeModel.addElement(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_NONE"));
        this.dimensionClassTypeModel.addElement(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_MEASURE"));
        this.dimensionClassTypeComboBox = new JComboBox(this.dimensionClassTypeModel);
        this.dimensionClassTypeComboBox.setName("dimensionClassTypeComboBox");
        this.dimensionClassTypeComboBox.setSelectedIndex(0);
        this.dimensionSortAttributeLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_LABEL"));
        this.dimensionSortAttributeLabel.setName("dimensionSortAttributeLabel");
        this.dimensionSortAttributeModel = new DefaultComboBoxModel();
        this.dimensionSortAttributeModel.addElement(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"));
        this.dimensionSortAttributeComboBox = new JComboBox(this.dimensionSortAttributeModel);
        this.dimensionSortAttributeComboBox.setSelectedIndex(0);
        this.ascendingRadioButton = new JRadioButton(OLAPArb.getString("CUBE_DIMENSION_SORT_ASCENDING_OPTION"));
        this.descendingRadioButton = new JRadioButton(OLAPArb.getString("CUBE_DIMENSION_SORT_DESCENDING_OPTION"));
        this.nullsFirstCheckBox = new JCheckBox(OLAPArb.getString("CUBE_DIMENSION_SORT_NULLS_FIRST_OPTION"));
        this.nullsFirstCheckBox.setSelected(true);
        this.sortRadioButtonGroup = new ButtonGroup();
        this.sortRadioButtonGroup.add(this.ascendingRadioButton);
        this.sortRadioButtonGroup.add(this.descendingRadioButton);
        this.ascendingRadioButton.setSelected(true);
        this.enableSortAttributeControls(false);
        this.sortAttributeComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeDimensionGeneralPanel.this.enableSortOrderUIProperties();
            }
        };
        this.dimensionSortAttributeComboBox.addActionListener(this.sortAttributeComboBoxActionListener);
    }

    private void setupDimensionTypeChangeHandler() {
        ((CubeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void objectUpdated(DBObjectChange dBObjectChange) {
                Object object = OBJ_LOCK;
                synchronized (object) {
                    for (String string : dBObjectChange.getAllChangedProperties()) {
                        CubeDimensionAttribute cubeDimensionAttribute;
                        CubeDimension cubeDimension;
                        if (!string.equals("dimensionType")) continue;
                        String string2 = ((CubeDimension)CubeDimensionGeneralPanel.this.getUpdatedObject()).getDimensionType();
                        String string3 = OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE_NAME");
                        String string4 = OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIME_SPAN_NAME");
                        if (string2 != null && string2.equalsIgnoreCase("TIME")) {
                            if (CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf(string3) == -1) {
                                CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.addElement(string3);
                                cubeDimension = (CubeDimension)CubeDimensionGeneralPanel.this.getUpdatedObject();
                                cubeDimensionAttribute = cubeDimension.findEndDateAttribute();
                                if (cubeDimensionAttribute != null) {
                                    cubeDimension.setDimensionSortAttributeName(cubeDimensionAttribute.getOriginalAttributeName());
                                    CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedItem(string3);
                                }
                            }
                            if (CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf(string4) != -1) continue;
                            CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.addElement(string4);
                            continue;
                        }
                        if (CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf(string3) >= 0) {
                            if (CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.getSelectedItem().equals(string3)) {
                                cubeDimension = (CubeDimension)CubeDimensionGeneralPanel.this.getUpdatedObject();
                                cubeDimensionAttribute = cubeDimension.findLongDescriptionAttribute();
                                if (cubeDimensionAttribute != null) {
                                    cubeDimension.setDimensionSortAttributeName(cubeDimensionAttribute.getOriginalAttributeName());
                                    CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedItem(cubeDimensionAttribute.getName());
                                } else {
                                    CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                                }
                            }
                            CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.removeElement(string3);
                        }
                        if (CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.getIndexOf(string4) >= 0) {
                            if (CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.getSelectedItem().equals(string4)) {
                                CubeDimensionGeneralPanel.this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                            }
                            CubeDimensionGeneralPanel.this.dimensionSortAttributeModel.removeElement(string4);
                        }
                        CubeDimensionGeneralPanel.this.clearRenamedTimeAttributesFromComboBoxList();
                    }
                }
            }
        });
    }

    @Override
    public boolean isAnalyticWorkspaceRequired() {
        return false;
    }

    @Override
    protected void initialisePanel() {
        CubeDimensionAttribute cubeDimensionAttribute;
        String string;
        Object object;
        Namespace namespace;
        Window window;
        super.initialisePanel();
        if (!this.initializedListener) {
            this.setupDimensionTypeChangeHandler();
            this.initializedListener = true;
        }
        if ((window = (Window)(namespace = this.getDataContext()).get("oracle.bali.ewt.dialog.JEWTDialog")) != null) {
            object = (JEWTDialog)window;
            if (((CubeDimension)this.getUpdatedObject()).getDimensionMVEnabled()) {
                object.setOKButtonEnabled(false);
            }
        }
        if ((string = ((CubeDimension)(object = (CubeDimension)this.getUpdatedObject())).getDimensionClassType()) == null) {
            string = "NONE";
        }
        if (string.equalsIgnoreCase("MEASURE")) {
            this.dimensionClassTypeComboBox.setSelectedItem(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_MEASURE"));
        } else {
            this.dimensionClassTypeComboBox.setSelectedItem(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_NONE"));
        }
        this.dimensionSortAttributeComboBox.removeActionListener(this.sortAttributeComboBoxActionListener);
        this.dimensionSortAttributeModel.removeAllElements();
        this.dimensionSortAttributeModel.addElement(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"));
        for (CubeDimensionAttribute cubeDimensionAttribute2 : ((CubeDimension)object).getAttributes()) {
            this.dimensionSortAttributeModel.addElement(cubeDimensionAttribute2.getName());
        }
        this.dimensionSortAttributeComboBox.addActionListener(this.sortAttributeComboBoxActionListener);
        String string2 = ((CubeDimension)this.getUpdatedObject()).getDimensionType();
        if (string2 != null && string2.equalsIgnoreCase("TIME")) {
            CubeDimensionAttribute cubeDimensionAttribute3;
            CubeDimensionAttribute cubeDimensionAttribute4 = ((CubeDimension)object).findEndDateAttribute();
            if (cubeDimensionAttribute4 != null && !cubeDimensionAttribute4.getName().equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_END_DATE_NAME"))) {
                this.renamedEndDateAttr = cubeDimensionAttribute4.getName();
            }
            if ((cubeDimensionAttribute3 = ((CubeDimension)object).findTimeSpanAttribute()) != null && !cubeDimensionAttribute3.getName().equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_TIME_SPAN_NAME"))) {
                this.renamedTimeSpanAttr = cubeDimensionAttribute3.getName();
            }
        }
        if (!this.isEditing() && !this.initializedSortAttribute) {
            CubeDimensionAttribute cubeDimensionAttribute5 = ((CubeDimension)object).findLongDescriptionAttribute();
            if (cubeDimensionAttribute5 != null) {
                ((CubeDimension)object).setDimensionSortAttributeName(cubeDimensionAttribute5.getName());
            }
            this.initializedSortAttribute = true;
        }
        if ((cubeDimensionAttribute = ((CubeDimension)object).findAttributeFromOriginalName(((CubeDimension)object).getDimensionSortAttributeName())) != null) {
            if (this.dimensionSortAttributeModel.getIndexOf(cubeDimensionAttribute.getName()) != -1) {
                this.dimensionSortAttributeComboBox.setSelectedItem(cubeDimensionAttribute.getName());
                this.enableSortAttributeControls(true);
                if (((CubeDimension)object).getDimensionSortOrder().equalsIgnoreCase("ASC")) {
                    this.ascendingRadioButton.setSelected(true);
                } else {
                    this.descendingRadioButton.setSelected(true);
                }
                if (((CubeDimension)object).getDimensionNullSortOrder().equalsIgnoreCase("FIRST")) {
                    this.nullsFirstCheckBox.setSelected(true);
                } else {
                    this.nullsFirstCheckBox.setSelected(false);
                }
            } else {
                this.dimensionSortAttributeComboBox.setSelectedItem(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"));
                ((CubeDimension)object).setDimensionSortAttributeName(null);
                this.enableSortAttributeControls(false);
            }
        } else {
            this.dimensionSortAttributeComboBox.setSelectedItem(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"));
            this.enableSortAttributeControls(false);
        }
        ((CubeDimension)this.getUpdatedObject()).removeObjectListener(this.cascadeChildDeleteListener);
        ((CubeDimension)this.getUpdatedObject()).addObjectListener(this.cascadeChildDeleteListener);
        if (this.isEditing() && !this.initializedDependentCubes) {
            this.loadDependentCubes();
        }
        if (!this.isEditing()) {
            DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
            dependentTransactionalCubes.reset();
        }
        if (this.isEditing() && !this.checkMVsOn && ((CubeDimension)object).getDimensionMVEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CubeDimensionGeneralPanel.this.showMVWarningMessage(window);
                    CubeDimensionGeneralPanel.this.mvLabel.setVisible(true);
                    CubeDimensionGeneralPanel.this.mvValue.setVisible(true);
                    CubeDimensionGeneralPanel.this.checkMVsOn = true;
                }
            });
        }
    }

    private void showMVWarningMessage(Window window) {
        MessageDialog.information((Component)window, (Object)OLAPArb.format("MATERIALIZED_VIEW_DIMENSION_WARNING_MSG", ((CubeDimension)this.getUpdatedObject()).getName()), (String)OLAPArb.getString("MATERIALIZED_VIEW_DIMENSION_WARNING_TITLE"), null);
    }

    private void loadDependentCubes() {
        DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
        dependentTransactionalCubes.reset();
        try {
            CubeDimensionBuilder cubeDimensionBuilder = new CubeDimensionBuilder((OracleDatabaseImpl)this.getProvider());
            cubeDimensionBuilder.buildDependentCubes((CubeDimension)this.getUpdatedObject());
            this.initializedDependentCubes = true;
        }
        catch (DBException dBException) {
            Logger logger = Logger.getLogger(CubeDimensionGeneralPanel.class.getName());
            logger.log(Level.SEVERE, dBException.getMessage(), dBException);
            String string = null;
            String string2 = dBException.getLocalizedMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = ((Object)((Object)dBException)).getClass().toString();
            }
            String string3 = OLAPArb.get("ERROR_READING_DEPENDENT_CUBES_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Object object;
        String string;
        super.commitPanel();
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
        if (this.dimensionSortAttributeComboBox.getItemCount() > 0) {
            string = (String)this.dimensionSortAttributeComboBox.getSelectedItem();
            if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"))) {
                cubeDimension.setDimensionSortAttributeName(null);
            } else {
                object = cubeDimension.findAttribute(string);
                if (object != null) {
                    cubeDimension.setDimensionSortAttributeName(((CubeDimensionAttribute)object).getOriginalAttributeName());
                    if (this.ascendingRadioButton.isSelected()) {
                        cubeDimension.setDimensionSortOrder("ASC");
                    } else {
                        cubeDimension.setDimensionSortOrder("DESC");
                    }
                    cubeDimension.setDimensionNullSortOrder(this.nullsFirstCheckBox.isSelected() ? "FIRST" : "LAST");
                }
            }
        }
        string = "NONE";
        object = (String)this.dimensionClassTypeComboBox.getSelectedItem();
        if (((String)object).equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_TYPE_AW_PANEL_CLASS_TYPE_MEASURE"))) {
            string = "MEASURE";
            cubeDimension.setAddUniqueKeys(false);
            if (!this.isEditing()) {
                CubeDimensionLevel[] cubeDimensionLevelArray = cubeDimension.getLevels();
                CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
                if (cubeDimensionLevelArray.length == 1 && cubeDimensionHierarchyArray.length == 0) {
                    cubeDimension.removeAllLevels();
                }
            }
        }
        cubeDimension.setDimensionClassType(string);
    }

    private void disableDescriptionFieldsWhenNoChildrenLeft(CubeDimension cubeDimension) {
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
        CubeDimensionAttribute[] cubeDimensionAttributeArray = cubeDimension.getAttributes();
        CubeDimensionLevel[] cubeDimensionLevelArray = cubeDimension.getLevels();
        if (cubeDimensionHierarchyArray.length == 0 || cubeDimensionAttributeArray.length == 0 || cubeDimensionLevelArray.length == 0) {
            CubeDimensionRemoveChildDispatcher cubeDimensionRemoveChildDispatcher = CubeDimensionRemoveChildDispatcher.getInstance();
            cubeDimensionRemoveChildDispatcher.setSchemaObject(cubeDimension);
            cubeDimensionRemoveChildDispatcher.notifyObservers();
        }
    }

    private void enableSortOrderUIProperties() {
        CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
        if (this.dimensionSortAttributeComboBox.getItemCount() > 0) {
            String string = (String)this.dimensionSortAttributeComboBox.getSelectedItem();
            if (string.equalsIgnoreCase(OLAPArb.getString("CUBE_DIMENSION_SORT_ATTRIBUTE_DEFAULT_SELECTION"))) {
                this.ascendingRadioButton.setSelected(true);
                this.nullsFirstCheckBox.setSelected(true);
                this.enableSortAttributeControls(false);
            } else {
                CubeDimensionAttribute cubeDimensionAttribute = cubeDimension.findAttribute(string);
                if (cubeDimensionAttribute != null) {
                    this.enableSortAttributeControls(true);
                }
            }
        }
    }

    private void enableSortAttributeControls(boolean bl) {
        this.ascendingRadioButton.setEnabled(bl);
        this.descendingRadioButton.setEnabled(bl);
        this.nullsFirstCheckBox.setEnabled(bl);
    }

    private void clearRenamedTimeAttributesFromComboBoxList() {
        if (this.renamedEndDateAttr != null) {
            if (this.dimensionSortAttributeModel.getIndexOf(this.renamedEndDateAttr) >= 0) {
                if (this.dimensionSortAttributeComboBox.getSelectedItem().equals(this.renamedEndDateAttr)) {
                    CubeDimension cubeDimension = (CubeDimension)this.getUpdatedObject();
                    CubeDimensionAttribute cubeDimensionAttribute = cubeDimension.findLongDescriptionAttribute();
                    if (cubeDimensionAttribute != null) {
                        cubeDimension.setDimensionSortAttributeName(cubeDimensionAttribute.getOriginalAttributeName());
                        this.dimensionSortAttributeComboBox.setSelectedItem(cubeDimensionAttribute.getName());
                    } else {
                        this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                    }
                }
                this.dimensionSortAttributeModel.removeElement(this.renamedEndDateAttr);
            }
            this.renamedEndDateAttr = null;
        }
        if (this.renamedTimeSpanAttr != null) {
            if (this.dimensionSortAttributeModel.getIndexOf(this.renamedTimeSpanAttr) >= 0) {
                if (this.dimensionSortAttributeComboBox.getSelectedItem().equals(this.renamedTimeSpanAttr)) {
                    this.dimensionSortAttributeComboBox.setSelectedIndex(0);
                }
                this.dimensionSortAttributeModel.removeElement(this.renamedTimeSpanAttr);
            }
            this.renamedTimeSpanAttr = null;
        }
    }

    private void layoutComponents() {
        this.registerDescriptionFields();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setName("pnlContext");
        jPanel.setLayout(new GridBagLayout());
        int n = this.layoutDescriptionFields(jPanel);
        jPanel.add((Component)this.dimensionClassTypeLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dimensionClassTypeComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.dimensionSortAttributeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.dimensionSortAttributeComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.ascendingRadioButton, new GridBagConstraints(1, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.descendingRadioButton, new GridBagConstraints(1, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.nullsFirstCheckBox, new GridBagConstraints(1, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 0, 0, 5), 0, 0));
        this.mvLabel = new JLabel(OLAPArb.getString("CUBE_DIMENSION_GENERAL_PANEL_MATERIALIZED_VIEW"));
        this.mvValue = new JLabel(OLAPArb.getString("CUBE_DIMENSION_GENERAL_PANEL_MV_ON"));
        this.mvLabel.setVisible(false);
        this.mvValue.setVisible(false);
        jPanel.add((Component)this.mvLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.mvValue, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("pnlDetails");
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }
}

