/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.olap.OLAPArb;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.panels.CubeDimensionAttributeTableEditorPanel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.OLAPBaseChildTablePanel;

public class CubeDimensionAttributeTablePanel<C extends CubeDimensionAttribute, P extends CubeDimension>
extends OLAPBaseChildTablePanel<C, P> {
    MyCellEditor myCellEditor;
    private boolean setupHandler = false;
    private static final Object OBJ_LOCK = new Object();
    private static boolean isPanelActive = false;

    public CubeDimensionAttributeTablePanel() {
        super("CubeDimensionAttributeTablePanel");
        this.init();
    }

    public CubeDimensionAttributeTablePanel(String string) {
        super(string);
        this.init();
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        Object object;
        if (component instanceof ReorderableTableWithTitleBar) {
            object = (ReorderableTableWithTitleBar)component;
            ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar(object.getTable(), false, true);
            reorderableTableWithTitleBar.setTableToolbar(object.getTableToolbar());
            component = reorderableTableWithTitleBar;
        }
        object = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 0, 0));
        ((JSplitPane)object).setDividerLocation(170);
        return object;
    }

    @Override
    protected void init() {
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("attributes", OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTES"));
    }

    @Override
    protected void initialisePanel() {
        isPanelActive = true;
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (!this.setupHandler) {
            this.setupDimensionTypeChangeHandler();
            this.setupHandler = true;
        }
    }

    protected void commitPanel() {
        try {
            isPanelActive = false;
            super.commitPanel();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    private void setupDimensionTypeChangeHandler() {
        ((CubeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void objectUpdated(DBObjectChange dBObjectChange) {
                Object object = OBJ_LOCK;
                synchronized (object) {
                    if (!isPanelActive) {
                        return;
                    }
                    if (!CubeDimension.isDimTypeChangeEventActive()) {
                        return;
                    }
                    for (String string : dBObjectChange.getAllChangedProperties()) {
                        if (!string.equals("dimensionType")) continue;
                        CubeDimensionAttributeTablePanel.this.commitPanel();
                        CubeDimension cubeDimension = (CubeDimension)CubeDimensionAttributeTablePanel.this.getUpdatedObject();
                        String string2 = cubeDimension.getDimensionType();
                        if (string2 == null) {
                            cubeDimension.removeTimeAttributes();
                        }
                        CubeDimensionAttributeTablePanel.this.initialisePanel();
                    }
                }
            }
        });
    }

    protected String getChildProperty() {
        return "attributes";
    }

    protected Class getChildClass() {
        return CubeDimensionAttribute.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new CubeDimensionAttributeTableEditorPanel();
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myCellEditor);
        int n2 = this.getDescriptionColumnIndex();
        TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
        tableColumn2.setCellEditor(this.myCellEditor);
        int n3 = this.getShortLabelColumnIndex();
        TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
        tableColumn3.setCellEditor(this.myCellEditor);
        int n4 = this.getLongLabelColumnIndex();
        TableColumn tableColumn4 = tableColumnModel.getColumn(n4);
        tableColumn4.setCellEditor(this.myCellEditor);
    }

    @Override
    public C newChild() {
        CubeDimensionAttribute cubeDimensionAttribute = (CubeDimensionAttribute)super.newChild();
        cubeDimensionAttribute.setDataType("VARCHAR2(256)");
        cubeDimensionAttribute.generateDescriptions();
        ((CubeDimension)this.getUpdatedObject()).addAttribute(cubeDimensionAttribute);
        return (C)cubeDimensionAttribute;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        CubeDimensionAttribute cubeDimensionAttribute;
        CubeDimension cubeDimension;
        boolean bl = true;
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
        CubeDimensionAttribute cubeDimensionAttribute2 = (CubeDimensionAttribute)abstractChildObjectWithDesc;
        String string = cubeDimensionAttribute2.getRole();
        if (string != null && (string.equalsIgnoreCase("END_DATE") || string.equalsIgnoreCase("TIME_SPAN"))) {
            cubeDimension = (CubeDimension)this.getUpdatedObject();
            if (!cubeDimension.isDimTypeChangeEventActive()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)OLAPArb.getString("DROP_END_DATE_OR_TIME_SPAN_NOT_ALLOWED_ERRMSG"), (String)OLAPArb.getString("DROP_END_DATE_OR_TIME_SPAN_NOT_ALLOWED_TITLE"), null);
                bl = false;
            }
        }
        if (bl && (cubeDimensionAttribute = (cubeDimension = (CubeDimension)this.getUpdatedObject()).findAttribute(cubeDimension.getDimensionSortAttributeName())) != null && cubeDimensionAttribute.getOriginalAttributeName().equalsIgnoreCase(cubeDimensionAttribute2.getOriginalAttributeName())) {
            cubeDimension.setDimensionSortAttributeName(null);
        }
        return bl;
    }

    class MyCellEditor
    extends OLAPBaseChildTablePanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(CubeDimensionAttributeTablePanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            int n = CubeDimensionAttributeTablePanel.this.getNameColumnIndex();
            if (this.column == n) {
                boolean bl = true;
                String string = null;
                CubeDimension cubeDimension = (CubeDimension)this.abstractChildObjectWithDesc.getParent();
                String string2 = this.abstractChildObjectWithDesc.getName();
                String string3 = this.cellTextField.getText().toUpperCase();
                if (string3 == null || string3.length() == 0) {
                    bl = false;
                    string = OLAPArb.getString("CUBE_DIMENSION_ATTRIBUTE_NAME_VALIDATION_ERROR_MSG");
                } else {
                    try {
                        CubeDimensionAttributeTablePanel.this.prov.validateName("ATTRIBUTE", string3);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = invalidNameException.getMessage();
                        bl = false;
                    }
                }
                if (bl) {
                    String string4 = CubeDimensionAttributeTablePanel.this.prov.getInternalName(string3);
                    if (cubeDimension.findAttribute(string4) != null && !string4.equals(string2)) {
                        string = OLAPArb.format("VALIDATION_ERROR_DUPLICATE_ATTRIBUTE_NAME_MSG", string4);
                        bl = false;
                    } else {
                        if (!CubeDimensionAttributeTablePanel.this.isEditing()) {
                            ((CubeDimensionAttribute)this.abstractChildObjectWithDesc).synchSortAttributeName((CubeDimension)CubeDimensionAttributeTablePanel.this.getUpdatedObject(), string4);
                        }
                        ((CubeDimensionAttribute)this.abstractChildObjectWithDesc).rename((CubeDimension)CubeDimensionAttributeTablePanel.this.getOriginalObject(), string4);
                        if (!CubeDimensionAttributeTablePanel.this.isEditing()) {
                            ((CubeDimensionAttribute)this.abstractChildObjectWithDesc).setOriginalAttributeName(string4);
                        } else if (this.abstractChildObjectWithDesc.getNewObject()) {
                            ((CubeDimensionAttribute)this.abstractChildObjectWithDesc).setOriginalAttributeName(string4);
                        }
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)OLAPArb.get("CUBE_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
                CubeDimensionAttributeTablePanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }
}

