/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.model;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Internal;
import oracle.olap.app.metadata.PartitionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeSubDimension;

public class CubeDimensionHierarchyLevel
extends CubeSubDimension
implements PartitionHierarchyLevel {
    public static final String TYPE = "HIERARCHY_LEVEL";

    public CubeDimensionHierarchyLevel() {
    }

    public CubeDimensionHierarchyLevel(CubeDimensionHierarchy cubeDimensionHierarchy, CubeDimensionLevel cubeDimensionLevel) {
        super(cubeDimensionHierarchy.getName() + "." + cubeDimensionLevel.getName());
        this.setParent((DBObject)cubeDimensionHierarchy);
        this.setLevelImpl(cubeDimensionLevel);
    }

    public String getType() {
        return TYPE;
    }

    public void setLevel(CubeDimensionLevel cubeDimensionLevel) {
        this.setLevelImpl(cubeDimensionLevel);
    }

    private void setLevelImpl(CubeDimensionLevel cubeDimensionLevel) {
        DBObjectID dBObjectID = cubeDimensionLevel.getID();
        if (dBObjectID == null) {
            dBObjectID = TemporaryObjectID.createID((DBObject)cubeDimensionLevel);
            cubeDimensionLevel.setID(dBObjectID);
        }
        this.setProperty("hierarchyLevel", dBObjectID);
    }

    public CubeDimensionLevel getLevel() {
        DBObjectID dBObjectID = (DBObjectID)this.getProperty("hierarchyLevel");
        CubeDimension cubeDimension = this.getCubeDimension();
        CubeDimensionLevel cubeDimensionLevel = (CubeDimensionLevel)cubeDimension.findOwnedObject(dBObjectID);
        if (cubeDimensionLevel == null) {
            TemporaryObjectID temporaryObjectID;
            if (dBObjectID instanceof TemporaryObjectID && (temporaryObjectID = (TemporaryObjectID)dBObjectID).getDBObject() instanceof CubeDimensionLevel) {
                cubeDimensionLevel = (CubeDimensionLevel)temporaryObjectID.getDBObject();
            }
            if (cubeDimensionLevel == null) {
                throw new IllegalStateException("Cannot find level");
            }
        }
        return cubeDimensionLevel;
    }

    public void setMap(CubeDimensionMap cubeDimensionMap) {
        this.setProperty("map", (Object)cubeDimensionMap);
    }

    public CubeDimensionMap getMap() {
        return (CubeDimensionMap)((Object)this.getProperty("map"));
    }

    @Override
    @Internal
    public CubeDimension getCubeDimension() {
        DBObject dBObject = this.getParent();
        if (dBObject instanceof CubeDimensionHierarchy) {
            CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)dBObject;
            return cubeDimensionHierarchy.getCubeDimension();
        }
        return super.getCubeDimension();
    }

    @Override
    public String getHierarchyName() {
        CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)this.getParent();
        return cubeDimensionHierarchy.getName();
    }

    @Override
    public String getLevelName() {
        String string = null;
        if (this.getLevel() != null) {
            string = this.getLevel().getName();
        } else {
            int n = this.getName().indexOf(".");
            string = this.getName().substring(n + 1);
        }
        return string;
    }

    @Override
    public int getLevelDepth() {
        int n = 0;
        CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)this.getParent();
        CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevelsReverse();
        for (int i = 0; i < cubeDimensionHierarchyLevelArray.length; ++i) {
            CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = cubeDimensionHierarchyLevelArray[i];
            if (!cubeDimensionHierarchyLevel.getName().equalsIgnoreCase(this.getName())) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    @Override
    public PartitionHierarchyLevel getPartitionHierarchyLevel() {
        return this;
    }

    public String toString() {
        return String.format("%s.%s", this.getHierarchyName(), this.getLevelName());
    }
}

