/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubebuildprocess;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cubebuildprocess.model.CubeBuildProcess;
import oracle.olap.cubexml.CubeBuildProcessXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olapi.syntax.BuildItem;
import oracle.olapi.syntax.BuildProcess;
import oracle.olapi.syntax.SyntaxObject;

public class CubeBuildProcessBuilder
extends AbstractOLAPDBObjectBuilder<CubeBuildProcess> {
    private String awName = null;
    private String objectType = null;
    private BuildItem[] buildItems = null;

    public CubeBuildProcessBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "CUBE BUILD PROCESS");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public CubeBuildProcess createObject(String string, Schema schema, DBObjectID dBObjectID) {
        CubeBuildProcess cubeBuildProcess = new CubeBuildProcess();
        cubeBuildProcess.setName(string);
        cubeBuildProcess.setSchema(schema);
        cubeBuildProcess.setID(dBObjectID);
        return cubeBuildProcess;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "analyticWorkspace", "buildItems"})
    public void buildProperties(final CubeBuildProcess cubeBuildProcess) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select description, build_process from all_cube_build_processes where build_process_name = ? and owner = ?", new Object[]{cubeBuildProcess.getName(), cubeBuildProcess.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("description");
                        cubeBuildProcess.setDescription(string);
                        String string2 = resultSet.getString("build_process");
                        BuildProcess buildProcess = (BuildProcess)SyntaxObject.fromSyntax((String)string2, null);
                        CubeBuildProcessBuilder.this.buildItems = buildProcess.getBuildItems();
                        cubeBuildProcess.setBuildItems(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)cubeBuildProcess, sQLException);
                }
            }
        });
        if (this.buildItems != null && this.buildItems.length > 0) {
            QueryWrapper queryWrapper2;
            QueryWrapper queryWrapper3;
            String string;
            String string2 = string = this.buildItems[0].getBuildObjectID();
            if (string.contains(".")) {
                queryWrapper3 = string.split("\\.");
                string2 = queryWrapper3[1];
            }
            queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "SELECT OBJECT_TYPE FROM SYS.ALL_OBJECTS O WHERE O.OBJECT_TYPE IN ('CUBE', 'CUBE DIMENSION') AND O.OBJECT_NAME = ? AND O.OWNER = ?", new Object[]{string2, cubeBuildProcess.getSchema()});
            queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            CubeBuildProcessBuilder.this.objectType = resultSet.getString("OBJECT_TYPE");
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper3.throwDBException((DBObject)cubeBuildProcess, sQLException);
                    }
                }
            });
            if (this.objectType.equalsIgnoreCase("CUBE")) {
                queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select aw_name from all_cubes where cube_name = ? and owner = ?", new Object[]{string2, cubeBuildProcess.getSchema()});
                queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                CubeBuildProcessBuilder.this.awName = resultSet.getString("aw_name");
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper2.throwDBException((DBObject)cubeBuildProcess, sQLException);
                        }
                    }
                });
            }
            if (this.objectType.equalsIgnoreCase("CUBE DIMENSION")) {
                queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select aw_name from all_cube_dimensions where dimension_name = ? and owner = ?", new Object[]{string2, cubeBuildProcess.getSchema()});
                queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                CubeBuildProcessBuilder.this.awName = resultSet.getString("aw_name");
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper2.throwDBException((DBObject)cubeBuildProcess, sQLException);
                        }
                    }
                });
            }
        }
        cubeBuildProcess.setAnalyticWorkspace(this.awName);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription"})
    public void buildDetails(CubeBuildProcess cubeBuildProcess) throws DBException, SQLException, IOException, JAXBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = cubeBuildProcess.getSchema().getName();
        String string2 = string + "." + cubeBuildProcess.getName();
        Object object = this.getObject(oracleDatabaseImpl.getConnection(), string2);
        MetadataContext metadataContext = new MetadataContext(this.getProvider());
        CubeBuildProcessXML cubeBuildProcessXML = new CubeBuildProcessXML(metadataContext, object, cubeBuildProcess);
        cubeBuildProcessXML.loadModel();
        cubeBuildProcess.setFullyLoaded(true);
    }
}

