/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.syntaxbuilder.editor.SyntaxChecker;
import oracle.olapi.syntax.SyntaxException;

public class AggregationSyntaxChecker
implements SyntaxChecker {
    private Cube cube;

    public AggregationSyntaxChecker(Cube cube) {
        this.cube = cube;
    }

    @Override
    public String isValid(String string) {
        ArrayList<String> arrayList;
        Object object = null;
        boolean bl = true;
        List<Object> list = new ArrayList();
        try {
            list = SolveSyntax.getInstance().fromSyntax(this.cube, string);
        }
        catch (SyntaxException syntaxException) {
            arrayList = OLAPArb.format("CUBE_VALIDATE_AGGRULES_SYNTAX_ERROR", string);
            arrayList = (String)((Object)arrayList) + "  " + syntaxException.getLocalizedMessage();
            object = arrayList;
            bl = false;
        }
        catch (Exception exception) {
            arrayList = OLAPArb.format("CUBE_VALIDATE_AGGRULES_SYNTAX_ERROR", string);
            arrayList = (String)((Object)arrayList) + "  " + exception.getLocalizedMessage();
            object = arrayList;
            bl = false;
        }
        if (bl) {
            CubeDimensionality[] cubeDimensionalityArray = this.cube.getDimensions();
            arrayList = new ArrayList<String>();
            boolean bl2 = false;
            boolean bl3 = true;
            String string2 = null;
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                CubeAggregationDimension cubeAggregationDimension = (CubeAggregationDimension)object2.next();
                string2 = cubeAggregationDimension.getName();
                if (arrayList.contains(string2)) {
                    bl2 = true;
                    bl = false;
                    break;
                }
                for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray) {
                    String string3 = cubeDimensionality.getName();
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    bl = false;
                    break;
                }
                arrayList.add(string2);
            }
            if (bl2) {
                object = object2 = OLAPArb.format("CUBE_VALIDATE_AGGRULES_DIMENSION_ERROR1", string2, string);
            }
            if (bl3) {
                object = object2 = OLAPArb.format("CUBE_VALIDATE_AGGRULES_DIMENSION_ERROR2", string2);
            }
        }
        return object;
    }
}

