/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.metadata.PartitionHierarchyLevel;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.ui.GroupCheckBoxSelection;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cube.partition.model.PartitionConstructModelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelMetadataHelper;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.db.model.StatefulDescriptions;

public class PartitionDimensionMetadataLoader
implements PartitionHierarchyLevelMetadataHelper,
PartitionHierarchyLevelHelper,
PartitionConstructModelHelper {
    private Cube cube;
    private Object allDimensionListObject;

    public PartitionDimensionMetadataLoader(Cube cube, Object object) {
        this.cube = cube;
        this.allDimensionListObject = object;
    }

    @Override
    public List<HierarchyLevelWrapper> buildHierarchyLevelWrapperFromPartitionHierarchyLevel(List<PartitionHierarchyLevel> list) {
        ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
        for (PartitionHierarchyLevel partitionHierarchyLevel : list) {
            arrayList.add(new HierarchyLevelWrapper(partitionHierarchyLevel));
        }
        return arrayList;
    }

    @Override
    public List<PartitionHierarchyLevel> buildPartitionHierarchyLevelFromHierarchyLevelWrapper(List<HierarchyLevelWrapper> list) {
        ArrayList<PartitionHierarchyLevel> arrayList = new ArrayList<PartitionHierarchyLevel>();
        for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
            arrayList.add(hierarchyLevelWrapper.getPartitionHierarchyLevel());
        }
        return arrayList;
    }

    @Override
    public List<GroupCheckBoxSelection> buildGroupCheckBoxSelectionFromPartitionHierarchyLevel(List<PartitionHierarchyLevel> list) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (PartitionHierarchyLevel partitionHierarchyLevel : list) {
            arrayList.add(new GroupCheckBoxSelection(partitionHierarchyLevel.getHierarchyName(), partitionHierarchyLevel.getLevelName()));
        }
        return arrayList;
    }

    public List<Dimension> getDimensions() {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        for (CubeDimension cubeDimension : this.cube.getDimensions(this.allDimensionListObject)) {
            Dimension dimension = this.getDimension(cubeDimension.getName());
            arrayList.add(dimension);
        }
        return arrayList;
    }

    public Dimension getDimension(String string) {
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
        Dimension dimension = null;
        if (string == null) {
            return dimension;
        }
        CubeDimension cubeDimension = this.cube.findDimension(this.allDimensionListObject, string);
        dimension = new Dimension(new Schema(this.cube.getSchema().getName()), this.cube.getAnalyticWorkspace(), cubeDimension.getName(), cubeDimension.getDescription(), cubeDimension.getDimensionType(), "");
        for (CubeDimensionHierarchy cubeDimensionHierarchy : cubeDimensionHierarchyArray = cubeDimension.getHierarchies()) {
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray;
            DimensionHierarchy dimensionHierarchy = dimension.addDimensionHierarchy(cubeDimensionHierarchy.getName(), cubeDimensionHierarchy.getDescription(), "LEVEL");
            dimensionHierarchy.setETViewName(cubeDimensionHierarchy.getViewName());
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels()) {
                DimensionLevel dimensionLevel = null;
                DimensionHierarchy dimensionHierarchy2 = dimension.findHierarchy(cubeDimensionHierarchy.getName());
                String string2 = cubeDimensionHierarchyLevel.getLevelName();
                String string3 = cubeDimensionHierarchyLevel.getDescription();
                dimensionLevel = dimension.findLevel(string2) == null ? dimension.addDimensionLevel(string2, string3) : dimension.findLevel(string2);
                dimensionHierarchy2.addHierarchyLevel(dimensionLevel, dimensionLevel.getDescription(), 0);
            }
        }
        return dimension;
    }

    @Override
    public List<String> getHierarchyNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Dimension dimension = this.getDimension(string);
        for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
            arrayList.add(dimensionHierarchy.getName());
        }
        return arrayList;
    }

    @Override
    public List<String> getHierarchyLevelNames(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Dimension dimension = this.getDimension(string);
        DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string2);
        for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy.getHierarchyLevels()) {
            arrayList.add(dimensionHierarchyLevel.getDimensionLevel().getName());
        }
        return arrayList;
    }

    @Override
    public PartitionHierarchyLevel getPartitionHierarchyLevelFromNames(String string, String string2, String string3) {
        boolean bl = false;
        CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = null;
        CubeDimensionality[] cubeDimensionalityArray = this.cube.getDimensions();
        for (CubeDimension cubeDimension : this.cube.getDimensions(this.allDimensionListObject)) {
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray;
            if (!cubeDimension.getName().equalsIgnoreCase(string)) continue;
            CubeDimensionHierarchy cubeDimensionHierarchy = cubeDimension.findHierarchy(string2);
            for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel2 : cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels()) {
                if (!cubeDimensionHierarchyLevel2.getLevelName().equalsIgnoreCase(string3)) continue;
                cubeDimensionHierarchyLevel = cubeDimensionHierarchyLevel2;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return cubeDimensionHierarchyLevel;
    }

    @Override
    public int getHierLevelDepthFromStartingLevel(String string, String string2, String string3) {
        boolean bl = false;
        int n = 0;
        Dimension dimension = this.getDimension(string);
        DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string2);
        for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy.getHierarchyLevels()) {
            if (dimensionHierarchyLevel.getDimensionLevel().getName().equalsIgnoreCase(string3)) {
                bl = true;
                n = 1;
                continue;
            }
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String[] getLevelNamesFromStartingLevel(String string, String string2, String string3) {
        boolean bl = false;
        int n = this.getHierLevelDepthFromStartingLevel(string, string2, string3);
        String[] stringArray = new String[n];
        int n2 = n - 1;
        Dimension dimension = this.getDimension(string);
        DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string2);
        for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy.getHierarchyLevels()) {
            if (dimensionHierarchyLevel.getDimensionLevel().getName().equalsIgnoreCase(string3)) {
                bl = true;
                stringArray[n2] = string3;
                --n2;
                continue;
            }
            if (!bl) continue;
            stringArray[n2] = dimensionHierarchyLevel.getDimensionLevel().getName();
            --n2;
        }
        return stringArray;
    }

    @Override
    public String getLevelNamesAsListFromStartingLevel(String string, String string2, String string3) {
        String[] stringArray = this.getLevelNamesFromStartingLevel(string, string2, string3);
        String[] stringArray2 = new String[stringArray.length];
        int n = stringArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringArray2[n - i] = stringArray[i];
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        for (String string4 : stringArray2) {
            if (bl) {
                stringBuffer.append(string4);
                bl = false;
                continue;
            }
            stringBuffer.append("," + string4);
        }
        return stringBuffer.toString();
    }

    @Override
    public List<String> determineHierarchyOrderFromPartitionSelections(String string, String string2, List<GroupCheckBoxSelection> list, List<String> list2) {
        block5: {
            DimensionHierarchy dimensionHierarchy;
            Dimension dimension;
            block4: {
                dimension = this.getDimension(string);
                dimensionHierarchy = null;
                if (string2 != null) {
                    dimensionHierarchy = dimension.findHierarchy(string2);
                }
                for (GroupCheckBoxSelection object : list) {
                    if (list2.contains(object.getColumnName())) continue;
                    list2.add(object.getColumnName());
                }
                if (list.size() <= 0) break block4;
                for (DimensionHierarchy dimensionHierarchy2 : dimension.getHierarchies()) {
                    if (!dimensionHierarchy2.isLevelBased() || list2.contains(dimensionHierarchy2.getName())) continue;
                    list2.add(dimensionHierarchy2.getName());
                }
                break block5;
            }
            if (dimensionHierarchy == null) break block5;
            for (DimensionHierarchy dimensionHierarchy3 : dimension.getHierarchies()) {
                if (!dimensionHierarchy3.isLevelBased()) continue;
                list2.add(dimensionHierarchy3.getName());
            }
        }
        return list2;
    }

    @Override
    public String getDefaultPartitionDimension() {
        NamedObject namedObject = null;
        boolean bl = false;
        List<Dimension> list = this.getDimensions();
        for (Dimension dimension : list) {
            if (!dimension.isTime()) continue;
            int n = 0;
            for (DimensionHierarchy namedObjectWithDesc2 : dimension.getHierarchies()) {
                if (!namedObjectWithDesc2.isLevelBased()) continue;
                ++n;
            }
            if (n <= 0) continue;
            namedObject = dimension;
            bl = true;
            break;
        }
        if (!bl) {
            int n = 0;
            Dimension namedObjectWithDesc = list.get(0);
            for (Dimension dimension : list) {
                int n2 = 0;
                for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
                    if (!dimensionHierarchy.isLevelBased()) continue;
                    ++n2;
                }
                if (n2 <= n) continue;
                n = n2;
                namedObjectWithDesc = dimension;
            }
            namedObject = namedObjectWithDesc;
        }
        return namedObject.getName();
    }

    @Override
    public List<HierarchyLevelWrapper> getDefaultPartitions(String string) {
        boolean bl = true;
        CubeDimension cubeDimension = null;
        ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
        int n = 0;
        for (CubeDimension statefulDescriptions : this.cube.getDimensions(this.allDimensionListObject)) {
            if (!statefulDescriptions.getName().equalsIgnoreCase(string)) continue;
            cubeDimension = statefulDescriptions;
            break;
        }
        for (StatefulDescriptions statefulDescriptions : cubeDimension.getHierarchies()) {
            if (!((CubeDimensionHierarchy)statefulDescriptions).getHierarchyLevelType()) continue;
            if (!bl && ++n > 1 || n > 256) break;
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = ((CubeDimensionHierarchy)statefulDescriptions).getHierarchyLevelsReverse();
            if (cubeDimensionHierarchyLevelArray.length > 2) {
                arrayList.add(new HierarchyLevelWrapper(cubeDimensionHierarchyLevelArray[1]));
                continue;
            }
            arrayList.add(new HierarchyLevelWrapper(cubeDimensionHierarchyLevelArray[0]));
        }
        return arrayList;
    }

    @Override
    public String getHierarchyViewName(String string, String string2) {
        Dimension dimension = this.getDimension(string);
        DimensionHierarchy dimensionHierarchy = dimension.findHierarchy(string2);
        return dimensionHierarchy.getViewName();
    }

    @Override
    public String getAttributeDescriptionColumnName(Connection connection, String string, String string2, String string3) throws SQLException, IOException {
        String string4 = this.getAttributeDescriptionETViewColumnName(connection, string, string2, string3);
        return string4;
    }

    private String getAttributeDescriptionETViewColumnName(Connection connection, String string, String string2, String string3) throws SQLException, IOException {
        String string4 = null;
        String string5 = "SELECT V.COLUMN_NAME FROM ALL_CUBE_HIER_VIEW_COLUMNS V,      ALL_CUBE_ATTRIBUTES A WHERE V.OWNER = ? AND V.DIMENSION_NAME=? AND       V.HIERARCHY_NAME=? AND       A.OWNER = ? AND A.DIMENSION_NAME=? AND       A.ATTRIBUTE_ROLE IN ('SHORT_DESCRIPTION',                            'LONG_DESCRIPTION') AND       A.ATTRIBUTE_NAME = V.OBJECT_NAME ORDER BY A.ATTRIBUTE_ROLE DESC";
        Object[] objectArray = new Object[]{string, string2, string3, string, string2};
        List list = DatabaseUtils.ExecuteSQL(connection, string5, objectArray);
        if (list.size() > 0) {
            List list2 = (List)list.get(0);
            string4 = (String)list2.get(0);
        }
        return string4;
    }
}

