/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.panels.CubeBuildSpecificationTableEditorPanel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.OLAPBaseChildTablePanel;
import oracle.olap.syntax.BuildSyntax;

public class CubeBuildSpecificationTablePanel<C extends CubeBuildSpecification, P extends Cube>
extends OLAPBaseChildTablePanel<C, P> {
    private final int SPEC_NAME_COLUMN = 0;
    private final int DEFAULT_SPEC_COLUMN = 1;
    private MyNameCellEditor myNameCellEditor;
    private DefaultSpecCellEditor defaultSpecCellEditor;
    private Cube cube;

    public CubeBuildSpecificationTablePanel() {
        super("CubeBuildSpecificationTablePanel");
        this.init();
    }

    public CubeBuildSpecificationTablePanel(String string) {
        super(string);
        this.init();
    }

    @Override
    protected void init() {
        this.setNameColumnIndex(0);
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("buildSpecifications", OLAPArb.get("BUILD.SPECIFICATION.TITLE"));
    }

    protected Object getAllDimensions() {
        return this.getDataContext().get("dimensions");
    }

    protected String getChildProperty() {
        return "buildSpecifications";
    }

    protected Class getChildClass() {
        return CubeBuildSpecification.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new CubeBuildSpecificationTableEditorPanel(this);
    }

    @Override
    protected void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        this.cube = (Cube)this.getUpdatedObject();
    }

    @Override
    public C newChild() {
        CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)super.newChild();
        ((Cube)this.getUpdatedObject()).addBuildSpecification(cubeBuildSpecification);
        return (C)cubeBuildSpecification;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        boolean bl = true;
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)rowInfo.getRowObject();
        CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)abstractChildObjectWithDesc;
        String string = cubeBuildSpecification.getName();
        if (string.equalsIgnoreCase("SYS_DEFAULT")) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)OLAPArb.getString("BUILD_SPECIFICATION_CANNOT_DELETE_SYS_DEFAULT_ERROR"), (String)OLAPArb.getString("BUILD_SPECIFICATION_ERROR_TITLE"), null);
            bl = false;
        } else {
            boolean bl2 = cubeBuildSpecification.isDefault();
            if (bl2) {
                int n2 = componentWrapperTableModel.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    ChildTableEditorPanel.RowInfo rowInfo2 = componentWrapperTableModel.getRow(i);
                    AbstractChildObjectWithDesc abstractChildObjectWithDesc2 = (AbstractChildObjectWithDesc)rowInfo2.getRowObject();
                    CubeBuildSpecification cubeBuildSpecification2 = (CubeBuildSpecification)abstractChildObjectWithDesc2;
                    if (!cubeBuildSpecification2.getName().equalsIgnoreCase("SYS_DEFAULT")) continue;
                    this.setRowPropertyValue(Boolean.TRUE, i, 1);
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myNameCellEditor = new MyNameCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myNameCellEditor);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setCellRenderer(new DefaultSpecCellRenderer());
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                CubeBuildSpecificationTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return c.getName();
            }

            public boolean isCellEditable(C c) {
                return !c.getName().equalsIgnoreCase("SYS_DEFAULT");
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                CubeBuildSpecificationTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((CubeBuildSpecification)c).isDefault();
            }

            public boolean isCellEditable(C c) {
                Cube cube = (Cube)CubeBuildSpecificationTablePanel.this.getUpdatedObject();
                boolean bl = cube.isMVOn();
                if (bl) {
                    return false;
                }
                return !((CubeBuildSpecification)c).isDefault();
            }
        };
        int n = this.getNameColumnIndex();
        this.addColumn(n, OLAPArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic);
        this.addColumn(1, OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"), Boolean.class, nonPropertyColumnLogic2);
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n3 = componentWrapperTableModel.getRowCount();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)rowInfo.getRowObject();
        switch (n2) {
            case 1: {
                Boolean bl = (Boolean)object;
                cubeBuildSpecification.setIsDefault(bl);
                if (bl.booleanValue()) {
                    for (int i = 0; i < n3; ++i) {
                        if (i == n) continue;
                        componentWrapperTableModel.setValueAt((Object)Boolean.FALSE, i, n2);
                    }
                    componentWrapperTableModel.fireTableRowsUpdated(0, n3 - 1);
                }
                GenericTable genericTable = this.getWrapperTable();
                genericTable.repaint();
                break;
            }
            default: {
                super.setRowPropertyValue(object, n, n2);
            }
        }
    }

    @Override
    protected boolean preserveListOrder() {
        return false;
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(125);
        return jSplitPane;
    }

    private class DefaultSpecCellRenderer
    extends DefaultTableCellRenderer {
        DefaultSpecCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setToolTipText(OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"));
            if (object != null) {
                if (object == Boolean.TRUE) {
                    jLabel.setIcon(OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_SUCCESS"));
                    jLabel.setText(null);
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(null);
                }
            }
            JLabel jLabel2 = jLabel;
            return jLabel2;
        }
    }

    private class DefaultSpecCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JCheckBox cellCheckBox = new JCheckBox();
        protected CubeBuildSpecification cubeBuildSpecification;
        protected int row;
        protected int column;

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            ChildTableEditorPanel.RowInfo rowInfo = CubeBuildSpecificationTablePanel.this.getWrapperTableModel().getRow(n);
            this.cubeBuildSpecification = (CubeBuildSpecification)rowInfo.getRowObject();
            Boolean bl2 = (Boolean)object;
            this.cellCheckBox.setSelected(bl2);
            if (bl2.booleanValue()) {
                this.cellCheckBox.setIcon(OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_SUCCESS"));
            } else {
                this.cellCheckBox.setIcon(OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_PENDING"));
            }
            return this.cellCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            Boolean bl = this.cellCheckBox.isSelected();
            return bl;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }
    }

    private class MyNameCellEditor
    extends OLAPBaseChildTablePanel.MyBaseCellEditor {
        public MyNameCellEditor() {
            super(CubeBuildSpecificationTablePanel.this);
            this.cellTextField.getDocument().removeDocumentListener(this.dl);
        }

        @Override
        public boolean stopCellEditing() {
            int n = CubeBuildSpecificationTablePanel.this.getNameColumnIndex();
            if (this.column == n) {
                boolean bl = true;
                boolean bl2 = ((CubeBuildSpecification)this.abstractChildObjectWithDesc).isDefault();
                Object object = null;
                Cube cube = ((CubeBuildSpecification)this.abstractChildObjectWithDesc).getCube();
                String string = this.abstractChildObjectWithDesc.getName();
                String string2 = this.cellTextField.getText();
                try {
                    CubeBuildSpecificationTablePanel.this.prov.validateName("BUILDSPECIFICATION", string2);
                }
                catch (InvalidNameException invalidNameException) {
                    object = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NAME_ERROR", string2);
                    object = (String)object + "  " + invalidNameException.getMessage();
                    bl = false;
                }
                if (bl && string2.equalsIgnoreCase("SYS_DEFAULT") && !bl2) {
                    object = OLAPArb.get("CUBE_VALIDATE_BUILDSPECS_SYS_DEFAULT_NAME_ERROR");
                    bl = false;
                }
                if (bl && BuildSyntax.getInstance().isKeyword(string2)) {
                    object = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_RESERVED_WORD_NAME_ERROR", string2);
                    bl = false;
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)OLAPArb.get("CUBE_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string);
                    return bl;
                }
                CubeBuildSpecificationTablePanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }
}

