/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.calcs;

import javax.swing.table.AbstractTableModel;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;

public abstract class CalculatedMeasuresTableModel
extends AbstractTableModel {
    public static String[] COLUMNS = new String[]{OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_NAME"), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_DESCRIPTION"), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_SHORT_DESCRIPTION"), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_LONG_DESCRIPTION"), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_EXPRESSION")};
    public static final int MEASURE_NAME = 0;
    public static final int MEASURE_DESCRIPTION = 1;
    public static final int MEASURE_SHORT_DESCRIPTION = 2;
    public static final int MEASURE_LONG_DESCRIPTION = 3;
    public static final int MEASURE_EXPRESSION = 4;
    private Cube cube;

    public CalculatedMeasuresTableModel(Cube cube) {
        this.cube = cube;
    }

    @Override
    public int getRowCount() {
        if (this.cube != null) {
            return this.cube.getCalculatedMeasures().length;
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                if (this.getValueAt(n, n2).equals(object)) break;
                String string = (String)this.getValueAt(n, n2);
                this.cube.getCalculatedMeasures()[n].setName((String)object);
                this.fireTableCellUpdated(n, n2);
                this.saveOldMeasureName(string, n);
                break;
            }
            case 1: {
                if (this.getValueAt(n, n2).equals(object)) break;
                this.cube.getCalculatedMeasures()[n].setDescription((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                if (this.getValueAt(n, n2).equals(object)) break;
                this.cube.getCalculatedMeasures()[n].setShortDescription((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 3: {
                if (this.getValueAt(n, n2).equals(object)) break;
                this.cube.getCalculatedMeasures()[n].setLongDescription((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 4: {
                if (this.getValueAt(n, n2).equals(object)) break;
                this.cube.getCalculatedMeasures()[n].setMeasureExpression((String)object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 0 && n2 < 4;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.cube.getCalculatedMeasures().length) {
            return "";
        }
        switch (n2) {
            case 0: {
                return this.cube.getCalculatedMeasures()[n].getName();
            }
            case 1: {
                return this.cube.getCalculatedMeasures()[n].getDescription();
            }
            case 2: {
                return this.cube.getCalculatedMeasures()[n].getShortDescription();
            }
            case 3: {
                return this.cube.getCalculatedMeasures()[n].getLongDescription();
            }
            case 4: {
                return this.cube.getCalculatedMeasures()[n].getMeasureExpression();
            }
        }
        return "";
    }

    public void addRow(CubeCalculatedMeasure cubeCalculatedMeasure) {
        this.cube.addCalculatedMeasure(cubeCalculatedMeasure);
        this.fireTableDataChanged();
    }

    public void removeRow(String string) {
        CubeCalculatedMeasure cubeCalculatedMeasure = null;
        for (CubeCalculatedMeasure cubeCalculatedMeasure2 : this.cube.getCalculatedMeasures()) {
            if (!cubeCalculatedMeasure2.getName().equalsIgnoreCase(string)) continue;
            cubeCalculatedMeasure = cubeCalculatedMeasure2;
            break;
        }
        if (cubeCalculatedMeasure != null) {
            this.cube.removeCalculatedMeasure(cubeCalculatedMeasure);
            this.fireTableDataChanged();
        }
    }

    public void setCalculatedMeasureExpressionType(String string, int n) {
        this.cube.getCalculatedMeasures()[n].setCalculatedMeasureType(string);
    }

    public String getCalculatedMeasureExpressionType(int n) {
        if (n < 0 || n >= this.cube.getCalculatedMeasures().length) {
            return "";
        }
        return this.cube.getCalculatedMeasures()[n].getCalculatedMeasureType();
    }

    public abstract void saveOldMeasureName(String var1, int var2);
}

