/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.RowSetCallBack;
import oracle.olap.app.db.RowSetMetadataCallback;
import oracle.olap.app.table.Query;
import oracle.olap.app.tree.model.AbstractTreeTableModel;
import oracle.olap.app.tree.model.TreeTableModel;
import oracle.olap.buildreports.BuildCommandNode;
import oracle.olap.buildreports.BuildNode;

public class BuildTreeTableModel
extends AbstractTreeTableModel {
    protected static String[] m_columnNames = new String[]{"BUILD_OBJECT", "PARTITION", "STATUS"};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    private Map awmBuildMap = new LinkedHashMap(100);
    List<BuildCommandNode> awCommList = new ArrayList<BuildCommandNode>();
    private BuildNode rootNode = (BuildNode)this.root;
    private int m_rowCount = 0;
    private int m_completedCount = 0;
    private boolean m_isResultSetNull = false;
    private int m_columnCount = 0;
    private String m_statusMessage;
    private Connection m_connection;
    private Query m_query;
    private Map<String, Object> m_params;
    private Query m_rootNodeStatusQuery;
    private int m_buildid;

    public BuildTreeTableModel(Connection connection, Query query, Map<String, Object> map, Query query2, int n) {
        super(new BuildNode("", "", "", ""));
        this.m_connection = connection;
        this.m_query = query;
        this.m_params = map;
        this.m_rootNodeStatusQuery = query2;
        this.m_buildid = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateTableDataModel() throws Exception {
        int n;
        String string = OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_MAINTENANCE_ID") + " " + this.m_buildid;
        RowSetCallBack rowSetCallBack = new RowSetCallBack(){
            int row = 0;
            int numOfSucsAndFails = 0;
            String dimName = "";
            String partName = "";
            String dimpartKey = "";

            @Override
            public void processRowSet(ResultSet resultSet) throws SQLException {
                if (resultSet != null) {
                    ++this.row;
                    String string = resultSet.getString(4);
                    if (string.equalsIgnoreCase("Succeeded")) {
                        ++this.numOfSucsAndFails;
                    }
                    if (this.dimpartKey.length() == 0) {
                        this.dimName = resultSet.getString(1);
                        this.partName = resultSet.getString(3);
                        this.dimpartKey = this.partName != null ? this.dimName + "-" + this.partName : this.dimName;
                        BuildTreeTableModel.this.awCommList = new ArrayList<BuildCommandNode>();
                    }
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(3);
                    Object object = "";
                    object = string3 != null ? string2 + "-" + string3 : string2;
                    if (this.dimpartKey.equalsIgnoreCase((String)object)) {
                        BuildTreeTableModel.this.awCommList = BuildTreeTableModel.this.getAwmBuildList(this.dimpartKey);
                        if (BuildTreeTableModel.this.awCommList == null || BuildTreeTableModel.this.awCommList.size() <= 0) {
                            BuildTreeTableModel.this.awCommList = new ArrayList<BuildCommandNode>();
                        }
                        boolean bl = false;
                        for (BuildCommandNode buildCommandNode : BuildTreeTableModel.this.awCommList) {
                            if (!buildCommandNode.getCommand().equalsIgnoreCase(resultSet.getString(2))) continue;
                            buildCommandNode.setStatus(resultSet.getString(4));
                            BuildTreeTableModel.this.awmBuildMap.put(this.dimpartKey, BuildTreeTableModel.this.awCommList);
                            bl = true;
                        }
                        if (!bl) {
                            BuildCommandNode buildCommandNode = new BuildCommandNode(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5));
                            BuildTreeTableModel.this.awCommList.add(buildCommandNode);
                            BuildTreeTableModel.this.awmBuildMap.put(this.dimpartKey, BuildTreeTableModel.this.awCommList);
                        }
                    } else {
                        this.dimName = resultSet.getString(1);
                        this.partName = resultSet.getString(3);
                        this.dimpartKey = this.partName != null ? this.dimName + "-" + this.partName : this.dimName;
                        BuildTreeTableModel.this.awCommList = BuildTreeTableModel.this.getAwmBuildList(this.dimpartKey);
                        if (BuildTreeTableModel.this.awCommList == null || BuildTreeTableModel.this.awCommList.size() <= 0) {
                            BuildTreeTableModel.this.awCommList = new ArrayList<BuildCommandNode>();
                        }
                        boolean bl = false;
                        for (BuildCommandNode buildCommandNode : BuildTreeTableModel.this.awCommList) {
                            if (!buildCommandNode.getCommand().equalsIgnoreCase(resultSet.getString(2))) continue;
                            buildCommandNode.setStatus(resultSet.getString(4));
                            BuildTreeTableModel.this.awmBuildMap.put(this.dimpartKey, BuildTreeTableModel.this.awCommList);
                            bl = true;
                        }
                        if (!bl) {
                            BuildCommandNode buildCommandNode = new BuildCommandNode(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5));
                            BuildTreeTableModel.this.awCommList.add(buildCommandNode);
                            BuildTreeTableModel.this.awmBuildMap.put(this.dimpartKey, BuildTreeTableModel.this.awCommList);
                        }
                    }
                    BuildTreeTableModel.this.m_rowCount = this.row;
                    BuildTreeTableModel.this.m_completedCount = this.numOfSucsAndFails;
                    BuildTreeTableModel.this.m_isResultSetNull = false;
                } else {
                    BuildTreeTableModel.this.m_isResultSetNull = true;
                }
            }
        };
        RowSetMetadataCallback rowSetMetadataCallback = new RowSetMetadataCallback(){

            @Override
            public void processRowSetMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
                if (BuildTreeTableModel.this.m_columnCount == 0) {
                    int n = resultSetMetaData.getColumnCount() - 1;
                    m_columnNames = new String[n - 1];
                    BuildTreeTableModel.m_columnNames[0] = resultSetMetaData.getColumnName(1);
                    BuildTreeTableModel.m_columnNames[1] = resultSetMetaData.getColumnName(3);
                    BuildTreeTableModel.m_columnNames[2] = resultSetMetaData.getColumnName(4);
                    BuildTreeTableModel.this.m_columnCount = n;
                }
            }
        };
        ResultSet resultSet = null;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_connection);
        if (Connections.getInstance().lock(this.m_connection)) {
            block13: {
                try {
                    resultSet = dBUtil.executeQuery(this.m_query.getText(), this.m_params);
                    if (resultSet == null || resultSet == null) break block13;
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (rowSetMetadataCallback != null) {
                        rowSetMetadataCallback.processRowSetMetadata(resultSetMetaData);
                    }
                    if (resultSetMetaData == null) break block13;
                    while (resultSet.next()) {
                        rowSetCallBack.processRowSet(resultSet);
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.m_connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_connection);
        }
        this.rootNode.setChildrenEmpty();
        this.rootNode.setObjId(string);
        int n2 = this.awmBuildMap.size();
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : this.awmBuildMap.keySet()) {
            this.awCommList = this.getAwmBuildList(string3);
            int n5 = string3.indexOf("-");
            string2 = n5 > 0 ? string3.substring(0, n5) : string3;
            for (BuildCommandNode iterator : this.awCommList) {
                String string4 = iterator.getObjectName();
                n = 0;
                for (String string5 : arrayList) {
                    if (!string5.equalsIgnoreCase(string4)) continue;
                    n = 1;
                }
                if (n != 0) continue;
                arrayList.add(string4);
            }
        }
        n2 = arrayList.size();
        this.rootNode.addNodeObjects(n2);
        for (String string3 : arrayList) {
            BuildNode buildNode = (BuildNode)this.rootNode.addDimensionNode(string3, "", "", "", n3);
            ++n3;
            int n6 = 0;
            for (String string4 : this.awmBuildMap.keySet()) {
                n = string4.indexOf("-");
                string2 = n > 0 ? string4.substring(0, n) : string4;
                if (!string3.equalsIgnoreCase(string2)) continue;
                this.awCommList = this.getAwmBuildList(string4);
                n6 += this.awCommList.size();
            }
            buildNode.addNodeObjects(n6);
            n4 = 0;
            for (String string4 : this.awmBuildMap.keySet()) {
                n = string4.indexOf("-");
                string2 = n > 0 ? string4.substring(0, n) : string4;
                if (!string3.equalsIgnoreCase(string2)) continue;
                this.awCommList = this.getAwmBuildList(string4);
                for (BuildCommandNode buildCommandNode : this.awCommList) {
                    buildNode.addDimensionNode(buildCommandNode.command, buildCommandNode.partition, buildCommandNode.status, null, n4);
                    buildNode.setObjType(buildCommandNode.objType);
                    ++n4;
                }
            }
        }
        this.root = this.rootNode;
        String string5 = this.getStatusMessage();
        if (string5 != null && string5 != "") {
            this.rootNode.setStatus(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusMessage() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("BUILDID", this.m_buildid);
        RowSetCallBack rowSetCallBack = new RowSetCallBack(){

            @Override
            public void processRowSet(ResultSet resultSet) throws SQLException {
                if (resultSet != null) {
                    BuildTreeTableModel.this.m_statusMessage = resultSet.getString(1);
                    BuildTreeTableModel.this.m_isResultSetNull = false;
                } else {
                    BuildTreeTableModel.this.m_isResultSetNull = true;
                }
            }
        };
        RowSetMetadataCallback rowSetMetadataCallback = new RowSetMetadataCallback(){

            @Override
            public void processRowSetMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
            }
        };
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_connection);
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_connection)) {
            block6: {
                try {
                    resultSet = dBUtil.executeQuery(this.m_rootNodeStatusQuery.getText(), hashMap);
                    if (resultSet == null || resultSet == null) break block6;
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (rowSetMetadataCallback != null) {
                        rowSetMetadataCallback.processRowSetMetadata(resultSetMetaData);
                    }
                    if (resultSetMetaData == null) break block6;
                    while (resultSet.next()) {
                        rowSetCallBack.processRowSet(resultSet);
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.m_connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_connection);
        }
        if (this.m_isResultSetNull) {
            return null;
        }
        return this.m_statusMessage;
    }

    public void changeAllPendingToSucceeded() throws Exception {
        int n;
        this.rootNode = (BuildNode)this.root;
        int n2 = this.awmBuildMap.size();
        int n3 = 0;
        int n4 = 0;
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.awmBuildMap.keySet()) {
            this.awCommList = this.getAwmBuildList(string2);
            int n5 = string2.indexOf("-");
            string = n5 > 0 ? string2.substring(0, n5) : string2;
            for (BuildCommandNode iterator : this.awCommList) {
                String string3 = iterator.getObjectName();
                n = 0;
                for (String string4 : arrayList) {
                    if (!string4.equalsIgnoreCase(string3)) continue;
                    n = 1;
                }
                if (n != 0) continue;
                arrayList.add(string3);
            }
        }
        n2 = arrayList.size();
        this.rootNode.addNodeObjects(n2);
        for (String string2 : arrayList) {
            BuildNode buildNode = (BuildNode)this.rootNode.addDimensionNode(string2, "", "", "", n3);
            ++n3;
            int n6 = 0;
            for (String string3 : this.awmBuildMap.keySet()) {
                n = string3.indexOf("-");
                string = n > 0 ? string3.substring(0, n) : string3;
                if (!string2.equalsIgnoreCase(string)) continue;
                this.awCommList = this.getAwmBuildList(string3);
                n6 += this.awCommList.size();
            }
            buildNode.addNodeObjects(n6);
            n4 = 0;
            for (String string3 : this.awmBuildMap.keySet()) {
                n = string3.indexOf("-");
                string = n > 0 ? string3.substring(0, n) : string3;
                if (!string2.equalsIgnoreCase(string)) continue;
                this.awCommList = this.getAwmBuildList(string3);
                for (BuildCommandNode buildCommandNode : this.awCommList) {
                    String string5 = buildCommandNode.status;
                    if (string5.equalsIgnoreCase("Pending")) {
                        string5 = "Succeeded";
                    }
                    buildNode.addDimensionNode(buildCommandNode.command, buildCommandNode.partition, string5, null, n4);
                    buildNode.setObjType(buildCommandNode.objType);
                    ++n4;
                }
            }
        }
        this.root = this.rootNode;
        this.m_completedCount = this.getRowCount();
        this.rootNode.setStatus(this.getStatusMessage());
    }

    public List getAwmBuildList(String string) {
        List list = (List)this.awmBuildMap.get(string);
        return list;
    }

    protected Object[] getChildren(Object object) {
        BuildNode buildNode = (BuildNode)object;
        return buildNode.getChildren();
    }

    @Override
    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    @Override
    public boolean isLeaf(Object object) {
        return !((BuildNode)object).isParent();
    }

    @Override
    public int getColumnCount() {
        return m_columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return m_columnNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        BuildNode buildNode = (BuildNode)object;
        switch (n) {
            case 0: {
                return buildNode.getObjectId();
            }
            case 1: {
                return buildNode.getPartition();
            }
            case 2: {
                return buildNode.getStatus();
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowCount;
    }

    public int getNumOfCompleted() {
        return this.m_completedCount;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        boolean bl = false;
        bl = super.isCellEditable(object, n);
        if (!bl && this.getColumnClass(n) == String.class) {
            bl = true;
        }
        return bl;
    }
}

