/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.buildreports.BuildStatusPanel;
import oracle.olap.preferences.OLAPBuildLogPreferenceSettings;

public class BuildStatusDialog
extends JDialog {
    private BuildStatusPanel m_buildPanel;
    private Connection m_connection;
    private JFrame m_parentFrame;
    private String m_title;
    private int m_buildid;
    private int m_validBuildId;
    private boolean cancelEnabled = false;
    private boolean abortInvoked = false;
    private boolean errorOccured = false;
    private Exception errorException;

    public BuildStatusDialog(JFrame jFrame, Connection connection, int n, int n2) {
        super(jFrame, OLAPArb.getString("BUILD_WIZARD.STATUS.BUILD_LOG_HEADER"), true);
        this.m_parentFrame = jFrame;
        this.m_validBuildId = n;
        this.m_buildid = n2;
        this.initialize(connection, n2);
        this.setDefaultCloseOperation(2);
    }

    private void initialize(Connection connection, int n) {
        this.m_connection = connection;
        this.m_buildid = n;
        this.m_buildPanel = new BuildStatusPanel(this);
        this.setContentPane(this.m_buildPanel);
        this.setMinimumSize(new Dimension(500, 400));
        this.setSize(new Dimension(1000, 750));
        this.toFront();
        this.setLocationRelativeTo(this.m_parentFrame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                BuildStatusDialog.this.cleanup();
            }
        });
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public int getBuildId() {
        return this.m_buildid;
    }

    public int getValidationBuildId() {
        return this.m_validBuildId;
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BuildStatusDialog.this.cancelEnabled) {
                    BuildStatusDialog.this.setVisible(false);
                }
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public void runDialog() {
        this.runDialog(false);
    }

    public void runDialog(boolean bl) {
        if (bl) {
            this.enableClose();
        }
        int n = OLAPBuildLogPreferenceSettings.getInstance().getQueriesRefreshTime();
        this.showBuildStatus(n);
    }

    public void showBuildStatus(int n) {
        this.setAbortInvoked(false);
        this.setErrorOccured(false);
        WindowUtils.centerWindow((Window)this, (Component)Ide.getMainWindow());
        this.m_buildPanel.showBuildStatus(n);
        this.setVisible(true);
    }

    private void cleanup() {
        if (this.m_buildPanel != null) {
            this.m_buildPanel.cleanup();
        }
        this.m_buildPanel = null;
        this.m_connection = null;
        this.m_parentFrame = null;
    }

    public void closeBuildDialog() {
        this.dispose();
    }

    public void enableClose() {
        this.m_buildPanel.enableCloseButton();
    }

    public void abortBuild() {
        this.cancelEnabled = true;
    }

    public void setAbortInvoked(boolean bl) {
        this.abortInvoked = bl;
    }

    public boolean getAbortInvoked() {
        return this.abortInvoked;
    }

    public boolean getErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean bl) {
        this.errorOccured = bl;
    }

    public void setErrorException(Exception exception) {
        this.errorException = exception;
    }

    public Exception getErrorException() {
        return this.errorException;
    }
}

