/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectShuttlePanel;
import oracle.olap.app.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.olap.db.IdentifierElement;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamLevels
extends TemplateHyperParamMultiSelect
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamLevels.class.getName());
    private Dimension dimension;
    private static final ParseNode pattern = new ParseNode("levels", null, ParseNode.PatternType.LOOP);
    Resources res = new OLAPResources();

    public TemplateHyperParamLevels() {
        this.addPropertyChangeListener(this);
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TemplateHyperParamLevels.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamLevels.this.pane && string.equals("value")) {
                    Object object = TemplateHyperParamLevels.this.pane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if ((Integer)object == 0) {
                        List<String> list = TemplateHyperParamLevels.this.multiSelectEditor.getSelectedItems();
                        if (list.size() > 0) {
                            TemplateHyperParamLevels.this.selectionDialog.setVisible(false);
                        } else {
                            String string2 = OLAPArb.get("CUBE_DIMENSION_LEVEL_SELECTION_NONE_SELECTED_ERROR_MSG");
                            String string3 = OLAPArb.get("CUBE_DIMENSION_LEVEL_SELECTION_ERROR_TITLE");
                            String string4 = null;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
                            TemplateHyperParamLevels.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    } else {
                        TemplateHyperParamLevels.this.selectionDialog.setVisible(false);
                    }
                }
            }
        };
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    private void setDimension(Dimension dimension) {
        List<Object> list = new ArrayList();
        if (dimension != null) {
            this.dimension = dimension;
            this.helpID = null;
            this.editorTitle = this.res.getString("CUBE_DIMENSION_LEVELS");
            List<DimensionLevel> list2 = dimension.getLevels();
            if (list2.size() > 0) {
                this.setVisible(true);
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = this.res.getString("CUBE_DIMENSION_HIERARCHY_AVAIL_LEVELS");
                String string2 = this.res.getString("CUBE_DIMENSION_HIERARCHY_SELECTED_LEVELS");
                for (DimensionLevel dimensionLevel : list2) {
                    String string3 = dimensionLevel.getName();
                    string3 = String.format("%s.%s", dimension.getName(), string3);
                    arrayList.add(string3);
                }
                this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2);
                list = this.getDefaultLevelSelection(dimension);
            } else {
                this.setVisible(false);
            }
        }
        this.setValue(list);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    private List<String> getDefaultLevelSelection(Dimension dimension) {
        List<DimensionLevel> list = dimension.getLevels();
        String string = dimension.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DimensionLevel dimensionLevel : list) {
            String string2 = String.format("%s.%s", string, dimensionLevel.getName());
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Dimension) {
            this.dimension = (Dimension)object;
            this.setDimension(this.dimension);
        }
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.selections.iterator();
        if (iterator.hasNext()) {
            IdentifierElement identifierElement = new IdentifierElement((String)iterator.next());
            stringBuilder.append(identifierElement.getSecond());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                identifierElement = new IdentifierElement((String)iterator.next());
                stringBuilder.append(identifierElement.getSecond());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void init() {
        String string;
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    static {
        pattern.add(new ParseNode("levels", Type.LEVEL.toString(), ParseNode.PatternType.NONE));
    }
}

