/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.olap.app.templates.templatelist.BaseTemplate;
import oracle.olap.app.templates.templatelist.Param;
import oracle.olap.app.templates.templatelist.TemplateDependent;
import oracle.olap.app.templates.templatelist.TemplateGroup;
import oracle.olap.app.templates.templatelist.TemplateNameFormat;

public class Template
extends BaseTemplate {
    public static final String TEMPLATE_TYPE_DEFAULT = "default";
    public static final String TEMPLATE_TYPE_NOTFOUND = "notfound";
    private String type;
    private String doc;
    private boolean selected;
    private boolean hasEditor;
    private TemplateNameFormat templateNameFormat;
    private List<TemplateDependent> templateDependencies = new ArrayList<TemplateDependent>();
    private boolean defaultTemplate;
    private boolean button;
    private List<Param> params;
    private List<TemplateGroup> childTemplateGroups = new ArrayList<TemplateGroup>();
    private static final String TIME = "TIME";
    private String icon;

    public boolean isTime() {
        return this.type != null && this.type.toUpperCase().startsWith(TIME);
    }

    public void addTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        return this.templateNameFormat;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setHasEditor(String string) {
        if (string != null && (string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("TRUE"))) {
            this.hasEditor = true;
        }
    }

    public boolean getHasEditor() {
        return this.hasEditor;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setSelected(String string) {
        if (string != null && (string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("TRUE"))) {
            this.selected = true;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public List<TemplateDependent> getTemplateDependencies() {
        return this.templateDependencies;
    }

    public void setTemplateDependencies(List<TemplateDependent> list) {
        this.templateDependencies = list;
    }

    public void addTemplateDependent(TemplateDependent templateDependent) {
        this.templateDependencies.add(templateDependent);
    }

    public void addTemplateGroup(TemplateGroup templateGroup) {
        this.childTemplateGroups.add(templateGroup);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.childTemplateGroups;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String string) {
        this.doc = string;
    }

    public void setDefault(String string) {
        this.defaultTemplate = Boolean.valueOf(string);
    }

    public boolean isDefault() {
        return this.defaultTemplate;
    }

    public void setButton(String string) {
        this.button = Boolean.valueOf(string);
    }

    public boolean isButton() {
        return this.button;
    }

    public void addParam(Param param) {
        if (this.params == null) {
            this.params = new ArrayList<Param>();
        }
        this.params.add(param);
    }

    public List<Param> getParams() {
        if (this.params == null) {
            return Collections.emptyList();
        }
        return this.params;
    }

    public void setParams(List<Param> list) {
        this.params = list;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public String getIcon() {
        return this.icon;
    }

    @Override
    public String toXML() {
        boolean bl = this.templateNameFormat == null;
        return this.toXML(bl);
    }

    public String toXML(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append(String.format("  <Template name=\"%s\">\n", this.getName()));
            if (this.templateNameFormat != null) {
                stringBuffer.append(String.format("    %s\n", this.templateNameFormat.toXML()));
            }
            stringBuffer.append("  </Template>\n");
        } else {
            stringBuffer.append(String.format("    <Template name=\"%s\" type=\"%s\"", this.getName(), this.type));
            if (this.selected) {
                stringBuffer.append(" selected=\"true\"");
            }
            stringBuffer.append("\n");
            if (this.getUi() != null && this.getUi().length() > 0) {
                stringBuffer.append("          ui=\"" + this.getUi() + "\"\n");
            }
            stringBuffer.append("          expression=\"" + this.getExpression() + "\"");
            stringBuffer.append("    />\n");
        }
        return stringBuffer.toString();
    }
}

