/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.FlatListMerger;
import oracle.olap.app.syntaxparser.FlatNode;
import oracle.olap.app.syntaxparser.Matcher;
import oracle.olap.app.syntaxparser.NodeFlattener;
import oracle.olap.app.syntaxparser.NodeProcessor;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.app.syntaxparser.testing.Permutation;
import oracle.olap.app.syntaxparser.testing.Template;
import oracle.olap.app.syntaxparser.testing.Templates;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.Type;
import oracle.olap.syntaxbuilder.olapihelpers.WrappedSyntaxParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParsePatternMatcher {
    private static final Logger LOG = Logger.getLogger(ParsePatternMatcher.class.getName());
    private final SyntaxParser parser;
    private FlatNode flatList;
    private static final HashSet<String> MEASURE_ALTS = new HashSet(4);
    NodeFlattener flattener;

    public ParsePatternMatcher(SyntaxParser syntaxParser) {
        this.parser = syntaxParser;
        this.flattener = new NodeFlattener();
    }

    public FlatNode getFlatList() {
        return this.flatList;
    }

    public ParseNode setupParsePattern(String string, LinkedHashMap<String, ParseNode> linkedHashMap, Map<String, List<String>> map) {
        ParseNode parseNode = new ParseNode();
        try {
            boolean bl = this.parser.parseSyntax(string, parseNode);
            if (bl) {
                Type type = Type.valueFrom((parseNode = (ParseNode)parseNode.getChildAt(0)).getType());
                if ((type == Type.BUILDSPEC || type == Type.SOLVE) && parseNode.getChildCount() == 1) {
                    parseNode = (ParseNode)parseNode.getChildAt(0);
                }
                for (String string2 : linkedHashMap.keySet()) {
                    List<String> list = map.get(string2);
                    if (list == null) continue;
                    for (String string3 : list) {
                        if (string3 == null || string3.length() == 0) continue;
                        int n = string.indexOf(string3);
                        while (n != -1) {
                            int n2 = n + string3.length();
                            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
                            while (enumeration.hasMoreElements()) {
                                ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                                int n3 = 0;
                                if (Type.valueFrom(parseNode2.getType()) == Type.STRING && string3.charAt(0) != '\'') {
                                    n3 = 1;
                                }
                                if (parseNode2.getOffset() + n3 < n || parseNode2.getEnd() - n3 > n2) continue;
                                parseNode2.addParamName(string2);
                            }
                            n = string.indexOf(string3, n2);
                        }
                    }
                }
                this.flatList = this.flatList == null ? this.flatten(parseNode, linkedHashMap) : this.merge(parseNode, linkedHashMap);
            } else {
                int n = string.indexOf(123);
                if (n != -1) {
                    LOG.finest(String.format("Invalid! : %s.", string));
                } else {
                    int n4 = string.indexOf(125);
                    if (n4 != -1) {
                        LOG.finest(String.format("Invalid! : %s.", string));
                    } else {
                        LOG.finest(String.format("Invalid! : %s.%n Parameter %s seems to have failed", string, string.substring(n, n4)));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, String.format("Template [%s] parse pattern not generated", string), throwable);
        }
        return parseNode;
    }

    public int matchesPattern(ParseNode parseNode) {
        if (this.flatList == null) {
            return 0;
        }
        return this.doMatch(this.flatList, parseNode, null);
    }

    public void loadParseNodes(ParseNode parseNode, List<TemplateHyperParam> list) {
        if (this.flatList != null) {
            this.doMatch(this.flatList, parseNode, list);
        }
    }

    private void walkTree(ParseNode parseNode, NodeProcessor nodeProcessor) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        linkedList.addFirst(parseNode);
        while (!linkedList.isEmpty()) {
            ParseNode parseNode2 = (ParseNode)linkedList.removeFirst();
            parseNode2 = nodeProcessor.processNode(parseNode2);
            if (nodeProcessor.abort()) {
                return;
            }
            if (parseNode2 == null) continue;
            this.pushChildrenToStack(linkedList, parseNode2);
        }
        nodeProcessor.finish();
    }

    private void pushChildrenToStack(LinkedList<ParseNode> linkedList, ParseNode parseNode) {
        for (int i = parseNode.getChildCount() - 1; i >= 0; --i) {
            linkedList.push((ParseNode)parseNode.getChildAt(i));
        }
    }

    private FlatNode flatten(ParseNode parseNode, Map<String, ParseNode> map) {
        this.flattener = new NodeFlattener();
        this.flattener.setParamPatterns(map);
        this.walkTree(parseNode, this.flattener);
        return this.flattener.flatList;
    }

    private FlatNode merge(ParseNode parseNode, Map<String, ParseNode> map) {
        FlatListMerger flatListMerger = new FlatListMerger(this.flatList, map);
        this.walkTree(parseNode, flatListMerger);
        return this.flattener.flatList;
    }

    private int doMatch(FlatNode flatNode, ParseNode parseNode, List<TemplateHyperParam> list) {
        Matcher matcher = new Matcher(flatNode, list);
        this.walkTree(parseNode, matcher);
        int n = matcher.getScore();
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws Exception {
        String string = "GLOBAL";
        String string2 = "adc6140199.us.oracle.com:1521:main";
        String string3 = "global";
        String string4 = "UNITS_FACT22";
        InputStream inputStream = ParsePatternMatcher.class.getResourceAsStream("testing/permutations.xml");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        Templates templates = (Templates)JavaXMLBind.BindToJava(inputStreamReader, "oracle.olap.app.syntaxparser.testing", null);
        String string5 = String.format("%s/%s", System.getProperty("user.home"), "patterns.txt");
        FileHandler fileHandler = new FileHandler(string5);
        fileHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord logRecord) {
                if (logRecord.getThrown() == null) {
                    return logRecord.getMessage() + "\n";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(logRecord.getMessage());
                stringBuilder.append("\n");
                StackTraceElement[] stackTraceElementArray = logRecord.getThrown().getStackTrace();
                for (int i = 0; i < 15 && i < stackTraceElementArray.length; ++i) {
                    stringBuilder.append(stackTraceElementArray[i].toString());
                    stringBuilder.append("\n");
                }
                return stringBuilder.toString();
            }
        });
        Class[] classArray = new Class[]{FlatListMerger.class, NodeFlattener.class, ParsePatternMatcher.class};
        Logger[] loggerArray = new Logger[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            loggerArray[i] = Logger.getLogger(classArray[i].getName());
            loggerArray[i].addHandler(fileHandler);
            loggerArray[i].setLevel(Level.FINEST);
        }
        Schema schema = new Schema(string);
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        Connection connection = DatabaseUtils.GetConnection(string2, string3, string3);
        DatabaseImpl databaseImpl = new DatabaseImpl(connection);
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
        oLAPMetadataReader.loadMetadata();
        Properties properties = new Properties();
        properties.setProperty("CUBE", string4);
        OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(schema, properties);
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element element = document.createElement("Patterns");
            for (Template object22 : templates.getTemplates()) {
                Serializable serializable;
                Element element2;
                object = document.createElement("Template");
                object.setAttribute("name", object22.getName());
                element.appendChild((Node)object);
                LOG.info(String.format("Template: %s", object22.getName()));
                OLAPISyntaxParser oLAPISyntaxParser2 = oLAPISyntaxParser;
                if (object22.getWrap() != null) {
                    oLAPISyntaxParser2 = new WrappedSyntaxParser(schema, properties, object22.getWrap());
                }
                ParsePatternMatcher parsePatternMatcher = new ParsePatternMatcher(oLAPISyntaxParser2);
                for (Permutation permutation : object22.getPermutations()) {
                    element2 = document.createElement("Expression");
                    object.appendChild(element2);
                    element2.setTextContent(permutation.getExpression());
                    LOG.info(String.format("Expression : %s", permutation.getExpression()));
                    parsePatternMatcher.setupParsePattern(permutation.getExpression(), permutation.getParamPatterns(), permutation.getCurrentValues());
                    serializable = new StringBuilder();
                    FlatNode flatNode = parsePatternMatcher.flatList;
                    if (flatNode != null) {
                        ((StringBuilder)serializable).append(flatNode);
                        for (flatNode = flatNode.getNext(); flatNode != null; flatNode = flatNode.getNext()) {
                            ((StringBuilder)serializable).append("\n");
                            ((StringBuilder)serializable).append(flatNode);
                        }
                    }
                    LOG.info(((StringBuilder)serializable).toString());
                }
                StringBuilder stringBuilder = new StringBuilder();
                FlatNode flatNode = parsePatternMatcher.flatList;
                element2 = document.createElement("Pattern");
                object.appendChild(element2);
                if (flatNode != null) {
                    void var27_35;
                    stringBuilder.append(flatNode);
                    flatNode.marshall(document, element2);
                    FlatNode flatNode2 = flatNode.getNext();
                    while (var27_35 != null) {
                        stringBuilder.append("\n");
                        stringBuilder.append(var27_35);
                        var27_35.marshall(document, element2);
                        FlatNode flatNode3 = var27_35.getNext();
                    }
                }
                LOG.info(stringBuilder.toString());
                serializable = new ParseNode();
                int n = 0;
                for (Permutation permutation : object22.getPermutations()) {
                    oLAPISyntaxParser2.setSyntax(permutation.getExpression());
                    NodeList nodeList = object.getChildNodes();
                    if (oLAPISyntaxParser2.parseSyntax((ParseNode)serializable)) {
                        int n2 = 0;
                        if (object22.getWrap() != null) {
                            serializable = (ParseNode)((ParseNode)serializable).getChildren().get(0);
                        }
                        n2 = parsePatternMatcher.matchesPattern((ParseNode)((ParseNode)serializable).getChildren().get(0));
                        ((Element)nodeList.item(n)).setAttribute("score", String.valueOf(n2));
                    } else {
                        ((Element)nodeList.item(n)).setAttribute("score", "-1");
                    }
                    ++n;
                }
            }
            element.normalize();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(element);
            object = new File(String.format("%s/%s.xml", System.getProperties().get("user.home"), "patterns"));
            transformer.transform(dOMSource, new StreamResult((File)object));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.log(Level.SEVERE, "Fatal Error", parserConfigurationException);
        }
    }

    static {
        MEASURE_ALTS.add(Type.FUNCTION.toString());
        MEASURE_ALTS.add(Type.OPERATOR.toString());
        MEASURE_ALTS.add(Type.MEASURE.toString());
        MEASURE_ALTS.add(Type.QDR.toString());
    }
}

