/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.util.Logger;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionHierarchyView;
import oracle.olap.app.olapmetadata.DimensionHierarchyViewColumn;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.DimensionView;
import oracle.olap.app.olapmetadata.DimensionViewColumn;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.Schema;

public class Dimension
extends NamedObjectWithDesc
implements Cloneable {
    public static final String TYPE = "dimension";
    private Schema schema;
    private String awName;
    private List<DimensionLevel> levels;
    private List<DimensionHierarchy> hiers;
    private List<DimensionAttribute> attrs;
    private boolean isTime;
    private DimensionView dimView;
    private String defaultHierarchyName;
    private Database database;
    public static final String TIME = "TIME";

    public Dimension(Schema schema, String string, String string2, String string3) {
        this(schema, string, string2, string3, "", null);
    }

    public Dimension(Schema schema, String string, String string2, String string3, String string4, String string5) {
        super(string2, string3);
        this.schema = schema;
        this.awName = string;
        this.levels = new ArrayList<DimensionLevel>();
        this.hiers = new ArrayList<DimensionHierarchy>();
        this.attrs = new ArrayList<DimensionAttribute>();
        this.isTime = string4 != null ? string4.equals(TIME) : false;
        this.defaultHierarchyName = string5;
    }

    public Dimension(Database database, Schema schema, String string, String string2, String string3, String string4, String string5) {
        this(schema, string, string2, string3, string4, string5);
        this.database = database;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getID() {
        if (this.schema != null) {
            return String.format("%s.%s", this.schema.getName(), this.getName());
        }
        return this.getName();
    }

    public String getAWName() {
        return this.awName;
    }

    public void setViewName(String string) {
        if (this.dimView == null) {
            this.dimView = new DimensionView(this, string);
        } else {
            this.dimView.setName(string);
        }
    }

    public String getViewName() {
        if (this.database != null) {
            String string = null;
            try {
                string = this.database.getUser();
            }
            catch (Exception exception) {
                Logger.severe(Dimension.class, (Throwable)exception);
            }
            if (string != null && !string.equalsIgnoreCase(this.schema.getName())) {
                return this.schema.getName() + "." + this.dimView;
            }
        }
        return this.dimView != null ? this.dimView.getName() : null;
    }

    public DimensionAttribute addDimensionAttribute(String string, String string2, String string3) {
        DimensionAttribute dimensionAttribute = new DimensionAttribute(this, string, string2, string3);
        this.attrs.add(dimensionAttribute);
        return dimensionAttribute;
    }

    public DimensionAttribute findAttribute(String string) {
        for (DimensionAttribute dimensionAttribute : this.attrs) {
            if (!dimensionAttribute.getName().equalsIgnoreCase(string)) continue;
            return dimensionAttribute;
        }
        return null;
    }

    public DimensionAttribute findAttributeType(String string) {
        return this.findAttributeRole(string);
    }

    public DimensionAttribute findAttributeRole(String string) {
        for (DimensionAttribute dimensionAttribute : this.attrs) {
            if (dimensionAttribute.getRole() == null || !dimensionAttribute.getRole().equalsIgnoreCase(string)) continue;
            return dimensionAttribute;
        }
        return null;
    }

    public List<DimensionAttribute> getAttributes() {
        return this.attrs;
    }

    public DimensionLevel addDimensionLevel(String string, String string2) {
        DimensionLevel dimensionLevel = new DimensionLevel(this, string, string2);
        this.levels.add(dimensionLevel);
        return dimensionLevel;
    }

    public DimensionLevel addDimensionLevel(String string, String string2, int n) {
        DimensionLevel dimensionLevel = new DimensionLevel(this, string, string2);
        this.levels.add(n, dimensionLevel);
        return dimensionLevel;
    }

    public DimensionLevel findLevel(String string) {
        for (DimensionLevel dimensionLevel : this.levels) {
            if (!dimensionLevel.getName().equalsIgnoreCase(string)) continue;
            return dimensionLevel;
        }
        return null;
    }

    public List<DimensionLevel> getLevels() {
        return this.levels;
    }

    public List<DimensionHierarchy> getHierarchies() {
        return this.hiers;
    }

    public DimensionHierarchy getDefaultHierarchy() {
        for (DimensionHierarchy dimensionHierarchy : this.hiers) {
            if (!dimensionHierarchy.getName().equals(this.defaultHierarchyName)) continue;
            return dimensionHierarchy;
        }
        if (this.hiers.size() > 0) {
            return this.hiers.get(0);
        }
        return null;
    }

    public DimensionHierarchy addDimensionHierarchy(String string, String string2, String string3) {
        DimensionHierarchy dimensionHierarchy = new DimensionHierarchy(this, string, string2, string3, false, false);
        this.hiers.add(dimensionHierarchy);
        return dimensionHierarchy;
    }

    public DimensionHierarchy addDimensionHierarchy(Database database, String string, String string2, String string3, boolean bl, boolean bl2) {
        DimensionHierarchy dimensionHierarchy = new DimensionHierarchy(database, this, string, string2, string3, bl, bl2);
        this.hiers.add(dimensionHierarchy);
        return dimensionHierarchy;
    }

    public DimensionHierarchy findHierarchy(String string) {
        for (DimensionHierarchy dimensionHierarchy : this.hiers) {
            if (!dimensionHierarchy.getName().equalsIgnoreCase(string)) continue;
            return dimensionHierarchy;
        }
        return null;
    }

    public boolean isTime() {
        return this.isTime;
    }

    public void setView(DimensionView dimensionView) {
        this.dimView = dimensionView;
    }

    public DimensionView getView() {
        return this.dimView;
    }

    public String getOrderColumnName() {
        DimensionViewColumn dimensionViewColumn = this.getView().findColumnType("DIM_ORDER");
        return dimensionViewColumn != null ? dimensionViewColumn.getName() : null;
    }

    public String getKeyColumnName() {
        String string = "KEY";
        DimensionViewColumn dimensionViewColumn = this.dimView.findColumnType(string);
        if (dimensionViewColumn != null) {
            string = dimensionViewColumn.getName();
        }
        return string;
    }

    public String getDisplayColumnName() {
        DimensionAttribute dimensionAttribute = this.findAttributeRole("SHORT_DESCRIPTION");
        if (dimensionAttribute == null) {
            dimensionAttribute = this.findAttributeRole("LONG_DESCRIPTION");
        }
        DimensionViewColumn dimensionViewColumn = null;
        if (this.isFlat()) {
            dimensionViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
            if (dimensionViewColumn != null) {
                return dimensionViewColumn.getName();
            }
        } else {
            String string;
            DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
            if (dimensionHierarchy != null && (string = dimensionHierarchy.getDisplayColumnName()) != null) {
                return string;
            }
        }
        return dimensionViewColumn != null ? dimensionViewColumn.getName() : null;
    }

    public String getDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.findAttributeRole("DESCRIPTION");
        DimensionViewColumn dimensionViewColumn = null;
        if (this.isFlat()) {
            dimensionViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
            if (dimensionViewColumn != null) {
                return dimensionViewColumn.getName();
            }
        } else {
            String string;
            DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
            if (dimensionHierarchy != null && (string = dimensionHierarchy.getShortDescriptionColumnName()) != null) {
                return string;
            }
        }
        return dimensionViewColumn != null ? dimensionViewColumn.getName() : null;
    }

    public String getShortDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.findAttributeRole("SHORT_DESCRIPTION");
        DimensionViewColumn dimensionViewColumn = null;
        if (this.isFlat()) {
            dimensionViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
            if (dimensionViewColumn != null) {
                return dimensionViewColumn.getName();
            }
        } else {
            String string;
            DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
            if (dimensionHierarchy != null && (string = dimensionHierarchy.getShortDescriptionColumnName()) != null) {
                return string;
            }
        }
        return dimensionViewColumn != null ? dimensionViewColumn.getName() : null;
    }

    public String getLongDescriptionColumnName() {
        DimensionAttribute dimensionAttribute = this.findAttributeRole("LONG_DESCRIPTION");
        DimensionViewColumn dimensionViewColumn = null;
        if (this.isFlat()) {
            dimensionViewColumn = dimensionAttribute == null ? this.getView().findColumnType("KEY") : this.getView().findColumn("ATTRIBUTE", dimensionAttribute.getName());
            if (dimensionViewColumn != null) {
                return dimensionViewColumn.getName();
            }
        } else {
            String string;
            DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
            if (dimensionHierarchy != null && (string = dimensionHierarchy.getLongDescriptionColumnName()) != null) {
                return string;
            }
        }
        return dimensionViewColumn != null ? dimensionViewColumn.getName() : null;
    }

    public boolean isFlat() {
        return this.getHierarchies().size() == 0;
    }

    public boolean isValue() {
        if (this.getDefaultHierarchy() == null) {
            return false;
        }
        return !this.getDefaultHierarchy().isLevelBased();
    }

    public boolean isLevelBased() {
        if (this.getDefaultHierarchy() == null) {
            return false;
        }
        return this.getDefaultHierarchy().isLevelBased();
    }

    public String getDefaultView() {
        DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
        if (dimensionHierarchy != null) {
            return dimensionHierarchy.getViewName();
        }
        return this.getView().getName();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(" Hierarchies [");
        for (DimensionHierarchy namedObjectWithDesc : this.hiers) {
            stringBuffer.append(namedObjectWithDesc.toString() + ",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("]");
        stringBuffer.append(" Attributes [");
        for (DimensionAttribute dimensionAttribute : this.attrs) {
            stringBuffer.append(dimensionAttribute.toString() + ",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Dimension clone() {
        DimensionHierarchy dimensionHierarchy = this.getDefaultHierarchy();
        String string = null;
        if (dimensionHierarchy != null) {
            string = dimensionHierarchy.getName();
        }
        Dimension dimension = new Dimension(this.getSchema(), this.getAWName(), this.getName(), this.getDescription(), this.isTime() ? TIME : "BASE", string);
        for (DimensionLevel namedObject : this.getLevels()) {
            dimension.addDimensionLevel(namedObject.getName(), namedObject.getDescription());
        }
        for (DimensionHierarchy dimensionHierarchy2 : this.getHierarchies()) {
            String string2 = dimensionHierarchy2.isLevelBased() ? "LEVEL" : "VALUE";
            DimensionHierarchy dimensionHierarchy3 = dimension.addDimensionHierarchy(dimensionHierarchy2.getName(), dimensionHierarchy2.getDescription(), string2);
            if (dimensionHierarchy2.getView() != null) {
                dimensionHierarchy3.setETViewName(dimensionHierarchy2.getViewName());
                DimensionHierarchyView dimensionHierarchyView = dimensionHierarchy3.getView();
                for (DimensionHierarchyViewColumn dimensionHierarchyViewColumn : dimensionHierarchy2.getView().getColumns()) {
                    dimensionHierarchyView.addColumn(dimensionHierarchyViewColumn.getName(), dimensionHierarchyViewColumn.getColumnType(), dimensionHierarchyViewColumn.getObjectName());
                }
            }
            for (DimensionHierarchyLevel dimensionHierarchyLevel : dimensionHierarchy2.getHierarchyLevels()) {
                dimensionHierarchy3.addHierarchyLevel(dimensionHierarchyLevel.getDimensionLevel(), dimensionHierarchyLevel.getDescription());
            }
        }
        for (DimensionAttribute dimensionAttribute : this.getAttributes()) {
            dimension.addDimensionAttribute(dimensionAttribute.getName(), dimensionAttribute.getRole(), dimensionAttribute.getDescription());
        }
        DimensionView dimensionView = this.getView();
        if (dimensionView != null) {
            DimensionView dimensionView2 = new DimensionView(dimension, dimensionView.getName());
            for (DimensionViewColumn dimensionViewColumn : dimensionView.getColumns()) {
                dimensionView2.addColumn(dimensionViewColumn.getName(), dimensionViewColumn.getColumnType(), dimensionViewColumn.getObjectName());
            }
            dimension.setView(dimensionView2);
        }
        return dimension;
    }

    public boolean isEmpty() throws SQLException, IOException {
        boolean bl = false;
        int n = 0;
        n = this.getMemberCount();
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public int getMemberCount() throws SQLException, IOException {
        int n = 0;
        String string = this.getViewName();
        String string2 = "select count(*) from " + string;
        List<List<String>> list = this.database.executeSQL(string2);
        for (List<String> list2 : list) {
            n = Integer.valueOf(list2.get(0));
        }
        return n;
    }
}

