/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapmetadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.syntaxparser.SyntaxParser;
import oracle.olap.db.IdentifierElement;

public class CalcReferences {
    public static final String MEASURE_TYPE = "MEASURE";

    public static List<Measure> getDependencies(AnalyticWorkspace analyticWorkspace, String string, String string2, SyntaxParser syntaxParser) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        Cube cube = analyticWorkspace.getCube(string);
        if (cube != null) {
            Measure measure = cube.findMeasure(string2);
            Stack<Measure> stack = new Stack<Measure>();
            stack.push(measure);
            while (!stack.isEmpty()) {
                Measure measure2 = (Measure)stack.pop();
                if (measure2 == null) continue;
                for (Cube cube2 : analyticWorkspace.getCubes()) {
                    for (Measure measure3 : cube2.getMeasures()) {
                        if (!measure3.getType().equals("DERIVED")) continue;
                        ParseNode parseNode = new ParseNode();
                        if (!syntaxParser.parseSyntax(measure3.getExpression(), parseNode)) continue;
                        Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                            if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(MEASURE_TYPE)) continue;
                            String string3 = String.valueOf(parseNode2.getUserObject());
                            IdentifierElement identifierElement = new IdentifierElement(string3);
                            int n = identifierElement.getCount();
                            String string4 = null;
                            String string5 = null;
                            if (n == 2) {
                                string4 = identifierElement.get(1);
                                string5 = identifierElement.get(0);
                            } else if (n == 3) {
                                string4 = identifierElement.get(2);
                                string5 = identifierElement.get(1);
                            }
                            if (!measure2.getName().equals(string4) || !measure2.getCube().getName().equals(string5)) continue;
                            if (!arrayList.contains(measure3)) {
                                arrayList.add(measure3);
                            }
                            stack.push(measure3);
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public static List<Measure> getReferences(Measure measure, SyntaxParser syntaxParser, AnalyticWorkspace analyticWorkspace) {
        if (measure == null) {
            return Collections.emptyList();
        }
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        Cube cube = measure.getCube();
        Stack<Measure> stack = new Stack<Measure>();
        stack.push(measure);
        while (!stack.isEmpty()) {
            Measure measure2 = (Measure)stack.pop();
            ParseNode parseNode = new ParseNode();
            if (!syntaxParser.parseSyntax(measure2.getExpression(), parseNode)) continue;
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(MEASURE_TYPE)) continue;
                String string = String.valueOf(parseNode2.getUserObject());
                IdentifierElement identifierElement = new IdentifierElement(string);
                String string2 = null;
                String string3 = null;
                Measure measure3 = null;
                if (identifierElement.getCount() == 3) {
                    string2 = identifierElement.getSecond();
                    string3 = identifierElement.getThird();
                    if (cube.getName().equals(string2)) {
                        measure3 = cube.findMeasure(string3);
                    } else {
                        Cube cube2 = null;
                        for (Cube cube3 : analyticWorkspace.getCubes()) {
                            if (!cube3.getName().equals(string2)) continue;
                            cube2 = cube3;
                            break;
                        }
                        if (cube2 != null) {
                            measure3 = cube2.findMeasure(string3);
                        }
                    }
                }
                if (measure3 == null) continue;
                arrayList.add(measure3);
                if (!measure3.isDerived()) continue;
                stack.push(measure3);
            }
        }
        return arrayList;
    }
}

