/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.olap.app.cubeddl.model.AWSpecification;
import oracle.olap.app.cubeddl.model.CubeColumn;
import oracle.olap.app.cubeddl.model.CubeDimensionCreate;
import oracle.olap.app.cubeddl.model.Hierarchy;
import oracle.olap.app.cubeddl.model.MapDefinition;
import oracle.olap.app.cubeddl.model.SelectQuery;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;

public class CubeCreate
extends NamedObjectWithDesc
implements MapDefinition {
    private List<String> mapColumns;
    private SelectQuery selectQuery;
    private Set<CubeColumn> columns = new LinkedHashSet<CubeColumn>();
    private AWSpecification awSpec;
    private String awName;
    private String partition;
    private String solve;
    private String precomputePercent;
    private String precomputeTopPercent;

    public CubeCreate(String string) {
        super(string, null);
    }

    public CubeCreate() {
        this(null);
    }

    public CubeColumn addColumn(String string, String string2) {
        CubeColumn cubeColumn = new CubeColumn(string, string2);
        this.columns.add(cubeColumn);
        return cubeColumn;
    }

    public void addColumn(CubeColumn cubeColumn) {
        this.columns.add(cubeColumn);
    }

    public void setAWSpecification(AWSpecification aWSpecification) {
        this.awSpec = aWSpecification;
    }

    public AWSpecification getAWSpecification() {
        return this.awSpec;
    }

    public String getShadowTableName() {
        return this.getName() + "$";
    }

    public Set<CubeColumn> getDimensions() {
        HashSet<CubeColumn> hashSet = new HashSet<CubeColumn>();
        for (CubeColumn cubeColumn : this.columns) {
            if (!cubeColumn.isDimensionKey()) continue;
            hashSet.add(cubeColumn);
        }
        return hashSet;
    }

    public void addDimension(CubeDimensionCreate cubeDimensionCreate) {
        for (CubeColumn cubeColumn : this.getDimensions()) {
            if (!cubeColumn.getDimension().equalsIgnoreCase(cubeDimensionCreate.getName())) continue;
            cubeColumn.setDimensionObj(cubeDimensionCreate);
        }
    }

    public Hierarchy getHierarchy(CubeColumn cubeColumn) {
        Iterator<Hierarchy> iterator;
        CubeDimensionCreate cubeDimensionCreate = cubeColumn.getDimensionObj();
        if (cubeDimensionCreate != null && cubeDimensionCreate.getHierarchies().size() > 0 && (iterator = cubeDimensionCreate.getHierarchies().iterator()).hasNext()) {
            Hierarchy hierarchy = iterator.next();
            return hierarchy;
        }
        return null;
    }

    public Set<CubeColumn> getMeasures() {
        HashSet<CubeColumn> hashSet = new HashSet<CubeColumn>();
        for (CubeColumn cubeColumn : this.columns) {
            if (cubeColumn.isDimensionKey()) continue;
            hashSet.add(cubeColumn);
        }
        return hashSet;
    }

    public String dropShadowTable() {
        StringBuffer stringBuffer = new StringBuffer("DROP TABLE " + this.getShadowTableName());
        return stringBuffer.toString();
    }

    public String createShadowTable() {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getShadowTableName() + " (\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        for (CubeColumn cubeColumn : this.columns) {
            String string = "VARCHAR2(60)";
            if (cubeColumn.getDataType() != null) {
                string = cubeColumn.getDataType();
            }
            stringBuffer.append("  " + cubeColumn.getName() + " " + string + ",\n");
            if (cubeColumn.getDimension() == null || cubeColumn.getDimension().length() <= 0) continue;
            stringBuffer2.append(cubeColumn.getName() + ",");
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.delete(stringBuffer2.length() - 1, stringBuffer2.length());
            stringBuffer.append(",\n PRIMARY KEY ( " + stringBuffer2 + ")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String drop() {
        return "DROP CUBE " + this.getName().toLowerCase();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CREATE CUBE " + this.getName().toLowerCase() + " (\n");
        for (CubeColumn cubeColumn : this.columns) {
            stringBuffer.append("  " + cubeColumn.toString() + ",\n");
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    public void setPartition(String string) {
        this.partition = string;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setSolve(String string) {
        this.solve = string;
    }

    public String getSolve() {
        return this.solve;
    }

    public boolean isMapped() {
        return this.selectQuery != null;
    }

    public String getQuery() {
        if (this.isMapped()) {
            return this.selectQuery.getFrom();
        }
        return null;
    }

    public String getMeasureMap(CubeColumn cubeColumn) {
        if (this.isMapped()) {
            int n = 0;
            boolean bl = false;
            for (String string : this.mapColumns) {
                if (cubeColumn.getName().equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return null;
            }
            Object object = this.selectQuery.getColumns().get(n);
            if (((String)object).indexOf(".") == -1) {
                object = this.getQuery() + "." + (String)object;
            }
            return object;
        }
        return null;
    }

    public String getCubeDimMap(CubeColumn cubeColumn) {
        if (this.isMapped()) {
            int n = 0;
            boolean bl = false;
            for (String string : this.mapColumns) {
                if (cubeColumn.getName().equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return null;
            }
            Object object = this.selectQuery.getColumns().get(n);
            if (((String)object).indexOf(".") == -1) {
                object = this.getQuery() + "." + (String)object;
            }
            return object;
        }
        return null;
    }

    @Override
    public SelectQuery getSelectQuery() {
        return this.selectQuery;
    }

    @Override
    public void setSelectQuery(SelectQuery selectQuery) {
        this.selectQuery = selectQuery;
    }

    @Override
    public List<String> getMapColumns() {
        return this.mapColumns;
    }

    @Override
    public void setMapColumns(List<String> list) {
        this.mapColumns = list;
    }

    public void setPrecomputePercent(String string) {
        this.precomputePercent = string;
    }

    public String getPrecomputePercent() {
        return this.precomputePercent;
    }

    public void setPrecomputeTopPercent(String string) {
        this.precomputeTopPercent = string;
    }

    public String getPrecomputeTopPercent() {
        return this.precomputeTopPercent;
    }

    public void setAWName(String string) {
        this.awName = string;
    }

    public String getAWName() {
        return this.awName;
    }
}

