/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.actions.ActionHandler;
import oracle.olap.app.actions.data.Actions;
import oracle.olap.app.actions.data.Menu;
import oracle.olap.app.actions.data.MenuItem;
import oracle.olap.app.actions.data.MenuSeparator;
import oracle.olap.app.context.Context;
import oracle.olap.app.context.ContextCallback;

public class PopupMenuHandler
implements ActionListener {
    private Actions actions;
    private Map<String, ActionHandler> classMap;
    private ContextCallback contextCallback;

    public PopupMenuHandler(Class clazz, String string, ContextCallback contextCallback) throws Exception {
        this.contextCallback = contextCallback;
        String string2 = JavaXMLBind.LoadDocument(clazz, string);
        Class<Actions> clazz2 = Actions.class;
        String string3 = "oracle.olap.app.actions.data";
        JavaXMLBind.BindToJavaStr(string2, string3, this);
        this.classMap = new HashMap<String, ActionHandler>();
    }

    public PopupMenuHandler(Actions actions) {
        this.actions = actions;
        this.classMap = new HashMap<String, ActionHandler>();
    }

    public void addActions(Actions actions) {
        this.actions = actions;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Menu menu = this.actions.getMenu();
        for (Object e : menu.getMenus()) {
            JMenuItem jMenuItem;
            Object object;
            if (e instanceof MenuItem) {
                object = (MenuItem)e;
                if (((MenuItem)object).getText() != null || ((MenuItem)object).getText().length() > 0) {
                    jMenuItem = this.addMenuItem((MenuItem)object);
                    jPopupMenu.add(jMenuItem);
                } else {
                    jPopupMenu.addSeparator();
                }
            }
            if (e instanceof MenuSeparator) {
                jPopupMenu.addSeparator();
            }
            if (!(e instanceof Menu)) continue;
            object = (Menu)e;
            jMenuItem = this.getMenu((Menu)object);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    private JMenu getMenu(Menu menu) {
        JMenu jMenu = new JMenu(menu.getText());
        for (Object e : menu.getMenus()) {
            JMenuItem jMenuItem;
            Object object;
            if (e instanceof MenuItem) {
                object = (MenuItem)e;
                if (((MenuItem)object).getText() != null || ((MenuItem)object).getText().length() > 0) {
                    jMenuItem = this.addMenuItem((MenuItem)object);
                    jMenu.add(jMenuItem);
                } else {
                    jMenu.addSeparator();
                }
            }
            if (e instanceof MenuSeparator) {
                jMenu.addSeparator();
            }
            if (!(e instanceof Menu)) continue;
            object = (Menu)e;
            jMenuItem = this.getMenu((Menu)object);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private JMenuItem addMenuItem(MenuItem menuItem) {
        JMenuItem jMenuItem = new JMenuItem(menuItem.getText());
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(menuItem.getAction());
        return jMenuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Context context = new Context();
        context.setAction(actionEvent.getActionCommand());
        this.contextCallback.setupContext(context);
        String string = actionEvent.getActionCommand();
        String string2 = this.actions.getActionClass(string);
        ActionHandler actionHandler = this.classMap.get(string2);
        if (actionHandler == null && string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                if (obj instanceof ActionHandler) {
                    actionHandler = (ActionHandler)obj;
                    this.classMap.put(string2, actionHandler);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (actionHandler != null) {
            actionHandler.handle(actionEvent.getSource(), context);
        }
    }
}

