/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.aw.NewAWDialog;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;

public class NewAWAction
extends AbstractOLAPDDLAction {
    private String tablespace;
    private String awName;

    public void setArgs(String string) {
    }

    @Override
    public void launch() {
        DBObject dBObject = this.getDBObject();
        Database database = dBObject.getDatabase();
        String string = dBObject.getSchemaName();
        NewAWDialog newAWDialog = new NewAWDialog((Frame)Ide.getMainWindow(), (DBObjectProvider)database, string);
        newAWDialog.setMinimumSize(new Dimension(400, 130));
        newAWDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        newAWDialog.setVisible(true);
        if (newAWDialog.isOKSelected()) {
            this.awName = newAWDialog.getAWName();
            this.tablespace = newAWDialog.getTableSpaceName();
            super.launch();
        }
    }

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string)) {
            string = String.format("\"%s\"", string);
        }
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string2)) {
            string2 = String.format("\"%s\"", string2);
        }
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(this.awName)) {
            this.awName = String.format("\"%s\"", this.awName);
        }
        Object object = "";
        if (this.tablespace != null) {
            if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(this.tablespace)) {
                this.tablespace = String.format("\"%s\"", this.tablespace);
            }
            object = " TABLESPACE " + this.tablespace;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = String.format("CREATE ANALYTIC WORKSPACE %s.%s%s", string, this.awName, object);
        arrayList.add(string3);
        return arrayList;
    }

    @Override
    protected String getConfirmMessage(String string) {
        return null;
    }

    @Override
    protected String getProgressMessage(String string) {
        String string2 = OLAPArb.format("NEWAW_PROGRESSBAR_TITLE", this.awName);
        return string2;
    }

    @Override
    protected String getSuccessMessage(String string) {
        String string2 = null;
        return string2;
    }

    @Override
    protected String getErrorTitle(String string) {
        String string2 = OLAPArb.format("NEWAW_ERROR_TITLE", string);
        return string2;
    }

    @Override
    protected boolean isRemoveNodeRequired() {
        return false;
    }
}

