/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractLangDescXMLGenerator;
import oracle.olap.actions.AbstractUpdatedObjectGenerator;
import oracle.olap.actions.CubeLangDescXMLGenerator;
import oracle.olap.actions.CubeUpdatedObjectGenerator;
import oracle.olap.actions.DimensionLangDescXMLGenerator;
import oracle.olap.actions.DimensionUpdatedObjectGenerator;
import oracle.olap.actions.MeasureFolderLangDescXMLGenerator;
import oracle.olap.actions.MeasureFolderUpdatedObjectGenerator;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.MeasureFolder;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.tree.loader.TreeLoaderXML;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.view.JTreeTable;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.LanguageDescriptionsTreeLoaderXML;
import oracle.olap.db.view.LanguagesSelectorDialog;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LanguageDescriptionsTreeTablePanel
extends JPanel
implements ActionListener {
    private final DBObject dbObject;
    private String awName;
    private Schema schema;
    private TreeLoaderXML treeLoaderXML;
    private JTreeTable namingTreeTable;
    private JButton addLanguagesBtn;
    private DefaultListModel descriptionTranslations;
    private String defaultLanguage;
    private String[] initialLanguages;
    private static final String DESC_XML_FILE = "/oracle/olap/actions/langdesceditor.xml";
    private static final String DIMENSIONS_XPATH = "/AnalyticWorkspace/CubeDimensions/*";
    private static final String CUBES_XPATH = "/AnalyticWorkspace/Cubes/*";
    private static final String MEASURE_FOLDERS_XPATH = "/AnalyticWorkspace/MeasureFolders/*";
    private Map<String, AbstractSchemaObjectWithDesc> originalObjects;
    private Map<String, AbstractSchemaObjectWithDesc> updatedObjects;
    private MetadataXML metadataXML;

    public LanguageDescriptionsTreeTablePanel(DBObject dBObject) throws Exception {
        super(new GridBagLayout());
        this.initAbstractSchemaObjectsMap();
        this.descriptionTranslations = new DefaultListModel();
        this.dbObject = dBObject;
        this.namingTreeTable = new JTreeTable();
        this.namingTreeTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Object object2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String && (string = (String)object2).toLowerCase().endsWith("/name")) {
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(1));
                }
                return component;
            }
        });
        this.initComponents();
        JScrollPane jScrollPane = new JScrollPane(this.namingTreeTable);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addLanguagesBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initAbstractSchemaObjectsMap() {
        this.originalObjects = new HashMap<String, AbstractSchemaObjectWithDesc>();
        this.updatedObjects = new HashMap<String, AbstractSchemaObjectWithDesc>();
    }

    private void initComponents() throws Exception {
        this.awName = this.dbObject.getObjectName();
        this.schema = OLAPMetadataCache.getUpdatedSchema(this.dbObject.getConnectionName(), this.dbObject.getSchemaName());
        this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        this.clearLanguageDescriptionsInCache(this.schema);
        if (!this.descriptionTranslations.contains(this.defaultLanguage)) {
            this.descriptionTranslations.addElement(this.defaultLanguage);
        }
        if (this.schema.getMeasureFolders().size() == 0) {
            OLAPObjectHelper.loadMeasureFoldersToCache(this.dbObject, this.schema, this.awName);
        }
        OLAPObjectHelper.initLanguageDescriptionsCache(this.dbObject, this.defaultLanguage, this.schema, this.awName, this.descriptionTranslations);
        this.addLanguagesBtn = new JButton(OLAPArb.getString("DESCRIPTION_PANEL_MODIFY_LANGUAGES_BTN"));
        this.addLanguagesBtn.addActionListener(this);
        this.initTreeLoader();
        this.populateNameTreeTable();
    }

    private void clearLanguageDescriptionsInCache(Schema schema) {
        for (Dimension namedObjectWithDesc : schema.getDimensions()) {
            if (!namedObjectWithDesc.getAWName().equalsIgnoreCase(this.awName)) continue;
            this.clearLanguageDescriptions(namedObjectWithDesc);
            for (DimensionLevel dimensionLevel : namedObjectWithDesc.getLevels()) {
                this.clearLanguageDescriptions(dimensionLevel);
            }
            for (DimensionHierarchy dimensionHierarchy : namedObjectWithDesc.getHierarchies()) {
                this.clearLanguageDescriptions(dimensionHierarchy);
            }
            for (DimensionAttribute dimensionAttribute : namedObjectWithDesc.getAttributes()) {
                this.clearLanguageDescriptions(dimensionAttribute);
            }
        }
        for (Cube cube : schema.getCubes()) {
            if (!cube.getAWName().equalsIgnoreCase(this.awName)) continue;
            this.clearLanguageDescriptions(cube);
            for (Measure measure : cube.getMeasures()) {
                this.clearLanguageDescriptions(measure);
            }
        }
        for (MeasureFolder measureFolder : schema.getMeasureFolders()) {
            this.clearLanguageDescriptions(measureFolder);
        }
    }

    private void clearLanguageDescriptions(NamedObjectWithDesc namedObjectWithDesc) {
        namedObjectWithDesc.removeAllLanguageDescriptions();
    }

    private void initTreeLoader() throws Exception {
        String string = this.getAWDescriptionsXML();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.descriptionTranslations.getSize() > 1) {
            Enumeration enumeration = this.descriptionTranslations.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.equalsIgnoreCase(this.defaultLanguage)) continue;
                arrayList.add(string2);
            }
        }
        this.treeLoaderXML = new LanguageDescriptionsTreeLoaderXML(string, this.getClass(), DESC_XML_FILE, arrayList);
    }

    private String getAWDescriptionsXML() {
        Object object;
        this.clearAbstractSchemaObjectMaps();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<AnalyticWorkspace>");
        stringBuilder.append("<CubeDimensions>\n");
        for (Dimension object3 : this.schema.getDimensions()) {
            if (!object3.getAWName().equalsIgnoreCase(this.awName)) continue;
            DimensionLangDescXMLGenerator dimensionLangDescXMLGenerator = new DimensionLangDescXMLGenerator(object3);
            if (!this.originalObjects.containsKey(object3.getName())) {
                object = (CubeDimension)((AbstractLangDescXMLGenerator)dimensionLangDescXMLGenerator).createModelOriginalObject();
                this.originalObjects.put(object3.getName(), (AbstractSchemaObjectWithDesc)object);
            }
            stringBuilder.append(((AbstractLangDescXMLGenerator)dimensionLangDescXMLGenerator).generateXML());
        }
        stringBuilder.append("</CubeDimensions>\n");
        stringBuilder.append("<Cubes>\n");
        for (Cube cube : this.schema.getCubes()) {
            if (!cube.getAWName().equalsIgnoreCase(this.awName)) continue;
            CubeLangDescXMLGenerator cubeLangDescXMLGenerator = new CubeLangDescXMLGenerator(cube);
            if (!this.originalObjects.containsKey(cube.getName())) {
                object = (oracle.olap.cube.model.Cube)((AbstractLangDescXMLGenerator)cubeLangDescXMLGenerator).createModelOriginalObject();
                this.originalObjects.put(cube.getName(), (AbstractSchemaObjectWithDesc)object);
            }
            stringBuilder.append(((AbstractLangDescXMLGenerator)cubeLangDescXMLGenerator).generateXML());
        }
        stringBuilder.append("</Cubes>\n");
        stringBuilder.append("<MeasureFolders>\n");
        int n = 0;
        for (MeasureFolder measureFolder : this.schema.getMeasureFolders()) {
            if (!measureFolder.getAWName().equalsIgnoreCase(this.awName)) continue;
            ++n;
            object = new MeasureFolderLangDescXMLGenerator(measureFolder);
            if (!this.originalObjects.containsKey(measureFolder.getName())) {
                oracle.olap.measurefolder.model.MeasureFolder measureFolder2 = (oracle.olap.measurefolder.model.MeasureFolder)((AbstractLangDescXMLGenerator)object).createModelOriginalObject();
                this.originalObjects.put(measureFolder.getName(), measureFolder2);
            }
            stringBuilder.append(((AbstractLangDescXMLGenerator)object).generateXML());
        }
        if (n > 0) {
            stringBuilder.append("</MeasureFolders>\n");
        } else {
            int n2 = stringBuilder.indexOf("<MeasureFolders>\n");
            stringBuilder.delete(n2, n2 + "<MeasureFolders>\n".length());
        }
        stringBuilder.append("</AnalyticWorkspace>");
        return stringBuilder.toString();
    }

    private void clearAbstractSchemaObjectMaps() {
        this.updatedObjects.clear();
    }

    private void populateNameTreeTable() {
        TreeTable treeTable = (TreeTable)this.treeLoaderXML.getTree();
        this.namingTreeTable.setModel(treeTable);
        this.namingTreeTable.expandAll(true);
        this.namingTreeTable.getColumnModel().getColumn(0).setHeaderValue(OLAPArb.getString("DESCRIPTION_PANEL_NAME_TITLE"));
        this.namingTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.namingTreeTable.getColumnModel().getColumn(1).setHeaderValue(this.defaultLanguage);
        this.namingTreeTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        if (this.namingTreeTable.getColumnCount() > 2) {
            for (int i = 2; i < this.namingTreeTable.getColumnCount(); ++i) {
                this.namingTreeTable.getColumnModel().getColumn(i).setPreferredWidth(150);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.initialLanguages = new String[this.descriptionTranslations.size()];
        this.descriptionTranslations.copyInto(this.initialLanguages);
        LanguagesSelectorDialog languagesSelectorDialog = new LanguagesSelectorDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("LANGUAGES_SELECTOR_DIALOG_TITLE"), this.descriptionTranslations, this.defaultLanguage);
        languagesSelectorDialog.setVisible(true);
        if (languagesSelectorDialog.isOkClicked() && !this.descriptionTranslations.isEmpty()) {
            try {
                this.initTreeLoader();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.populateNameTreeTable();
        }
    }

    public String generateSQL() {
        String string = this.treeLoaderXML.generateXML();
        String string2 = "";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            Document document = documentBuilder.parse(new InputSource(stringReader));
            this.generateUpdatedObjects(document, DIMENSIONS_XPATH, new DimensionUpdatedObjectGenerator(this.descriptionTranslations, this.initialLanguages));
            this.generateUpdatedObjects(document, CUBES_XPATH, new CubeUpdatedObjectGenerator(this.descriptionTranslations, this.initialLanguages));
            this.generateUpdatedObjects(document, MEASURE_FOLDERS_XPATH, new MeasureFolderUpdatedObjectGenerator(this.descriptionTranslations, this.initialLanguages));
            string2 = this.generateDDL();
            this.initTreeLoader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void generateUpdatedObjects(Document document, String string, AbstractUpdatedObjectGenerator abstractUpdatedObjectGenerator) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        abstractUpdatedObjectGenerator.generateUpdatedObject(nodeList, this.originalObjects, this.updatedObjects);
    }

    private String generateDDL() throws Exception {
        ArrayList<CubeDDLStatements> arrayList = new ArrayList<CubeDDLStatements>();
        arrayList.addAll(this.generateCubeDDLStatements());
        return this.generateSQLXml(arrayList);
    }

    private List<CubeDDLStatements> generateCubeDDLStatements() {
        Database database = this.dbObject.getDatabase();
        DDLGenerator dDLGenerator = database.getDDLGenerator();
        ArrayList<CubeDDLStatements> arrayList = new ArrayList<CubeDDLStatements>();
        for (String string : this.originalObjects.keySet()) {
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.originalObjects.get(string);
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.updatedObjects.get(string);
            Difference difference = database.getDiffEngine().difference((Object)abstractSchemaObjectWithDesc, (Object)abstractSchemaObjectWithDesc2);
            DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), difference);
            Collection collection = dDL.getStatements();
            CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
            arrayList.add(cubeDDLStatements);
        }
        return arrayList;
    }

    private String generateSQLXml(List<CubeDDLStatements> list) throws Exception {
        String string = null;
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(this.dbObject.getConnection());
        Schema schema = OLAPMetadataCache.getUpdatedSchema(this.dbObject.getConnectionName(), this.dbObject.getSchemaName());
        MetadataContext metadataContext = new MetadataContext(this.dbObject.getDatabase(), list);
        metadataContext.setSchema(schema);
        metadataContext.setDatabase(databaseImpl);
        this.metadataXML = new MetadataXML(metadataContext);
        this.metadataXML.parse();
        string = this.metadataXML.getSQLXML();
        return string;
    }

    public MetadataXML getMetadataXML() {
        return this.metadataXML;
    }
}

