/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.sql.Connection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;

public abstract class JobAction
extends AbstractMenuAction {
    public void launch() {
        int n;
        DBObject dBObject = this.getDBObject();
        Connection connection = dBObject.getConnection();
        String string = dBObject.getObjectName();
        String string2 = this.getConfirmMessage(string);
        String string3 = this.getConfirmTitle(string);
        boolean bl = true;
        if (string2 != null && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), string2, string3, 0)) != 0) {
            bl = false;
        }
        if (bl) {
            String string4 = this.getProgressBarDialogWaitMsg(string);
            final Connection connection2 = connection;
            final String string5 = string;
            RaptorTask raptorTask = new RaptorTask(string4, true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        JobAction.this.callDBMSScheduler(connection2, string5);
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(string4);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
                            JobAction.this.warn(throwable);
                            JobAction.this.showErrorDialog(string);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JobAction.this.showSuccessfulCompletionDialog(string5);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
    }

    protected abstract String getProgressBarDialogTitle(String var1);

    protected abstract String getProgressBarDialogWaitMsg(String var1);

    protected abstract void showErrorDialog(String var1);

    protected abstract void showSuccessfulCompletionDialog(String var1);

    protected abstract String getConfirmMessage(String var1);

    protected abstract String getConfirmTitle(String var1);

    abstract void callDBMSScheduler(Connection var1, String var2) throws Exception;
}

