/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Frame;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AnalyticWorkspaceLanguagesPanel;
import oracle.olap.actions.DropOLAPChildObjectAdapter;
import oracle.olap.actions.DropOLAPChildObjectDialog;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.Cube;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.LanguageDescription;

public class DropLanguageDescriptionsAction
extends AbstractMenuAction {
    private DropOLAPChildObjectDialog dialog;

    public void launch() {
        List<String> list = Collections.EMPTY_LIST;
        try {
            list = LanguageDBSettings.getDescriptionLanguages(this.getDBObject().getObjectName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AnalyticWorkspaceLanguagesPanel analyticWorkspaceLanguagesPanel = new AnalyticWorkspaceLanguagesPanel(list);
        this.dialog = new DropOLAPChildObjectDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("REMOVE_AW_LANGUAGES_TITLE"), analyticWorkspaceLanguagesPanel, new DropLanguagesFromAWHandler(analyticWorkspaceLanguagesPanel), "olap_remove_language");
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
    }

    private class DropLanguagesFromAWHandler
    extends DropOLAPChildObjectAdapter {
        private AnalyticWorkspaceLanguagesPanel currentLanguages;
        private String sql;
        private Map<String, AbstractSchemaObjectWithDesc> originalObjects;
        private Map<String, AbstractSchemaObjectWithDesc> updatedObjects;
        private MetadataXML metadataXML;

        public DropLanguagesFromAWHandler(AnalyticWorkspaceLanguagesPanel analyticWorkspaceLanguagesPanel) {
            this.currentLanguages = analyticWorkspaceLanguagesPanel;
            this.originalObjects = new HashMap<String, AbstractSchemaObjectWithDesc>();
            this.updatedObjects = new HashMap<String, AbstractSchemaObjectWithDesc>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSQL() {
            block11: {
                String string4;
                if (this.isNoLanguageSelected()) {
                    return "";
                }
                if (!this.currentLanguages.hasSelectionChanged()) {
                    return this.sql;
                }
                List<String> list = this.currentLanguages.getLanguagesToDrop();
                this.currentLanguages.setSelectionChanged(false);
                this.revertObjectChanges();
                String string2 = DropLanguageDescriptionsAction.this.getDBObject().getConnectionName();
                String string3 = DropLanguageDescriptionsAction.this.getDBObject().getSchemaName();
                StringBuilder stringBuilder = new StringBuilder();
                for (String string4 : list) {
                    stringBuilder.append(String.format("'%s',", string4));
                }
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
                Connection connection = DropLanguageDescriptionsAction.this.getDBObject().getConnection();
                string4 = oracle.dbtools.db.DBUtil.getInstance((Connection)connection);
                String string5 = String.format("select distinct OBJECT_NAME, OBJECT_TYPE, LANGUAGE from all_cube_descriptions where OBJECT_TYPE in ('CUBE', 'DIMENSION') and LANGUAGE in (%s) order by OBJECT_TYPE", stringBuilder.toString());
                ResultSet resultSet = null;
                try {
                    Schema schema = OLAPMetadataCache.getUpdatedSchema(string2, string3);
                    Connections.getInstance().lock(connection);
                    resultSet = string4.executeOracleQuery(string5, null);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            NamedObjectWithDesc namedObjectWithDesc;
                            if (resultSet.getString("OBJECT_TYPE").equalsIgnoreCase("CUBE")) {
                                namedObjectWithDesc = schema.findCube(resultSet.getString("OBJECT_NAME"));
                                if (namedObjectWithDesc == null) continue;
                                this.removeLanguageDescriptionsFromCubeSQL(namedObjectWithDesc.getName(), resultSet.getString("LANGUAGE"));
                                continue;
                            }
                            if (!resultSet.getString("OBJECT_TYPE").equalsIgnoreCase("DIMENSION") || (namedObjectWithDesc = schema.findDimension(resultSet.getString("OBJECT_NAME"))) == null) continue;
                            this.removeLanguageDescriptionsFromDimSQL(namedObjectWithDesc.getName(), resultSet.getString("LANGUAGE"));
                        }
                    }
                    this.sql = this.generateSQLStatements();
                    oracle.dbtools.db.DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).severe(exception.getMessage());
                    break block11;
                }
                finally {
                    oracle.dbtools.db.DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
            return this.sql;
        }

        private void revertObjectChanges() {
            Set<String> set = this.originalObjects.keySet();
            this.updatedObjects.clear();
            for (String string : set) {
                AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.originalObjects.get(string);
                AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = (AbstractSchemaObjectWithDesc)DBUtil.makeTemporaryCopy((DBObject)abstractSchemaObjectWithDesc);
                this.updatedObjects.put(string, abstractSchemaObjectWithDesc2);
            }
        }

        private boolean isNoLanguageSelected() {
            List<String> list = this.currentLanguages.getLanguagesToDrop();
            return list.isEmpty();
        }

        @Override
        public boolean commitChanges() {
            if (this.isNoLanguageSelected()) {
                JOptionPane.showMessageDialog(this.currentLanguages, OLAPArb.getString("REMOVE_AW_LANGUAGES_TABLE_HEADER_LABEL"), OLAPArb.getString("REMOVE_AW_LANGUAGES_TITLE"), 0);
                return false;
            }
            try {
                if (this.currentLanguages.hasSelectionChanged()) {
                    this.sql = this.getSQL();
                }
                this.metadataXML.executeSQL(true);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).severe(exception.getMessage());
            }
            return true;
        }

        private void removeLanguageDescriptionsFromCubeSQL(String string, String string2) {
            Cube cube = null;
            if (this.updatedObjects.containsKey(string)) {
                cube = (Cube)this.updatedObjects.get(string);
            } else {
                Cube cube2 = OLAPObjectHelper.loadCube(string, DropLanguageDescriptionsAction.this.getDBObject().getSchemaName(), (OracleDatabaseImpl)DropLanguageDescriptionsAction.this.getDBObject().getDatabase());
                cube = (Cube)DBUtil.makeTemporaryCopy((DBObject)cube2);
                this.originalObjects.put(string, cube2);
                this.updatedObjects.put(string, cube);
            }
            this.removeLanguageDescriptionsFromTopObject(cube, string2);
            this.removeLanguageDescriptionsFromChildObject(cube.getMeasures(), string2);
            this.removeLanguageDescriptionsFromChildObject(cube.getCalculatedMeasures(), string2);
        }

        private void removeLanguageDescriptionsFromDimSQL(String string, String string2) {
            CubeDimension cubeDimension = null;
            if (this.updatedObjects.containsKey(string)) {
                cubeDimension = (CubeDimension)this.updatedObjects.get(string);
            } else {
                CubeDimension cubeDimension2 = OLAPObjectHelper.loadDimension(DropLanguageDescriptionsAction.this.getDBObject(), string, false);
                cubeDimension = (CubeDimension)DBUtil.makeTemporaryCopy((DBObject)cubeDimension2);
                this.originalObjects.put(string, cubeDimension2);
                this.updatedObjects.put(string, cubeDimension);
            }
            this.removeLanguageDescriptionsFromTopObject(cubeDimension, string2);
            this.removeLanguageDescriptionsFromChildObject(cubeDimension.getLevels(), string2);
            this.removeLanguageDescriptionsFromChildObject(cubeDimension.getHierarchies(), string2);
            this.removeLanguageDescriptionsFromChildObject(cubeDimension.getAttributes(), string2);
        }

        private void removeLanguageDescriptionsFromTopObject(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc, String string) {
            LanguageDescription languageDescription = abstractSchemaObjectWithDesc.findLanguageDescription(string);
            if (languageDescription != null) {
                abstractSchemaObjectWithDesc.removeLanguageDescription(languageDescription);
            }
        }

        private void removeLanguageDescriptionsFromChildObject(AbstractChildObjectWithDesc[] abstractChildObjectWithDescArray, String string) {
            for (AbstractChildObjectWithDesc abstractChildObjectWithDesc : abstractChildObjectWithDescArray) {
                LanguageDescription languageDescription = abstractChildObjectWithDesc.findLanguageDescription(string);
                if (languageDescription == null) continue;
                abstractChildObjectWithDesc.removeLanguageDescription(languageDescription);
            }
        }

        private String generateSQLStatements() throws Exception {
            Object object;
            HashMap hashMap = new HashMap();
            Set<String> set = this.originalObjects.keySet();
            Database database = DropLanguageDescriptionsAction.this.getDBObject().getDatabase();
            DDLGenerator dDLGenerator = database.getDDLGenerator();
            for (String object2 : set) {
                List list;
                AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.originalObjects.get(object2);
                object = this.updatedObjects.get(object2);
                Difference difference = database.getDiffEngine().difference((Object)abstractSchemaObjectWithDesc, object);
                DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), difference);
                if (!hashMap.containsKey(object2)) {
                    list = new ArrayList();
                    list.addAll(dDL.getStatements());
                    hashMap.put(object2, list);
                    continue;
                }
                list = (List)hashMap.get(object2);
                list.addAll(dDL.getStatements());
            }
            set = hashMap.keySet();
            ArrayList arrayList = new ArrayList();
            for (String string : set) {
                object = new CubeDDLStatements((SystemObject)this.originalObjects.get(string), (SystemObject)this.updatedObjects.get(string), (Collection)hashMap.get(string));
                arrayList.add(object);
            }
            return this.generateSQLXml(arrayList);
        }

        private String generateSQLXml(List<CubeDDLStatements> list) throws Exception {
            String string = null;
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(DropLanguageDescriptionsAction.this.getDBObject().getConnection());
            Schema schema = OLAPMetadataCache.getUpdatedSchema(DropLanguageDescriptionsAction.this.getDBObject().getConnectionName(), DropLanguageDescriptionsAction.this.getDBObject().getSchemaName());
            MetadataContext metadataContext = new MetadataContext(DropLanguageDescriptionsAction.this.getDBObject().getDatabase(), list);
            metadataContext.setSchema(schema);
            metadataContext.setDatabase(databaseImpl);
            this.metadataXML = new MetadataXML(metadataContext);
            this.metadataXML.parse();
            string = this.metadataXML.getSQLXML();
            return string;
        }
    }
}

