/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import oracle.olap.actions.AbstractLangDescXMLGenerator;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAttribute;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;

public class DimensionLangDescXMLGenerator
extends AbstractLangDescXMLGenerator {
    private Dimension dimension;

    public DimensionLangDescXMLGenerator(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public String generateXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CubeDimension>\n");
        stringBuffer.append("     " + this.getDescXML("CubeDimensionObject", this.dimension));
        if (this.dimension.getLevels().size() > 0) {
            stringBuffer.append("  <Levels type=\"\">\n");
            for (DimensionLevel namedObjectWithDesc : this.dimension.getLevels()) {
                stringBuffer.append("     " + this.getDescXML("Level", namedObjectWithDesc));
            }
            stringBuffer.append("  </Levels>\n");
        }
        if (this.dimension.getHierarchies().size() > 0) {
            stringBuffer.append("  <Hierarchies type=\"\">\n");
            for (DimensionHierarchy dimensionHierarchy : this.dimension.getHierarchies()) {
                stringBuffer.append("     " + this.getDescXML("Hierarchy", dimensionHierarchy));
            }
            stringBuffer.append("  </Hierarchies>\n");
        }
        if (this.dimension.getAttributes().size() > 0) {
            stringBuffer.append("  <Attributes type=\"\">\n");
            for (DimensionAttribute dimensionAttribute : this.dimension.getAttributes()) {
                if (dimensionAttribute.getDescription() == null) continue;
                stringBuffer.append("     " + this.getDescXML("Attribute", dimensionAttribute));
            }
            stringBuffer.append("  </Attributes>\n");
        }
        stringBuffer.append("</CubeDimension>\n");
        return stringBuffer.toString();
    }

    @Override
    public AbstractSchemaObjectWithDesc createModelOriginalObject() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        CubeDimension cubeDimension = new CubeDimension();
        cubeDimension.setName(this.dimension.getName());
        if (this.dimension.isTime()) {
            cubeDimension.setDimensionType("TIME");
            cubeDimension.removeTimeAttributes();
        }
        this.addLanguageDescriptions(cubeDimension, this.dimension);
        for (DimensionLevel namedObjectWithDesc : this.dimension.getLevels()) {
            abstractChildObjectWithDesc = new CubeDimensionLevel(namedObjectWithDesc.getName());
            this.addLanguageDescriptions(abstractChildObjectWithDesc, namedObjectWithDesc);
            cubeDimension.addLevel((CubeDimensionLevel)abstractChildObjectWithDesc);
        }
        for (DimensionHierarchy dimensionHierarchy : this.dimension.getHierarchies()) {
            abstractChildObjectWithDesc = new CubeDimensionHierarchy(dimensionHierarchy.getName());
            this.addLanguageDescriptions(abstractChildObjectWithDesc, dimensionHierarchy);
            cubeDimension.addHierarchy((CubeDimensionHierarchy)abstractChildObjectWithDesc);
        }
        for (DimensionAttribute dimensionAttribute : this.dimension.getAttributes()) {
            abstractChildObjectWithDesc = new CubeDimensionAttribute(dimensionAttribute.getName());
            this.addLanguageDescriptions(abstractChildObjectWithDesc, dimensionAttribute);
            cubeDimension.addAttribute((CubeDimensionAttribute)abstractChildObjectWithDesc);
        }
        return cubeDimension;
    }
}

