/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.BuildAction;
import oracle.olap.build.BuildObject;

public class ClearAction
extends BuildAction {
    public ClearAction() {
        this.useWiz = false;
    }

    @Override
    public void launch() {
        DBObject dBObject = this.getDBObject();
        List<BuildObject> list = this.getBuildObjects(dBObject);
        BuildObject buildObject = list.get(0);
        if (!buildObject.isMVOn()) {
            super.launch();
        } else {
            String string = String.format("%s.%s", dBObject.getSchemaName(), dBObject.getObjectName());
            String string2 = OLAPArb.format("BUILD_CLEAR_ERROR_MSG_MV_ENABLED", string);
            this.showErrorDialog(string2);
        }
    }

    @Override
    protected String getBuildScript(String string) {
        String string2 = String.format("%s USING (CLEAR)", string);
        return string2;
    }

    @Override
    protected String getBuildProgressBarDialogTitle(String string) {
        String string2 = OLAPArb.format("BUILD_CLEAR_PROGRESSBAR_TITLE", string);
        return string2;
    }

    @Override
    protected String getBuildProgressBarDialogWaitMsg(String string) {
        String string2 = OLAPArb.get("BUILD_CLEAR_PROGRESSBAR_WAIT_MSG");
        return string2;
    }

    @Override
    protected void showErrorDialog(String string) {
        String string2 = OLAPArb.get("BUILD_CLEAR_ERROR_DLG_TITLE");
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }

    @Override
    protected void showSuccessfulCompletionDialog(String string) {
        String string2 = this.getBuildProgressBarDialogTitle(string);
        String string3 = null;
        String string4 = OLAPArb.format("BUILD_CLEAR_CONFIRMATION_MSG", string);
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string4, (String)string2, string3);
    }

    @Override
    protected String getConfirmMessage(String string) {
        String string2 = OLAPArb.format("BUILD_CLEAR_PROMPT_MSG", string);
        return string2;
    }

    @Override
    protected JComponent getConfirmPromptPanel(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(this.getConfirmMessage(string)), "North");
        return jPanel;
    }

    @Override
    protected String getConfirmTitle(String string) {
        String string2 = this.getBuildProgressBarDialogTitle(string);
        return string2;
    }
}

