/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropOLAPChildObjectAdapter;
import oracle.olap.actions.DropOLAPChildObjectDialog;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.table.Queries;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildWizMain;
import oracle.olap.db.DatabaseConnection;
import oracle.olap.dml.DMLObject;

public class BuildAction
extends AbstractMenuAction {
    private Queries queries;
    protected boolean useWiz = true;
    protected List<BuildObject> buildObjects = new ArrayList<BuildObject>();
    private Boolean isAWPreviouslyAttachedRWInSession = null;
    private String owner;
    private String awName;
    private String buildName;
    protected static final String BUILD_SQL_FORMAT = "BEGIN\n DBMS_CUBE.BUILD(\n '%s');\nEND;";

    public void launch() {
        DBObject dBObject = this.getDBObject();
        List<BuildObject> list = null;
        list = this.getBuildObjects(dBObject);
        String string = dBObject.getObjectName();
        JComponent jComponent = this.getConfirmPromptPanel(string);
        String string2 = this.getConfirmTitle(string);
        if (jComponent != null) {
            DropOLAPChildObjectDialog dropOLAPChildObjectDialog = new DropOLAPChildObjectDialog((Frame)Ide.getMainWindow(), string2, jComponent, this.getHelper(), "help");
            dropOLAPChildObjectDialog.setModal(true);
            dropOLAPChildObjectDialog.setVisible(true);
        } else if (this.useWiz) {
            BuildWizMain buildWizMain = this.getBuildWizard();
            buildWizMain.launchWizard(dBObject);
        }
    }

    protected OLAPBuildObjectHelper getHelper() {
        return new OLAPBuildObjectHelper();
    }

    protected String getXMLFile() {
        return "";
    }

    public void setArgs(String string) {
    }

    protected List<BuildObject> getBuildObjects(DBObject dBObject) {
        if (this.buildObjects.isEmpty()) {
            BuildObject buildObject = null;
            Connection connection = dBObject.getConnection();
            String string = dBObject.getConnectionName();
            String string2 = dBObject.getSchemaName();
            String string3 = dBObject.getObjectName();
            String string4 = dBObject.getObjectType();
            if (!string4.equalsIgnoreCase("OLAPAW")) {
                buildObject = new BuildObject(connection, string2, string3, string4);
                this.buildObjects.add(buildObject);
            } else {
                Object object;
                Schema schema = null;
                try {
                    schema = OLAPMetadataCache.getUpdatedSchema(string, string2);
                }
                catch (Exception exception) {
                    String string5 = exception.getLocalizedMessage();
                    this.showErrorDialog(string5);
                    return this.buildObjects;
                }
                List<Cube> list = schema.getCubes();
                for (Cube object22 : list) {
                    if (!object22.getAWName().equalsIgnoreCase(string3)) continue;
                    object = new BuildObject(connection, string2, object22.getName(), "CUBE");
                    ((BuildObject)object).setAWName(string3);
                    this.buildObjects.add((BuildObject)object);
                }
                List<Dimension> list2 = schema.getDimensions();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    object = (Dimension)iterator.next();
                    if (!((Dimension)object).getAWName().equalsIgnoreCase(string3)) continue;
                    BuildObject buildObject2 = new BuildObject(connection, string2, ((NamedObject)object).getName(), "CUBE DIMENSION");
                    buildObject2.setAWName(string3);
                    this.buildObjects.add(buildObject2);
                }
            }
        }
        return this.buildObjects;
    }

    protected void attachAnalyticWorkspace(Connection connection, String string, String string2) throws SQLException, IOException {
        String string3 = String.format("%s.%s", string, string2);
        try {
            if (!this.isAWPreviouslyAttachedRWInSession(connection, string3)) {
                DMLObject.runDML(connection, "ATTACH_AW", string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    protected void detachAnalyticWorkspace(Connection connection, String string, String string2) throws SQLException, IOException {
        String string3 = String.format("%s.%s", string, string2);
        try {
            if (!this.isAWPreviouslyAttachedRWInSession(connection, string3)) {
                DMLObject.runDML(connection, "DETACH_AW", string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private boolean isAWPreviouslyAttachedRWInSession(Connection connection, String string) throws SQLException, IOException {
        if (this.isAWPreviouslyAttachedRWInSession == null) {
            this.isAWPreviouslyAttachedRWInSession = Boolean.FALSE;
            String string2 = DMLObject.getAWAttachModeInSession(connection, string);
            if (string2 != null && string2.equalsIgnoreCase("RW")) {
                this.isAWPreviouslyAttachedRWInSession = Boolean.TRUE;
            }
        }
        return this.isAWPreviouslyAttachedRWInSession;
    }

    protected String getBuildScript(String string) {
        String string2 = string;
        return string2;
    }

    protected String getBuildProgressBarDialogTitle(String string) {
        String string2 = OLAPArb.format("BUILD_PROGRESSBAR_TITLE", string);
        return string2;
    }

    protected String getBuildProgressBarDialogWaitMsg(String string) {
        String string2 = OLAPArb.get("BUILD_PROGRESSBAR_WAIT_MSG");
        return string2;
    }

    protected void showErrorDialog(String string) {
        String string2 = OLAPArb.get("BUILD_ERROR_DLG_TITLE");
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }

    protected void showSuccessfulCompletionDialog(String string) {
        String string2 = this.getBuildProgressBarDialogTitle(string);
        String string3 = null;
        String string4 = OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_COMPLETED_MESSAGE");
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string4, (String)string2, string3);
    }

    protected String getConfirmMessage(String string) {
        return null;
    }

    protected JComponent getConfirmPromptPanel(String string) {
        return null;
    }

    protected String getConfirmTitle(String string) {
        return null;
    }

    protected BuildWizMain getBuildWizard() {
        BuildWizMain buildWizMain = BuildWizMain.getInstance();
        return buildWizMain;
    }

    protected String getQuery(String string) {
        if (this.queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), this.getXMLFile());
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    protected class OLAPBuildObjectHelper
    extends DropOLAPChildObjectAdapter {
        protected OLAPBuildObjectHelper() {
        }

        @Override
        public String getSQL() {
            List<Object> list = new ArrayList();
            list = BuildAction.this.getBuildObjects(BuildAction.this.getDBObject());
            BuildObject buildObject = (BuildObject)list.get(0);
            BuildAction.this.buildName = String.format("%s.%s", buildObject.getOwner(), buildObject.getName());
            String string = String.format(BuildAction.BUILD_SQL_FORMAT, BuildAction.this.getBuildScript(BuildAction.this.buildName));
            return string;
        }

        protected void createBuildLogTables(DBObject dBObject) throws Exception {
        }

        @Override
        public boolean commitChanges() {
            Connection connection = BuildAction.this.getDBObject().getConnection();
            try {
                final Connection connection2 = DatabaseConnection.getInstance().getClonedConnection(connection);
                String string = BuildAction.this.getBuildProgressBarDialogWaitMsg(null);
                final DBObject dBObject = BuildAction.this.getDBObject();
                RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

                    protected Object doWork() throws TaskException {
                        Boolean bl = Boolean.TRUE;
                        try {
                            OLAPBuildObjectHelper.this.createBuildLogTables(BuildAction.this.getDBObject());
                            List<Object> list = new ArrayList();
                            list = BuildAction.this.getBuildObjects(dBObject);
                            BuildObject buildObject = (BuildObject)list.get(0);
                            BuildAction.this.buildName = String.format("%s.%s", buildObject.getOwner(), buildObject.getName());
                            BuildAction.this.owner = buildObject.getOwner();
                            BuildAction.this.awName = buildObject.getAWName();
                            String string = BuildAction.this.getBuildScript(BuildAction.this.buildName);
                            BuildAction.this.attachAnalyticWorkspace(connection2, BuildAction.this.owner, BuildAction.this.awName);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(string);
                            DatabaseUtils.ExecuteStoredProc(connection2, "DBMS_CUBE.BUILD", arrayList);
                        }
                        catch (Exception exception) {
                            bl = Boolean.FALSE;
                            throw new TaskException((Throwable)exception);
                        }
                        finally {
                            try {
                                BuildAction.this.detachAnalyticWorkspace(connection2, BuildAction.this.owner, BuildAction.this.awName);
                            }
                            catch (Exception exception) {}
                        }
                        return bl;
                    }
                };
                raptorTask.setCancellable(false);
                raptorTask.setPausable(false);
                raptorTask.setMessage(string);
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                Throwable throwable = raptorTaskEvent.getThrowable();
                                String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
                                BuildAction.this.warn(throwable);
                                BuildAction.this.showErrorDialog(string);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                BuildAction.this.showSuccessfulCompletionDialog(BuildAction.this.buildName);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                });
                RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
                raptorTaskManager.addTask(raptorTask);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }
}

