/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ConfirmDialog;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;

public abstract class AbstractOLAPDDLAction
extends AbstractMenuAction {
    private AbstractSchemaObjectWithDesc schemaObjectWithDesc;
    private AbstractSchemaObjectWithDesc schemaUpdatedObjectWithDesc;
    public static final String DBOBJECT_PROPERTY = "ObjectAction.DBOBJECT";

    public void launch() {
        Object object;
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        String string3 = this.getConfirmMessage(string2);
        String string4 = this.getProgressMessage(string2);
        String string5 = this.getHelpID();
        String string6 = this.getConfirmTitle(string2);
        boolean bl = true;
        if (string3 != null) {
            object = new ConfirmDialog((Frame)Ide.getMainWindow(), string6, string5, string, string2, this);
            ((Window)object).setMinimumSize(new Dimension(450, 300));
            ((Window)object).setLocationRelativeTo((Component)Ide.getMainWindow());
            ((Dialog)object).setVisible(true);
            if (!((ConfirmDialog)object).isOKSelected()) {
                bl = false;
            }
        }
        if (bl) {
            try {
                object = string2;
                RaptorTask raptorTask = new RaptorTask(string4, true, IRaptorTaskRunMode.MODAL){

                    protected Object doWork() throws TaskException {
                        Boolean bl = Boolean.TRUE;
                        try {
                            AbstractOLAPDDLAction.this.executeOLAPDDLStatements();
                        }
                        catch (Exception exception) {
                            bl = Boolean.FALSE;
                            throw new TaskException((Throwable)exception);
                        }
                        return bl;
                    }
                };
                ObjectAction objectAction = this.getObjectAction();
                if (null == objectAction) {
                    objectAction = new ObjectAction();
                    objectAction.setReloadParent(true);
                }
                if (this.isRemoveNodeRequired()) {
                    objectAction.setRemoveFromParent(true);
                }
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
                raptorTask.getDescriptor().addListener(iRaptorTaskListener);
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((String)object){
                    final /* synthetic */ String val$objectName2;
                    {
                        this.val$objectName2 = string;
                    }

                    public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                Throwable throwable = raptorTaskEvent.getThrowable();
                                AbstractOLAPDDLAction.this.showErrorDialog(throwable);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                String string = AbstractOLAPDDLAction.this.getSuccessMessage(val$objectName2);
                                if (string != null) {
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                });
                raptorTask.setCancellable(false);
                raptorTask.setPausable(false);
                raptorTask.setMessage(string4);
                RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
                raptorTaskManager.addTask(raptorTask);
                this.setBlockOACRefresh(true);
            }
            catch (Exception exception) {
                this.showErrorDialog(exception);
            }
        } else {
            object = this.getObjectAction();
            if (object != null) {
                object.setRemoveFromParent(false);
            }
        }
    }

    protected void executeOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        Collection<String> collection = this.getOLAPDDL(dBObject);
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        if (collection != null && !collection.isEmpty()) {
            CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
            MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), cubeDDLStatements);
            metadataContext.setSchema(schema);
            metadataContext.setDatabase(databaseImpl);
            MetadataXML metadataXML = new MetadataXML(metadataContext);
            metadataXML.parse();
            metadataXML.executeSQL();
            Database database = dBObject.getDatabase();
            if (database instanceof AbstractDatabase) {
                AbstractDatabase abstractDatabase = (AbstractDatabase)database;
                SystemObject[] systemObjectArray = new SystemObject[]{abstractSchemaObjectWithDesc};
                SystemObject[] systemObjectArray2 = new SystemObject[]{abstractSchemaObjectWithDesc2};
                Difference difference = abstractDatabase.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            }
        }
    }

    protected void showErrorDialog(Throwable throwable) {
        Object object;
        StringWriter stringWriter;
        this.warn(throwable);
        String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
        if (string == null || string.isEmpty()) {
            stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            throwable.printStackTrace((PrintWriter)object);
            string = stringWriter.toString();
        }
        stringWriter = this.getDBObject();
        object = stringWriter.getObjectName();
        String string2 = this.getErrorTitle((String)object);
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }

    protected String getConfirmMessage(String string) {
        String string2 = OLAPArb.format("GENERIC_DROP_CONFIRMATION_MSG", string);
        return string2;
    }

    protected String getConfirmTitle(String string) {
        String string2 = OLAPArb.format("GENERIC_DROP_DLG_TITLE", string);
        return string2;
    }

    protected String getProgressMessage(String string) {
        String string2 = OLAPArb.format("GENERIC_DROP_PROGRESS_TITLE", string);
        return string2;
    }

    protected String getSuccessMessage(String string) {
        String string2 = OLAPArb.format("GENERIC_DROP_SUCCESS_MSG", string);
        return string2;
    }

    protected String getErrorTitle(String string) {
        String string2 = OLAPArb.format("GENERIC_DROP_ERROR_TITLE", string);
        return string2;
    }

    protected String getHelpID() {
        String string = "olap_drop_object";
        return string;
    }

    protected void createUpdatedSchemaObject() {
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = null;
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaObjectWithDescription();
        abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)abstractSchemaObjectWithDesc2);
        this.setSchemaUpdatedObjectWithDescription(abstractSchemaObjectWithDesc);
        this.editUpdatedSchemaObject(abstractSchemaObjectWithDesc);
    }

    protected void editUpdatedSchemaObject(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
    }

    protected Collection<String> getOLAPDDL(DBObject dBObject) throws Exception {
        this.createUpdatedSchemaObject();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        Database database = dBObject.getDatabase();
        DDLGenerator dDLGenerator = database.getDDLGenerator();
        ResultSet resultSet = database.getDiffEngine().diff((Object)abstractSchemaObjectWithDesc, (Object)abstractSchemaObjectWithDesc2).getResult();
        DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet);
        return dDL.getStatements();
    }

    protected String getOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        String string = "";
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        Collection<String> collection = this.getOLAPDDL(dBObject);
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        if (collection != null && !collection.isEmpty()) {
            CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
            MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), cubeDDLStatements);
            metadataContext.setSchema(schema);
            metadataContext.setDatabase(databaseImpl);
            MetadataXML metadataXML = new MetadataXML(metadataContext);
            metadataXML.parse();
            string = metadataXML.getSQLXML();
        }
        return string;
    }

    protected AbstractSchemaObjectWithDesc getSchemaObjectWithDescription() {
        return this.schemaObjectWithDesc;
    }

    protected void setSchemaObjectWithDescription(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        this.schemaObjectWithDesc = abstractSchemaObjectWithDesc;
    }

    protected AbstractSchemaObjectWithDesc getSchemaUpdatedObjectWithDescription() {
        return this.schemaUpdatedObjectWithDesc;
    }

    protected void setSchemaUpdatedObjectWithDescription(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        this.schemaUpdatedObjectWithDesc = abstractSchemaObjectWithDesc;
    }

    protected String getObjectName() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getObjectName();
        return string;
    }

    public String getSchemaObjectNameFromContext(String string) {
        String string2 = null;
        if (this.getContext().getElement() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)this.getContext().getElement();
            string2 = (String)objectNode.getProperty(string);
        }
        return string2;
    }

    protected boolean isRemoveNodeRequired() {
        return true;
    }
}

