/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.xml;

import java.io.Reader;
import oracle.ide.index.DataCollector;
import oracle.ide.index.Indexer;
import oracle.ide.index.IndexingContext;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.ModelUtil;

public class XMLIndexer
implements Indexer {
    @Override
    public void startIndexing(IndexingContext context) {
    }

    @Override
    public void endIndexing(IndexingContext context) {
    }

    @Override
    public void index(IndexingContext context, DataCollector data) {
        Object filterKey = context.getFilterKey();
        if (filterKey != null) {
            if ("xml.root.element".equals(filterKey) || "xml.root.namespace".equals(filterKey) || "xml.system.id".equals(filterKey)) {
                throw new UnsupportedOperationException("Filtering XML data is not supported");
            }
            return;
        }
        TextBuffer buffer = context.getTextBuffer();
        Reader reader = TextBufferFactory.createReader((ReadTextBuffer)buffer);
        StartElementPacket root = XMLUtil.getXMLRootElement((Reader)reader);
        if (root != null) {
            data.add("xml.all", 0, 0, 0, 0);
            if (ModelUtil.hasLength((String)root.localName)) {
                data.add("xml.root.element", root.localName.hashCode(), 0, 0, 0);
            }
            if (ModelUtil.hasLength((String)root.namespaceURI)) {
                data.add("xml.root.namespace", root.namespaceURI.hashCode(), 0, 0, 0);
            }
            if (ModelUtil.hasLength((String)root.systemId)) {
                data.add("xml.system.id", root.systemId.hashCode(), 0, 0, 0);
            }
        }
    }
}

