/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.ide.util.MetaClassAwareClassLoader;

public class MetaClass<T> {
    private final String _className;
    private final ClassLoader _classLoader;
    private Class _class;

    public static <N> MetaClass<N> newMetaClass(Class<N> clazz) {
        if (clazz == null) {
            return null;
        }
        MetaClass meta = new MetaClass(clazz.getClassLoader(), clazz.getName());
        meta._class = clazz;
        return meta;
    }

    public MetaClass(ClassLoader classLoader, String className) {
        if (classLoader == null) {
            throw new NullPointerException("null classLoader");
        }
        if (className == null) {
            throw new NullPointerException("null className");
        }
        this._classLoader = classLoader;
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Class toClass() throws ClassNotFoundException {
        return this.toClass(false);
    }

    public Class toClass(boolean triggerTopmostClassLoader) throws ClassNotFoundException {
        if (this._class == null) {
            this._class = this._classLoader instanceof MetaClassAwareClassLoader ? ((MetaClassAwareClassLoader)((Object)this._classLoader)).loadMetaClass(this._className, triggerTopmostClassLoader) : Class.forName(this._className, true, this._classLoader);
        }
        return this._class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T newInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class clazz = this.toClass();
        try {
            Constructor ctor = clazz.getDeclaredConstructor(new Class[0]);
            try {
                ctor.setAccessible(true);
                Object t = ctor.newInstance(null);
                return t;
            }
            finally {
                ctor.setAccessible(false);
            }
        }
        catch (InvocationTargetException e) {
            return clazz.newInstance();
        }
        catch (NoSuchMethodException nsme) {
            return clazz.newInstance();
        }
    }

    public String toString() {
        return "MetaClass[ classLoader=" + this._classLoader + ", className=" + this._className + "]";
    }

    public int hashCode() {
        int hash = 42;
        hash = 37 * hash + this._className.hashCode();
        hash = 37 * hash + this._classLoader.hashCode();
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MetaClass)) {
            return false;
        }
        MetaClass mc = (MetaClass)object;
        return mc._classLoader.equals(this._classLoader) && mc._className.equals(this._className);
    }
}

